/*
 * Decompiled with CFR 0.152.
 */
package mokiyoki.enhancedanimals.entity;

import com.google.common.collect.Sets;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import javax.annotation.Nullable;
import mokiyoki.enhancedanimals.entity.EnhancedChicken;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnhancedDog
extends EntityAnimal {
    private static final DataParameter<String> SHARED_GENES = EntityDataManager.func_187226_a(EnhancedChicken.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150440_ba), Item.func_150898_a((Block)Blocks.field_150423_aK), Item.func_150898_a((Block)Blocks.field_150329_H), Item.func_150898_a((Block)Blocks.field_150407_cf), Items.field_151172_bF, Items.field_151015_O});
    private static final int WTC = 90;
    private static final int GENES_LENGTH = 50;
    private int[] genes = new int[50];
    private int[] mateGenes = new int[50];
    private int[] mitosisGenes = new int[50];
    private int[] mateMitosisGenes = new int[50];

    public EnhancedDog(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.5f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 2.0));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.25, Items.field_151015_O, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.25));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHARED_GENES, (Object)new String());
    }

    public void setSharedGenes(int[] genes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < genes.length; ++i) {
            sb.append(genes[i]);
            if (i == genes.length - 1) continue;
            sb.append(",");
        }
        this.field_70180_af.func_187227_b(SHARED_GENES, (Object)sb.toString());
    }

    public int[] getSharedGenes() {
        String sharedGenes = ((String)this.field_70180_af.func_187225_a(SHARED_GENES)).toString();
        if (sharedGenes.isEmpty()) {
            return null;
        }
        String[] genesToSplit = sharedGenes.split(",");
        int[] sharedGenesArray = new int[genesToSplit.length];
        for (int i = 0; i < sharedGenesArray.length; ++i) {
            sharedGenesArray[i] = Integer.parseInt(genesToSplit[i]);
        }
        return sharedGenesArray;
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        this.mateGenes = ((EnhancedChicken)ageable).getGenes();
        this.mixMateMitosisGenes();
        this.mixMitosisGenes();
        EnhancedDog enhanceddog = new EnhancedDog(this.field_70170_p);
        enhanceddog.func_70873_a(0);
        int[] babyGenes = this.getPuppyGenes();
        enhanceddog.setGenes(babyGenes);
        enhanceddog.setSharedGenes(babyGenes);
        return enhanceddog;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList geneList = new NBTTagList();
        for (int i = 0; i < this.genes.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Gene", this.genes[i]);
            geneList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Genes", (NBTBase)geneList);
        NBTTagList mateGeneList = new NBTTagList();
        for (int i = 0; i < this.mateGenes.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Gene", this.mateGenes[i]);
            mateGeneList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("FatherGenes", (NBTBase)mateGeneList);
    }

    @SideOnly(value=Side.CLIENT)
    private void setTexturePaths() {
        int[] genesForText = this.getSharedGenes();
        if (genesForText == null || genesForText[4] == 6 && genesForText[5] == 6 || genesForText[12] == 2 && genesForText[13] == 2 || genesForText[0] == 1 || genesForText[1] == 1 || genesForText[0] == 2 || genesForText[1] == 2) {
            // empty if block
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagList geneList = compound.func_150295_c("Genes", 10);
        for (int i = 0; i < geneList.func_74745_c(); ++i) {
            int gene;
            NBTTagCompound nbttagcompound = geneList.func_150305_b(i);
            this.genes[i] = gene = nbttagcompound.func_74762_e("Gene");
        }
        NBTTagList mateGeneList = compound.func_150295_c("FatherGenes", 10);
        for (int i = 0; i < mateGeneList.func_74745_c(); ++i) {
            int gene;
            NBTTagCompound nbttagcompound = mateGeneList.func_150305_b(i);
            this.mateGenes[i] = gene = nbttagcompound.func_74762_e("Gene");
        }
        this.setSharedGenes(this.genes);
    }

    public void mixMitosisGenes() {
        this.punnetSquare(this.mitosisGenes, this.genes);
    }

    public void mixMateMitosisGenes() {
        this.punnetSquare(this.mateMitosisGenes, this.mateGenes);
    }

    public void punnetSquare(int[] mitosis, int[] parentGenes) {
        Random rand = new Random();
        for (int i = 20; i < this.genes.length; i += 2) {
            boolean mateOddOrEven = rand.nextBoolean();
            if (mateOddOrEven) {
                mitosis[i] = parentGenes[i + 1];
                mitosis[i + 1] = parentGenes[i];
                continue;
            }
            mitosis[i] = parentGenes[i];
            mitosis[i + 1] = parentGenes[i + 1];
        }
    }

    public int[] getPuppyGenes() {
        boolean thisOrMate;
        int i;
        Random rand = new Random();
        int[] puppyGenes = new int[50];
        for (i = 0; i < 20; ++i) {
            thisOrMate = rand.nextBoolean();
            puppyGenes[i] = thisOrMate ? this.genes[i] : this.mateGenes[i];
        }
        for (i = 20; i < this.genes.length; ++i) {
            thisOrMate = rand.nextBoolean();
            puppyGenes[i] = thisOrMate ? this.mitosisGenes[i] : this.mateMitosisGenes[i];
        }
        return puppyGenes;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int[] spawnGenes;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) instanceof EnhancedChicken.GroupData) {
            spawnGenes = ((EnhancedChicken.GroupData)livingdata).groupGenes;
        } else {
            spawnGenes = this.createInitialGenes();
            livingdata = new EnhancedChicken.GroupData(spawnGenes);
        }
        this.genes = spawnGenes;
        this.setSharedGenes(this.genes);
        return livingdata;
    }

    private int[] createInitialGenes() {
        int[] initialGenes = new int[50];
        boolean wildType = false;
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        if (biome.func_185353_n() >= 0.9f && biome.func_76727_i() > 0.8f) {
            wildType = true;
        }
        initialGenes[0] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[1] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        return initialGenes;
    }

    public void setGenes(int[] genes) {
        this.genes = genes;
    }

    public int[] getGenes() {
        return this.genes;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int[] groupGenes;

        public GroupData(int[] groupGenes) {
            this.groupGenes = groupGenes;
        }
    }
}

