/*
 * Decompiled with CFR 0.152.
 */
package mokiyoki.enhancedanimals.entity;

import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.pathfinding.PathNodeType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundEvent;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnhancedRabbit
extends EntityAnimal {
    private static final DataParameter<String> SHARED_GENES = EntityDataManager.func_187226_a(EnhancedRabbit.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final String[] RABBIT_TEXTURES_UNDER = new String[]{"under_cream.png", "under_grey.png", "under_white.png"};
    private static final String[] RABBIT_TEXTURES_LOWER = new String[]{""};
    private static final String[] RABBIT_TEXTURES_MIDDLE = new String[]{"", "middle_orange.png", "middle_orangetan.png", "middle_orangeagouti.png", "under_cream.png", "middle_creamtan.png", "middle_creamagouti.png", "under_white.png", "middle_whitetan.png", "middle_whiteagouti.png"};
    private static final String[] RABBIT_TEXTURES_HIGHER = new String[]{"", "higher_agouti.png", "higher_tan.png", "higher_self.png", "higher_agouti_blue.png", "higher_tan_blue.png", "higher_self_blue.png", "higher_agouti_choc.png", "higher_tan_choc.png", "higher_self_choc.png", "higher_agouti_lilac.png", "higher_tan_lilac.png", "higher_self_lilac.png", "higher_agoutiseal.png", "higher_tanseal.png", "higher_selfseal.png", "higher_agoutiseal_blue.png", "higher_tanseal_blue.png", "higher_selfseal_blue.png", "higher_agoutiseal_choc.png", "higher_tanseal_choc.png", "higher_selfseal_choc.png", "higher_agoutiseal_lilac.png", "higher_tanseal_lilac.png", "higher_selfseal_lilac.png", "higher_agoutisable.png", "higher_tansable.png", "higher_selfsable.png", "higher_agoutisable_blue.png", "higher_tansable_blue.png", "higher_selfsable_blue.png", "higher_agoutisable_choc.png", "higher_tansable_choc.png", "higher_selfsable_choc.png", "higher_agoutisable_lilac.png", "higher_tansable_lilac.png", "higher_selfsable_lilac.png", "higher_agoutihimy.png", "higher_tanhimy.png", "higher_selfhimy.png", "higher_agoutihimy_blue.png", "higher_tanhimy_blue.png", "higher_selfhimy_blue.png", "higher_agoutihimy_choc.png", "higher_tanhimy_choc.png", "higher_selfhimy_choc.png", "higher_agoutihimy_lilac.png", "higher_tanhimy_lilac.png", "higher_selfhimy_lilac.png"};
    private static final String[] RABBIT_TEXTURES_TOP = new String[]{"", "top_steal.png", "top_stealdark.png", "top_tan.png", "top_self.png", "top_steal_blue.png", "top_stealdark_blue.png", "top_tan_blue.png", "top_self_blue.png", "top_steal_choc.png", "top_stealdark_choc.png", "top_tan_choc.png", "top_self_choc.png", "top_steal_lilac.png", "top_stealdark_lilac.png", "top_tan_lilac.png", "top_self_lilac.png", "top_harly0.png", "top_harly1.png", "top_harly2.png", "top_harly3.png", "top_harly4.png", "top_harly5.png", "top_harly6.png", "top_harly7.png", "top_harly8.png", "top_harly9.png", "top_harlya.png", "top_harlyb.png", "top_harlyc.png", "top_harlyd.png", "top_harlye.png", "top_harlyf.png", "top_harly0_blue.png", "top_harly1_blue.png", "top_harly2_blue.png", "top_harly3_blue.png", "top_harly4_blue.png", "top_harly5_blue.png", "top_harly6_blue.png", "top_harly7_blue.png", "top_harly8_blue.png", "top_harly9_blue.png", "top_harlya_blue.png", "top_harlyb_blue.png", "top_harlyc_blue.png", "top_harlyd_blue.png", "top_harlye_blue.png", "top_harlyf_blue.png", "top_harly0_choc.png", "top_harly1_choc.png", "top_harly2_choc.png", "top_harly3_choc.png", "top_harly4_choc.png", "top_harly5_choc.png", "top_harly6_choc.png", "top_harly7_choc.png", "top_harly8_choc.png", "top_harly9_choc.png", "top_harlya_choc.png", "top_harlyb_choc.png", "top_harlyc_choc.png", "top_harlyd_choc.png", "top_harlye_choc.png", "top_harlyf_choc.png", "top_harly0_lilac.png", "top_harly1_lilac.png", "top_harly2_lilac.png", "top_harly3_lilac.png", "top_harly4_lilac.png", "top_harly5_lilac.png", "top_harly6_lilac.png", "top_harly7_lilac.png", "top_harly8_lilac.png", "top_harly9_lilac.png", "top_harlya_lilac.png", "top_harlyb_lilac.png", "top_harlyc_lilac.png", "top_harlyd_lilac.png", "top_harlye_lilac.png", "top_harlyf_lilac.png"};
    private static final String[] RABBIT_TEXTURES_DUTCH = new String[]{"", "dutch0.png", "dutch1.png", "dutch2.png", "dutch3.png", "dutch4.png", "dutch5.png", "dutch6.png", "dutch7.png", "dutch8.png", "dutch9.png", "dutcha.png", "dutchb.png", "dutchc.png", "dutchd.png", "dutche.png", "dutchf.png"};
    private static final String[] RABBIT_TEXTURES_BROKEN = new String[]{"", "broken0.png", "broken1.png", "broken2.png", "broken3.png", "broken4.png", "broken5.png", "broken6.png", "broken7.png", "broken8.png", "broken9.png", "brokena.png", "brokenb.png", "brokenc.png", "brokend.png", "brokene.png", "brokenf.png", "charlie0.png", "charlie1.png", "charlie2.png", "charlie3.png", "charlie4.png", "charlie5.png", "charlie6.png", "charlie7.png", "charlie8.png", "charlie9.png", "charliea.png", "charlieb.png", "charliec.png", "charlied.png", "charliee.png", "charlief.png"};
    private static final String[] RABBIT_TEXTURES_VIENNA = new String[]{"", "vienna0.png", "vienna1.png", "vienna2.png", "vienna3.png", "vienna4.png", "vienna5.png", "vienna6.png", "vienna7.png", "vienna8.png", "vienna9.png", "viennaa.png", "viennab.png", "viennac.png", "viennad.png", "viennae.png", "viennaf.png"};
    private static final String[] RABBIT_TEXTURES_FUR = new String[]{"", "fur_angora.png", "fur_normal.png", "fur_satin.png"};
    private static final String[] RABBIT_TEXTURES_EYES = new String[]{"eyes_black.png", "eyes_grey.png", "eyes_albino.png"};
    private static final String[] RABBIT_TEXTURES_VIENNAEYES = new String[]{"", "", "", "", "", "", "", "", "eyes_blue.png", "eyes_blue.png", "eyes_blue.png", "eyes_blue.png", "eyes_bluel.png", "eyes_bluel.png", "eyes_bluel.png", "eyes_bluer.png", "eyes_bluer.png", "eyes_bluer.png"};
    private static final String[] RABBIT_TEXTURES_SKIN = new String[]{"skin_pink.png", "skin_brown.png", "skin_white.png"};
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150327_N), Item.func_150898_a((Block)Blocks.field_150329_H), Items.field_151172_bF});
    private final List<String> rabbitTextures = new ArrayList<String>();
    public float destPos;
    private static final int WTC = 90;
    private static final int GENES_LENGTH = 50;
    private int[] genes = new int[50];
    private int[] mateGenes = new int[50];
    private int[] mitosisGenes = new int[50];
    private int[] mateMitosisGenes = new int[50];

    public EnhancedRabbit(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 0.5f);
        this.func_184644_a(PathNodeType.WATER, 0.0f);
    }

    protected void func_184651_r() {
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 0.8));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151172_bF, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Items.field_151150_bK, false));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.0, Item.func_150898_a((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 0.6));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 10.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHARED_GENES, (Object)new String());
    }

    public void setSharedGenes(int[] genes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < genes.length; ++i) {
            sb.append(genes[i]);
            if (i == genes.length - 1) continue;
            sb.append(",");
        }
        this.field_70180_af.func_187227_b(SHARED_GENES, (Object)sb.toString());
    }

    public int[] getSharedGenes() {
        String sharedGenes = ((String)this.field_70180_af.func_187225_a(SHARED_GENES)).toString();
        if (sharedGenes.isEmpty()) {
            return null;
        }
        String[] genesToSplit = sharedGenes.split(",");
        int[] sharedGenesArray = new int[genesToSplit.length];
        for (int i = 0; i < sharedGenesArray.length; ++i) {
            sharedGenesArray[i] = Integer.parseInt(genesToSplit[i]);
        }
        return sharedGenesArray;
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(4.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a(0.25);
    }

    public void func_70636_d() {
        super.func_70636_d();
        this.destPos = (float)((double)this.destPos + (double)(this.field_70122_E ? -1 : 4) * 0.3);
        this.destPos = MathHelper.func_76131_a((float)this.destPos, (float)0.0f, (float)1.0f);
    }

    public void func_180430_e(float distance, float damageMultiplier) {
    }

    protected SoundEvent func_184639_G() {
        return SoundEvents.field_187816_ej;
    }

    protected SoundEvent func_184601_bQ(DamageSource damageSourceIn) {
        return SoundEvents.field_187822_em;
    }

    protected SoundEvent func_184615_bR() {
        return SoundEvents.field_187820_el;
    }

    protected void func_180429_a(BlockPos pos, Block blockIn) {
        this.func_184185_a(SoundEvents.field_187824_en, 0.15f, 1.0f);
    }

    public boolean func_70877_b(ItemStack stack) {
        return TEMPTATION_ITEMS.contains(stack.func_77973_b());
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        this.mateGenes = ((EnhancedRabbit)ageable).getGenes();
        this.mixMateMitosisGenes();
        this.mixMitosisGenes();
        EnhancedRabbit enhancedrabbit = new EnhancedRabbit(this.field_70170_p);
        enhancedrabbit.func_70873_a(0);
        int[] babyGenes = this.getBunnyGenes();
        enhancedrabbit.setGenes(babyGenes);
        enhancedrabbit.setSharedGenes(babyGenes);
        return enhancedrabbit;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        NBTTagList geneList = new NBTTagList();
        for (int i = 0; i < this.genes.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Gene", this.genes[i]);
            geneList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Genes", (NBTBase)geneList);
        NBTTagList mateGeneList = new NBTTagList();
        for (int i = 0; i < this.mateGenes.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Gene", this.mateGenes[i]);
            mateGeneList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("FatherGenes", (NBTBase)mateGeneList);
    }

    @SideOnly(value=Side.CLIENT)
    public String getRabbitTexture() {
        if (this.rabbitTextures.isEmpty()) {
            this.setTexturePaths();
        }
        return this.rabbitTextures.stream().collect(Collectors.joining(", ", "[", "]"));
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getVariantTexturePaths() {
        if (this.rabbitTextures.isEmpty()) {
            this.setTexturePaths();
        }
        return (String[])this.rabbitTextures.stream().toArray(String[]::new);
    }

    @SideOnly(value=Side.CLIENT)
    private void setTexturePaths() {
        int[] genesForText = this.getSharedGenes();
        if (genesForText != null) {
            int under = 0;
            boolean lower = false;
            int middle = 0;
            int higher = 0;
            int top = 0;
            int dutch = 0;
            int broken = 0;
            int vienna = 0;
            int fur = 0;
            int eyes = 0;
            int vieye = 0;
            int skin = 0;
            int UNDER = 3;
            int HIGH = 3;
            int TOPS = 4;
            int shade = 0;
            int c = 0;
            char[] uuidArry = this.func_189512_bd().toCharArray();
            if (genesForText[4] == 5 && genesForText[5] == 5) {
                under = 2;
                eyes = 2;
            } else if (genesForText[14] == 2 && genesForText[15] == 2) {
                under = 2;
                vieye = 8;
            } else {
                char d;
                if (genesForText[2] == 2 && genesForText[3] == 2) {
                    if (genesForText[6] == 2 && genesForText[7] == 2) {
                        shade = 3;
                        eyes = 1;
                    } else {
                        shade = 2;
                    }
                } else if (genesForText[6] == 2 && genesForText[7] == 2) {
                    shade = 1;
                    eyes = 1;
                }
                if (genesForText[8] == 1 || genesForText[9] == 1) {
                    top = genesForText[8] == 1 && genesForText[9] == 1 ? 2 + TOPS * shade : 1 + TOPS * shade;
                    middle = genesForText[4] == 1 || genesForText[5] == 1 ? 1 : 7;
                } else if (genesForText[8] != 2 && genesForText[9] != 2 && (genesForText[8] == 3 || genesForText[9] == 3)) {
                    top = 17 + 16 * shade;
                    middle = genesForText[4] == 1 || genesForText[5] == 1 ? 1 : 7;
                } else {
                    if (genesForText[4] > 2 && genesForText[5] > 2) {
                        c = genesForText[4] == 3 && genesForText[5] == 3 ? 13 : (genesForText[4] == 3 || genesForText[5] == 3 ? 26 : 39);
                    }
                    if (genesForText[0] == 1 || genesForText[1] == 1) {
                        if (genesForText[8] == 4 && genesForText[9] == 4) {
                            higher = 0;
                            top = 0;
                            middle = genesForText[4] == 1 || genesForText[5] == 1 ? 1 : 7;
                        } else {
                            higher = 1;
                            middle = genesForText[4] == 1 || genesForText[5] == 1 ? 3 : 9;
                        }
                    } else if (genesForText[0] == 2 || genesForText[1] == 2) {
                        if (genesForText[8] == 4 && genesForText[9] == 4) {
                            top = 3 + TOPS * shade;
                            middle = genesForText[4] == 1 || genesForText[5] == 1 ? 1 : 2;
                        } else {
                            higher = 2;
                            middle = genesForText[4] == 1 || genesForText[5] == 1 ? 2 : 8;
                        }
                    } else if (genesForText[8] == 4 && genesForText[9] == 4) {
                        top = 4 + TOPS * shade;
                        middle = genesForText[4] == 1 || genesForText[5] == 1 ? 1 : 2;
                    } else {
                        higher = 3;
                        middle = genesForText[4] == 1 || genesForText[5] == 1 ? 1 : 7;
                    }
                }
                if (higher != 0) {
                    higher = higher + HIGH * shade + c;
                }
                if (genesForText[4] >= 4 && genesForText[5] >= 4) {
                    eyes = 2;
                }
                if (genesForText[14] == 2 || genesForText[15] == 2) {
                    if (genesForText[4] < 4 && genesForText[5] < 4) {
                        if (Character.isDigit(uuidArry[1])) {
                            vieye = 1 + (uuidArry[1] - 48);
                        } else {
                            d = uuidArry[1];
                            switch (d) {
                                case 'a': {
                                    vieye = 11;
                                    break;
                                }
                                case 'b': {
                                    vieye = 12;
                                    break;
                                }
                                case 'c': {
                                    vieye = 13;
                                    break;
                                }
                                case 'd': {
                                    vieye = 14;
                                    break;
                                }
                                case 'e': {
                                    vieye = 15;
                                    break;
                                }
                                case 'f': {
                                    vieye = 16;
                                    break;
                                }
                                default: {
                                    vieye = 0;
                                }
                            }
                        }
                    }
                    if (Character.isDigit(uuidArry[2])) {
                        if (Character.isDigit(uuidArry[3])) {
                            vienna = 1 + (uuidArry[3] - 48);
                        } else {
                            d = uuidArry[3];
                            switch (d) {
                                case 'a': {
                                    vienna = 11;
                                    break;
                                }
                                case 'b': {
                                    vienna = 12;
                                    break;
                                }
                                case 'c': {
                                    vienna = 13;
                                    break;
                                }
                                case 'd': {
                                    vienna = 14;
                                    break;
                                }
                                case 'e': {
                                    vienna = 15;
                                    break;
                                }
                                case 'f': {
                                    vienna = 16;
                                    break;
                                }
                                default: {
                                    vienna = 0;
                                }
                            }
                        }
                    }
                }
                if (genesForText[10] == 2 || genesForText[11] == 2) {
                    if (Character.isDigit(uuidArry[5])) {
                        broken = 1 + (uuidArry[5] - 48);
                    } else {
                        d = uuidArry[5];
                        switch (d) {
                            case 'a': {
                                broken = 11;
                                break;
                            }
                            case 'b': {
                                broken = 12;
                                break;
                            }
                            case 'c': {
                                broken = 13;
                                break;
                            }
                            case 'd': {
                                broken = 14;
                                break;
                            }
                            case 'e': {
                                broken = 15;
                                break;
                            }
                            case 'f': {
                                broken = 16;
                                break;
                            }
                            default: {
                                broken = 0;
                            }
                        }
                    }
                    if (genesForText[10] == 2 && genesForText[11] == 2) {
                        broken += 16;
                    }
                }
                if (genesForText[12] == 2 && genesForText[13] == 2) {
                    if (Character.isDigit(uuidArry[5])) {
                        dutch = 1 + (uuidArry[5] - 48);
                    } else {
                        d = uuidArry[5];
                        switch (d) {
                            case 'a': {
                                dutch = 11;
                                break;
                            }
                            case 'b': {
                                dutch = 12;
                                break;
                            }
                            case 'c': {
                                dutch = 13;
                                break;
                            }
                            case 'd': {
                                dutch = 14;
                                break;
                            }
                            case 'e': {
                                dutch = 15;
                                break;
                            }
                            case 'f': {
                                dutch = 16;
                                break;
                            }
                            default: {
                                dutch = 0;
                            }
                        }
                    }
                }
                if (genesForText[4] != 1 && genesForText[5] != 1) {
                    under = 2;
                    middle = 0;
                    if (genesForText[4] < 4 && genesForText[5] < 4) {
                        eyes = 5;
                    } else if (genesForText[4] < 2 && genesForText[5] < 2) {
                        eyes = 4;
                    }
                }
            }
            if (genesForText[28] == 2 && genesForText[29] == 2) {
                fur = 1;
            } else if (genesForText[26] == 1 || genesForText[27] == 1) {
                fur = genesForText[30] == 2 && genesForText[31] == 2 ? 3 : 2;
            }
            this.rabbitTextures.add(RABBIT_TEXTURES_UNDER[under]);
            if (middle != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_MIDDLE[middle]);
            }
            if (higher != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_HIGHER[higher]);
            }
            if (top != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_TOP[top]);
            }
            if (dutch != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_DUTCH[dutch]);
            }
            if (broken != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_BROKEN[broken]);
            }
            if (vienna != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_VIENNA[vienna]);
            }
            if (fur != 0) {
                this.rabbitTextures.add(RABBIT_TEXTURES_FUR[fur]);
            }
            this.rabbitTextures.add(RABBIT_TEXTURES_EYES[eyes]);
            if (vieye > 7) {
                this.rabbitTextures.add(RABBIT_TEXTURES_VIENNAEYES[vieye]);
            }
            this.rabbitTextures.add(RABBIT_TEXTURES_SKIN[skin]);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        NBTTagList geneList = compound.func_150295_c("Genes", 10);
        for (int i = 0; i < geneList.func_74745_c(); ++i) {
            int gene;
            NBTTagCompound nbttagcompound = geneList.func_150305_b(i);
            this.genes[i] = gene = nbttagcompound.func_74762_e("Gene");
        }
        NBTTagList mateGeneList = compound.func_150295_c("FatherGenes", 10);
        for (int i = 0; i < mateGeneList.func_74745_c(); ++i) {
            int gene;
            NBTTagCompound nbttagcompound = mateGeneList.func_150305_b(i);
            this.mateGenes[i] = gene = nbttagcompound.func_74762_e("Gene");
        }
        this.setSharedGenes(this.genes);
    }

    public void mixMitosisGenes() {
        this.punnetSquare(this.mitosisGenes, this.genes);
    }

    public void mixMateMitosisGenes() {
        this.punnetSquare(this.mateMitosisGenes, this.mateGenes);
    }

    public void punnetSquare(int[] mitosis, int[] parentGenes) {
        Random rand = new Random();
        for (int i = 0; i < this.genes.length; i += 2) {
            boolean mateOddOrEven = rand.nextBoolean();
            if (mateOddOrEven) {
                mitosis[i] = parentGenes[i + 1];
                mitosis[i + 1] = parentGenes[i];
                continue;
            }
            mitosis[i] = parentGenes[i];
            mitosis[i + 1] = parentGenes[i + 1];
        }
    }

    public int[] getBunnyGenes() {
        Random rand = new Random();
        int[] bunnyGenes = new int[50];
        for (int i = 0; i < this.genes.length; ++i) {
            boolean thisOrMate = rand.nextBoolean();
            bunnyGenes[i] = thisOrMate ? this.mitosisGenes[i] : this.mateMitosisGenes[i];
        }
        return bunnyGenes;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int[] spawnGenes;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) instanceof GroupData) {
            spawnGenes = ((GroupData)livingdata).groupGenes;
        } else {
            spawnGenes = this.createInitialGenes();
            livingdata = new GroupData(spawnGenes);
        }
        this.genes = spawnGenes;
        this.setSharedGenes(this.genes);
        return livingdata;
    }

    private int[] createInitialGenes() {
        int[] initialGenes = new int[50];
        boolean wildType = false;
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        if (biome.func_185353_n() < 0.3f) {
            wildType = true;
        }
        initialGenes[0] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[1] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[2] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[3] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[4] = ThreadLocalRandom.current().nextInt(100) > 90 ? (!wildType ? ThreadLocalRandom.current().nextInt(5) + 1 : ThreadLocalRandom.current().nextInt(3) + 3) : (!wildType ? 1 : 2);
        initialGenes[5] = ThreadLocalRandom.current().nextInt(100) > 90 ? (!wildType ? ThreadLocalRandom.current().nextInt(5) + 1 : ThreadLocalRandom.current().nextInt(3) + 2) : (!wildType ? 1 : 2);
        initialGenes[6] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[7] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[8] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(4) + 1 : 2;
        initialGenes[9] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(4) + 1 : 2;
        initialGenes[10] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[11] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[12] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[13] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[14] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[15] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[16] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[17] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[18] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[19] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[20] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[21] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[22] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[23] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[24] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : (wildType ? 2 : 1);
        initialGenes[25] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[26] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : (wildType ? 2 : 1);
        initialGenes[27] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[28] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[29] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[30] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[31] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[34] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[35] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[36] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[37] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[38] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[39] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[40] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[41] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[42] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[43] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[44] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[45] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[46] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(5) + 1 : 2;
        initialGenes[47] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(5) + 1 : 2;
        initialGenes[48] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 2;
        initialGenes[49] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 2;
        return initialGenes;
    }

    public void setGenes(int[] genes) {
        this.genes = genes;
    }

    public int[] getGenes() {
        return this.genes;
    }

    public static class GroupData
    implements IEntityLivingData {
        public int[] groupGenes;

        public GroupData(int[] groupGenes) {
            this.groupGenes = groupGenes;
        }
    }
}

