/*
 * Decompiled with CFR 0.152.
 */
package mokiyoki.enhancedanimals.entity;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIEatGrass;
import net.minecraft.entity.ai.EntityAIFollowParent;
import net.minecraft.entity.ai.EntityAILookIdle;
import net.minecraft.entity.ai.EntityAIMate;
import net.minecraft.entity.ai.EntityAIPanic;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITempt;
import net.minecraft.entity.ai.EntityAIWanderAvoidWater;
import net.minecraft.entity.ai.EntityAIWatchClosest;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.DifficultyInstance;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnhancedSheep
extends EntityAnimal
implements IShearable {
    private static final DataParameter<String> SHARED_GENES = EntityDataManager.func_187226_a(EnhancedSheep.class, (DataSerializer)DataSerializers.field_187194_d);
    private static final DataParameter<Byte> DYE_COLOR = EntityDataManager.func_187226_a(EnhancedSheep.class, (DataSerializer)DataSerializers.field_187191_a);
    private static final Set<Item> TEMPTATION_ITEMS = Sets.newHashSet((Object[])new Item[]{Item.func_150898_a((Block)Blocks.field_150440_ba), Item.func_150898_a((Block)Blocks.field_150423_aK), Item.func_150898_a((Block)Blocks.field_150329_H), Item.func_150898_a((Block)Blocks.field_150407_cf), Items.field_151172_bF, Items.field_151015_O});
    private static final Map<EnumDyeColor, float[]> DYE_TO_RGB = Maps.newEnumMap(EnumDyeColor.class);
    private static final int WTC = 90;
    private final List<String> sheepTextures = new ArrayList<String>();
    private final List<String> sheepFleeceTextures = new ArrayList<String>();
    private static final int GENES_LENGTH = 50;
    private int[] genes = new int[50];
    private int[] mateGenes = new int[50];
    private int[] mitosisGenes = new int[50];
    private int[] mateMitosisGenes = new int[50];
    private int sheepTimer;
    private EntityAIEatGrass entityAIEatGrass;

    public EnhancedSheep(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.4f, 1.0f);
    }

    public float func_70047_e() {
        return this.field_70131_O;
    }

    protected void func_184651_r() {
        this.entityAIEatGrass = new EntityAIEatGrass((EntityLiving)this);
        this.field_70714_bg.func_75776_a(0, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(1, (EntityAIBase)new EntityAIPanic((EntityCreature)this, 1.25));
        this.field_70714_bg.func_75776_a(2, (EntityAIBase)new EntityAIMate((EntityAnimal)this, 1.0));
        this.field_70714_bg.func_75776_a(3, (EntityAIBase)new EntityAITempt((EntityCreature)this, 1.1, Items.field_151015_O, false));
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new EntityAIFollowParent((EntityAnimal)this, 1.1));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)this.entityAIEatGrass);
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new EntityAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new EntityAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(8, (EntityAIBase)new EntityAILookIdle((EntityLiving)this));
    }

    protected void func_70619_bc() {
        this.sheepTimer = this.entityAIEatGrass.func_151499_f();
        super.func_70619_bc();
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHARED_GENES, (Object)new String());
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)0);
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(8.0);
        this.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111128_a((double)0.23f);
    }

    public void func_70636_d() {
        if (this.field_70170_p.field_72995_K) {
            this.sheepTimer = Math.max(0, this.sheepTimer - 1);
        }
        super.func_70636_d();
    }

    public void setSharedGenes(int[] genes) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < genes.length; ++i) {
            sb.append(genes[i]);
            if (i == genes.length - 1) continue;
            sb.append(",");
        }
        this.field_70180_af.func_187227_b(SHARED_GENES, (Object)sb.toString());
    }

    public int[] getSharedGenes() {
        String sharedGenes = ((String)this.field_70180_af.func_187225_a(SHARED_GENES)).toString();
        if (sharedGenes.isEmpty()) {
            return null;
        }
        String[] genesToSplit = sharedGenes.split(",");
        int[] sharedGenesArray = new int[genesToSplit.length];
        for (int i = 0; i < sharedGenesArray.length; ++i) {
            sharedGenesArray[i] = Integer.parseInt(genesToSplit[i]);
        }
        return sharedGenesArray;
    }

    public EnumDyeColor getFleeceColor() {
        return EnumDyeColor.func_176764_b((int)((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0xF));
    }

    public void setFleeceColor(EnumDyeColor color) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xF0 | color.func_176765_a() & 0xF)));
    }

    @SideOnly(value=Side.CLIENT)
    public static float[] getDyeRgb(EnumDyeColor dyeColor) {
        return DYE_TO_RGB.get(dyeColor);
    }

    public EntityAgeable func_90011_a(EntityAgeable ageable) {
        this.mateGenes = ((EnhancedSheep)ageable).getGenes();
        this.mixMateMitosisGenes();
        this.mixMitosisGenes();
        EnhancedSheep enhancedsheep = new EnhancedSheep(this.field_70170_p);
        enhancedsheep.func_70873_a(0);
        int[] babyGenes = this.getLambGenes();
        enhancedsheep.setGenes(babyGenes);
        enhancedsheep.setSharedGenes(babyGenes);
        return enhancedsheep;
    }

    private static float[] createSheepColor(EnumDyeColor dyeColor) {
        float[] afloat = dyeColor.func_193349_f();
        float f = 0.75f;
        return new float[]{afloat[0] * 0.75f, afloat[1] * 0.75f, afloat[2] * 0.75f};
    }

    public boolean getSheared() {
        return ((Byte)this.field_70180_af.func_187225_a(DYE_COLOR) & 0x10) != 0;
    }

    @SideOnly(value=Side.CLIENT)
    public String getSheepTexture() {
        if (this.sheepTextures.isEmpty()) {
            this.setTexturePaths();
        }
        return this.sheepTextures.stream().collect(Collectors.joining(", ", "[", "]"));
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getVariantTexturePaths() {
        if (this.sheepTextures.isEmpty()) {
            this.setTexturePaths();
        }
        return (String[])this.sheepTextures.stream().toArray(String[]::new);
    }

    @SideOnly(value=Side.CLIENT)
    private void setTexturePaths() {
        this.sheepTextures.add("sheep.png");
    }

    @SideOnly(value=Side.CLIENT)
    public String getSheepFleeceTexture() {
        if (this.sheepFleeceTextures.isEmpty()) {
            this.setFleeceTexturePaths();
        }
        return this.sheepFleeceTextures.stream().collect(Collectors.joining(", ", "[", "]"));
    }

    @SideOnly(value=Side.CLIENT)
    public String[] getVariantFleeceTexturePaths() {
        if (this.sheepFleeceTextures.isEmpty()) {
            this.setFleeceTexturePaths();
        }
        return (String[])this.sheepFleeceTextures.stream().toArray(String[]::new);
    }

    @SideOnly(value=Side.CLIENT)
    private void setFleeceTexturePaths() {
        this.sheepFleeceTextures.add("sheep_wool.png");
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.sheepTimer = 40;
        } else {
            super.func_70103_a(id);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationPointY(float partialTickTime) {
        if (this.sheepTimer <= 0) {
            return 0.0f;
        }
        if (this.sheepTimer >= 4 && this.sheepTimer <= 36) {
            return 1.0f;
        }
        return this.sheepTimer < 4 ? ((float)this.sheepTimer - partialTickTime) / 4.0f : -((float)(this.sheepTimer - 40) - partialTickTime) / 4.0f;
    }

    @SideOnly(value=Side.CLIENT)
    public float getHeadRotationAngleX(float partialTickTime) {
        if (this.sheepTimer > 4 && this.sheepTimer <= 36) {
            float f = ((float)(this.sheepTimer - 4) - partialTickTime) / 32.0f;
            return 0.62831855f + 0.2199115f * MathHelper.func_76126_a((float)(f * 28.7f));
        }
        return this.sheepTimer > 0 ? 0.62831855f : this.field_70125_A * ((float)Math.PI / 180);
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack itemstack = player.func_184586_b(hand);
        if (itemstack.func_77973_b() instanceof ItemDye && !this.func_70631_g_() && !this.getSheared()) {
            EnumDyeColor col = EnumDyeColor.func_176766_a((int)itemstack.func_77952_i());
            if (this.getFleeceColor() != col) {
                if (!player.func_184812_l_()) {
                    itemstack.func_190918_g(1);
                }
                this.setFleeceColor(col);
                return true;
            }
            return true;
        }
        return super.func_184645_a(player, hand);
    }

    public void setSheared(boolean sheared) {
        byte b0 = (Byte)this.field_70180_af.func_187225_a(DYE_COLOR);
        if (sheared) {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 | 0x10)));
        } else {
            this.field_70180_af.func_187227_b(DYE_COLOR, (Object)((byte)(b0 & 0xFFFFFFEF)));
        }
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.getSheared() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        this.setSheared(true);
        int i = 1 + this.field_70146_Z.nextInt(3);
        ArrayList<ItemStack> ret = new ArrayList<ItemStack>();
        for (int j = 0; j < i; ++j) {
            ret.add(new ItemStack(Item.func_150898_a((Block)Blocks.field_150325_L), 1, this.getFleeceColor().func_176765_a()));
        }
        this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
        return ret;
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.getSheared());
        compound.func_74774_a("Colour", (byte)this.getFleeceColor().func_176765_a());
        NBTTagList geneList = new NBTTagList();
        for (int i = 0; i < this.genes.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Gene", this.genes[i]);
            geneList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("Genes", (NBTBase)geneList);
        NBTTagList mateGeneList = new NBTTagList();
        for (int i = 0; i < this.mateGenes.length; ++i) {
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74768_a("Gene", this.mateGenes[i]);
            mateGeneList.func_74742_a((NBTBase)nbttagcompound);
        }
        compound.func_74782_a("FatherGenes", (NBTBase)mateGeneList);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setSheared(compound.func_74767_n("Sheared"));
        this.setFleeceColor(EnumDyeColor.func_176764_b((int)compound.func_74771_c("Color")));
        NBTTagList geneList = compound.func_150295_c("Genes", 10);
        for (int i = 0; i < geneList.func_74745_c(); ++i) {
            int gene;
            NBTTagCompound nbttagcompound = geneList.func_150305_b(i);
            this.genes[i] = gene = nbttagcompound.func_74762_e("Gene");
        }
        NBTTagList mateGeneList = compound.func_150295_c("FatherGenes", 10);
        for (int i = 0; i < mateGeneList.func_74745_c(); ++i) {
            int gene;
            NBTTagCompound nbttagcompound = mateGeneList.func_150305_b(i);
            this.mateGenes[i] = gene = nbttagcompound.func_74762_e("Gene");
        }
        this.setSharedGenes(this.genes);
    }

    public void mixMitosisGenes() {
        this.punnetSquare(this.mitosisGenes, this.genes);
    }

    public void mixMateMitosisGenes() {
        this.punnetSquare(this.mateMitosisGenes, this.mateGenes);
    }

    public void punnetSquare(int[] mitosis, int[] parentGenes) {
        Random rand = new Random();
        for (int i = 20; i < this.genes.length; i += 2) {
            boolean mateOddOrEven = rand.nextBoolean();
            if (mateOddOrEven) {
                mitosis[i] = parentGenes[i + 1];
                mitosis[i + 1] = parentGenes[i];
                continue;
            }
            mitosis[i] = parentGenes[i];
            mitosis[i + 1] = parentGenes[i + 1];
        }
    }

    public int[] getLambGenes() {
        boolean thisOrMate;
        int i;
        Random rand = new Random();
        int[] lambGenes = new int[50];
        for (i = 0; i < 20; ++i) {
            thisOrMate = rand.nextBoolean();
            lambGenes[i] = thisOrMate ? this.genes[i] : this.mateGenes[i];
        }
        for (i = 20; i < this.genes.length; ++i) {
            thisOrMate = rand.nextBoolean();
            lambGenes[i] = thisOrMate ? this.mitosisGenes[i] : this.mateMitosisGenes[i];
        }
        return lambGenes;
    }

    @Nullable
    public IEntityLivingData func_180482_a(DifficultyInstance difficulty, @Nullable IEntityLivingData livingdata) {
        int[] spawnGenes;
        if ((livingdata = super.func_180482_a(difficulty, livingdata)) instanceof GroupData) {
            spawnGenes = ((GroupData)livingdata).groupGenes;
        } else {
            spawnGenes = this.createInitialGenes();
            livingdata = new GroupData(spawnGenes);
        }
        this.genes = spawnGenes;
        this.setSharedGenes(this.genes);
        return livingdata;
    }

    private int[] createInitialGenes() {
        int[] initialGenes = new int[50];
        boolean wildType = false;
        Biome biome = this.field_70170_p.func_180494_b(new BlockPos((Entity)this));
        if (biome.func_185353_n() >= 0.9f && biome.func_76727_i() > 0.8f) {
            wildType = true;
        }
        initialGenes[0] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[1] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(3) + 1 : 1;
        initialGenes[30] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[31] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[32] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        initialGenes[33] = ThreadLocalRandom.current().nextInt(100) > 90 ? ThreadLocalRandom.current().nextInt(2) + 1 : 1;
        return initialGenes;
    }

    public void setGenes(int[] genes) {
        this.genes = genes;
    }

    public int[] getGenes() {
        return this.genes;
    }

    static {
        for (EnumDyeColor enumdyecolor : EnumDyeColor.values()) {
            DYE_TO_RGB.put(enumdyecolor, EnhancedSheep.createSheepColor(enumdyecolor));
        }
        DYE_TO_RGB.put(EnumDyeColor.WHITE, new float[]{0.9019608f, 0.9019608f, 0.9019608f});
    }

    public static class GroupData
    implements IEntityLivingData {
        public int[] groupGenes;

        public GroupData(int[] groupGenes) {
            this.groupGenes = groupGenes;
        }
    }
}

