/*
 * Decompiled with CFR 0.152.
 */
package mokiyoki.enhancedanimals.renderer;

import com.google.common.collect.Maps;
import java.util.Map;
import mokiyoki.enhancedanimals.entity.EnhancedHorse;
import mokiyoki.enhancedanimals.model.ModelEnhancedHorse;
import mokiyoki.enhancedanimals.renderer.EnhancedLayeredTexture;
import net.minecraft.client.Minecraft;
import net.minecraft.client.model.ModelBase;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class RenderEnhancedHorse
extends RenderLiving<EnhancedHorse> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final String ENHANCED_HORSE_TEXTURE_LOCATION = "eanimod:textures/entities/horse/";

    public RenderEnhancedHorse(RenderManager render) {
        super(render, (ModelBase)new ModelEnhancedHorse(), 0.25f);
    }

    protected ResourceLocation getEntityTexture(EnhancedHorse entity) {
        String s = entity.getHorseTexture();
        ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new EnhancedLayeredTexture(ENHANCED_HORSE_TEXTURE_LOCATION, entity.getVariantTexturePaths()));
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }
}

