/*
 * Decompiled with CFR 0.152.
 */
package mokiyoki.enhancedanimals.renderer.layers;

import com.google.common.collect.Maps;
import java.util.Map;
import mokiyoki.enhancedanimals.entity.EnhancedSheep;
import mokiyoki.enhancedanimals.model.ModelEnhancedSheepWithWool;
import mokiyoki.enhancedanimals.renderer.EnhancedLayeredTexture;
import mokiyoki.enhancedanimals.renderer.RenderEnhancedSheep;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.client.renderer.texture.ITextureObject;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class LayerEnhancedSheepWool
implements LayerRenderer<EnhancedSheep> {
    private static final Map<String, ResourceLocation> LAYERED_LOCATION_CACHE = Maps.newHashMap();
    private static final String ENHANCED_SHEEP_TEXTURE_LOCATION = "eanimod:textures/entities/sheep/";
    private final RenderEnhancedSheep enhancedSheepRenderer;
    private final ModelEnhancedSheepWithWool enhancedSheepModel = new ModelEnhancedSheepWithWool();

    public LayerEnhancedSheepWool(RenderEnhancedSheep enhancedSheepRendererIn) {
        this.enhancedSheepRenderer = enhancedSheepRendererIn;
    }

    public void doRenderLayer(EnhancedSheep entitylivingbaseIn, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        if (!entitylivingbaseIn.getSheared() && !entitylivingbaseIn.func_82150_aj()) {
            this.enhancedSheepRenderer.func_110776_a(this.getLayeredTexture(entitylivingbaseIn));
            if (entitylivingbaseIn.func_145818_k_() && "jeb_".equals(entitylivingbaseIn.func_95999_t())) {
                int i1 = 25;
                int i = entitylivingbaseIn.field_70173_aa / 25 + entitylivingbaseIn.func_145782_y();
                int j = EnumDyeColor.values().length;
                int k = i % j;
                int l = (i + 1) % j;
                float f = ((float)(entitylivingbaseIn.field_70173_aa % 25) + partialTicks) / 25.0f;
                float[] afloat1 = EnhancedSheep.getDyeRgb(EnumDyeColor.func_176764_b((int)k));
                float[] afloat2 = EnhancedSheep.getDyeRgb(EnumDyeColor.func_176764_b((int)l));
                GlStateManager.func_179124_c((float)(afloat1[0] * (1.0f - f) + afloat2[0] * f), (float)(afloat1[1] * (1.0f - f) + afloat2[1] * f), (float)(afloat1[2] * (1.0f - f) + afloat2[2] * f));
            } else {
                float[] afloat = EnhancedSheep.getDyeRgb(entitylivingbaseIn.getFleeceColor());
                GlStateManager.func_179124_c((float)afloat[0], (float)afloat[1], (float)afloat[2]);
            }
            this.enhancedSheepModel.func_178686_a(this.enhancedSheepRenderer.func_177087_b());
            this.enhancedSheepModel.func_78086_a((EntityLivingBase)entitylivingbaseIn, limbSwing, limbSwingAmount, partialTicks);
            this.enhancedSheepModel.func_78088_a((Entity)entitylivingbaseIn, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
        }
    }

    protected ResourceLocation getLayeredTexture(EnhancedSheep entity) {
        String s = entity.getSheepFleeceTexture();
        ResourceLocation resourcelocation = LAYERED_LOCATION_CACHE.get(s);
        if (resourcelocation == null) {
            resourcelocation = new ResourceLocation(s);
            Minecraft.func_71410_x().func_110434_K().func_110579_a(resourcelocation, (ITextureObject)new EnhancedLayeredTexture(ENHANCED_SHEEP_TEXTURE_LOCATION, entity.getVariantFleeceTexturePaths()));
            LAYERED_LOCATION_CACHE.put(s, resourcelocation);
        }
        return resourcelocation;
    }

    public boolean func_177142_b() {
        return true;
    }
}

