/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.button.GuiAbstractButton;
import buildcraft.lib.gui.button.GuiImageButton;
import buildcraft.lib.gui.button.IButtonBehaviour;
import buildcraft.lib.gui.button.IButtonClickEventListener;
import buildcraft.lib.gui.button.IButtonClickEventTrigger;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.container.ContainerDiamondWoodPipe;
import buildcraft.transport.pipe.behaviour.PipeBehaviourWoodDiamond;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;

public class GuiDiamondWoodPipe
extends GuiBC8<ContainerDiamondWoodPipe>
implements IButtonClickEventListener {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald.png");
    private static final ResourceLocation TEXTURE_BUTTON = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emerald_button.png");
    private static final int WHITE_LIST_BUTTON_ID = PipeBehaviourWoodDiamond.FilterMode.WHITE_LIST.ordinal();
    private static final int BLACK_LIST_BUTTON_ID = PipeBehaviourWoodDiamond.FilterMode.BLACK_LIST.ordinal();
    private static final int ROUND_ROBIN_BUTTON_ID = PipeBehaviourWoodDiamond.FilterMode.ROUND_ROBIN.ordinal();
    private static final int SIZE_X = 175;
    private static final int SIZE_Y = 161;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE, 0.0, 0.0, 175.0, 161.0);
    private static final GuiIcon ICON_ROUND_ROBIN_INDEX = new GuiIcon(TEXTURE, 176.0, 0.0, 20.0, 20.0);
    private static final GuiIcon ICON_ROUND_ROBIN_NONE = new GuiIcon(TEXTURE, 176.0, 20.0, 20.0, 20.0);
    private GuiImageButton whiteListButton;
    private GuiImageButton blackListButton;
    private GuiImageButton roundRobinButton;
    private PipeBehaviourWoodDiamond pipe;

    public GuiDiamondWoodPipe(EntityPlayer player, PipeBehaviourWoodDiamond pipe) {
        super((ContainerBC_Neptune)new ContainerDiamondWoodPipe(player, pipe));
        this.pipe = pipe;
        this.field_146999_f = 175;
        this.field_147000_g = 161;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.whiteListButton = new GuiImageButton(this.mainGui, WHITE_LIST_BUTTON_ID, this.field_147003_i + 7, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 19, 19);
        this.whiteListButton.setToolTip(ToolTip.createLocalized((String[])new String[]{"tip.PipeItemsEmerald.whitelist"}));
        this.whiteListButton.registerListener((IButtonClickEventListener)this);
        this.mainGui.shownElements.add(this.whiteListButton);
        this.blackListButton = new GuiImageButton(this.mainGui, BLACK_LIST_BUTTON_ID, this.field_147003_i + 7 + 18, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 37, 19);
        this.blackListButton.setToolTip(ToolTip.createLocalized((String[])new String[]{"tip.PipeItemsEmerald.blacklist"}));
        this.blackListButton.registerListener((IButtonClickEventListener)this);
        this.mainGui.shownElements.add(this.blackListButton);
        if (this.pipe.pipe.getFlow() instanceof IFlowItems) {
            this.roundRobinButton = new GuiImageButton(this.mainGui, ROUND_ROBIN_BUTTON_ID, this.field_147003_i + 7 + 36, this.field_147009_r + 41, 18, TEXTURE_BUTTON, 55, 19);
            this.roundRobinButton.setToolTip(ToolTip.createLocalized((String[])new String[]{"tip.PipeItemsEmerald.roundrobin"}));
            this.roundRobinButton.registerListener((IButtonClickEventListener)this);
            this.mainGui.shownElements.add(this.roundRobinButton);
            IButtonBehaviour.createAndSetRadioButtons((GuiAbstractButton[])new GuiAbstractButton[]{this.whiteListButton, this.blackListButton, this.roundRobinButton});
        } else {
            IButtonBehaviour.createAndSetRadioButtons((GuiAbstractButton[])new GuiAbstractButton[]{this.whiteListButton, this.blackListButton});
        }
        switch (this.pipe.filterMode) {
            case WHITE_LIST: {
                this.whiteListButton.activate();
                break;
            }
            case BLACK_LIST: {
                this.blackListButton.activate();
                break;
            }
            case ROUND_ROBIN: {
                if (this.roundRobinButton == null) break;
                this.roundRobinButton.activate();
            }
        }
    }

    public void handleButtonClick(IButtonClickEventTrigger sender, int buttonKey) {
        PipeBehaviourWoodDiamond.FilterMode newFilterMode;
        if (!(sender instanceof GuiImageButton)) {
            return;
        }
        int id = Integer.parseInt(((GuiImageButton)sender).id);
        this.pipe.filterMode = newFilterMode = PipeBehaviourWoodDiamond.FilterMode.get(id);
        ((ContainerDiamondWoodPipe)this.container).sendNewFilterMode(newFilterMode);
    }

    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt((IGuiPosition)this.mainGui.rootElement);
    }

    protected void drawForegroundLayer() {
        String title = LocaleUtil.localize((String)"gui.pipes.emerald.title");
        double titleX = this.mainGui.rootElement.getX() + (double)((this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2);
        this.field_146289_q.func_78276_b(title, (int)titleX, (int)this.mainGui.rootElement.getY() + 6, 0x404040);
        this.field_146289_q.func_78276_b(LocaleUtil.localize((String)"gui.inventory"), (int)this.mainGui.rootElement.getX() + 8, (int)this.mainGui.rootElement.getY() + this.field_147000_g - 93, 0x404040);
        if (this.pipe.filterMode == PipeBehaviourWoodDiamond.FilterMode.ROUND_ROBIN) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GuiIcon icon = this.pipe.filterValid ? ICON_ROUND_ROBIN_INDEX : ICON_ROUND_ROBIN_NONE;
            int x = this.pipe.filterValid ? 18 * this.pipe.currentFilter : 0;
            icon.drawAt(this.mainGui.rootElement.getX() + 6.0 + (double)x, this.mainGui.rootElement.getY() + 16.0);
        }
    }
}

