/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.gui;

import buildcraft.api.core.render.ISprite;
import buildcraft.core.BCCoreSprites;
import buildcraft.lib.BCLibSprites;
import buildcraft.lib.client.sprite.SpriteHolderRegistry;
import buildcraft.lib.gui.ContainerBC_Neptune;
import buildcraft.lib.gui.GuiBC8;
import buildcraft.lib.gui.GuiElementToolTip;
import buildcraft.lib.gui.GuiIcon;
import buildcraft.lib.gui.ISimpleDrawable;
import buildcraft.lib.gui.ITooltipElement;
import buildcraft.lib.gui.button.GuiButtonDrawable;
import buildcraft.lib.gui.elem.GuiElementDrawable;
import buildcraft.lib.gui.elem.ToolTip;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiArea;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.misc.ColourUtil;
import buildcraft.lib.misc.LocaleUtil;
import buildcraft.transport.BCTransportSprites;
import buildcraft.transport.container.ContainerEmzuliPipe_BC8;
import buildcraft.transport.pipe.behaviour.PipeBehaviourEmzuli;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.util.ResourceLocation;

public class GuiEmzuliPipe_BC8
extends GuiBC8<ContainerEmzuliPipe_BC8> {
    private static final ResourceLocation TEXTURE = new ResourceLocation("buildcrafttransport:textures/gui/pipe_emzuli.png");
    private static final int SIZE_X = 176;
    private static final int SIZE_Y = 166;
    private static final GuiIcon ICON_GUI = new GuiIcon(TEXTURE, 0.0, 0.0, 176.0, 166.0);
    private static final GuiIcon ICON_NO_PAINT = new GuiIcon(TEXTURE, 176.0, 40.0, 16.0, 16.0);
    private static final GuiButtonDrawable.Builder PAINT_BUTTON_BUILDER;

    public GuiEmzuliPipe_BC8(EntityPlayer player, PipeBehaviourEmzuli behaviour) {
        super((ContainerBC_Neptune)new ContainerEmzuliPipe_BC8(player, behaviour));
        this.field_146999_f = 176;
        this.field_147000_g = 166;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.addButton(PipeBehaviourEmzuli.SlotIndex.SQUARE, 49, 19);
        this.addButton(PipeBehaviourEmzuli.SlotIndex.CIRCLE, 49, 47);
        this.addButton(PipeBehaviourEmzuli.SlotIndex.TRIANGLE, 106, 19);
        this.addButton(PipeBehaviourEmzuli.SlotIndex.CROSS, 106, 47);
    }

    private void addButton(PipeBehaviourEmzuli.SlotIndex index, int x, int y) {
        Supplier<EnumDyeColor> getter = () -> ((ContainerEmzuliPipe_BC8)this.container).behaviour.slotColours.get((Object)index);
        Consumer<EnumDyeColor> setter = c -> ((ContainerEmzuliPipe_BC8)this.container).paintWidgets.get((Object)index).setColour((EnumDyeColor)c);
        IGuiArea elem = this.mainGui.rootElement.offset((double)x, (double)y);
        GuiButtonDrawable button = new GuiButtonDrawable(this.mainGui, index.name(), (IGuiPosition)elem, PAINT_BUTTON_BUILDER);
        button.registerListener((b, key) -> {
            EnumDyeColor nColour;
            EnumDyeColor old = (EnumDyeColor)getter.get();
            switch (key) {
                case 0: {
                    nColour = ColourUtil.getNextOrNull((EnumDyeColor)old);
                    break;
                }
                case 1: {
                    nColour = ColourUtil.getPrevOrNull((EnumDyeColor)old);
                    break;
                }
                case 2: {
                    nColour = null;
                    break;
                }
                default: {
                    return;
                }
            }
            setter.accept(nColour);
        });
        this.mainGui.shownElements.add(button);
        IGuiArea area = new GuiRectangle(20.0, 20.0).offset((IGuiPosition)elem);
        ISimpleDrawable paintIcon = (px, py) -> {
            EnumDyeColor colour = (EnumDyeColor)getter.get();
            if (colour == null) {
                ICON_NO_PAINT.drawAt(px + 2.0, py + 2.0);
            } else {
                SpriteHolderRegistry.SpriteHolder sprite = BCTransportSprites.ACTION_PIPE_COLOUR[colour.ordinal()];
                GuiIcon.drawAt((ISprite)sprite, (double)(px + 2.0), (double)(py + 2.0), (double)16.0);
            }
        };
        this.mainGui.shownElements.add(new GuiElementDrawable(this.mainGui, area, paintIcon, false));
        ITooltipElement tooltips = list -> {
            EnumDyeColor colour = (EnumDyeColor)getter.get();
            String line = colour == null ? LocaleUtil.localize((String)"gui.pipes.emzuli.nopaint") : LocaleUtil.localize((String)"gui.pipes.emzuli.paint", (Object[])new Object[]{ColourUtil.getTextFullTooltip((EnumDyeColor)colour)});
            list.add(new ToolTip(new String[]{line}));
        };
        this.mainGui.shownElements.add(new GuiElementToolTip(this.mainGui, area, tooltips));
    }

    protected void drawBackgroundLayer(float partialTicks) {
        ICON_GUI.drawAt((IGuiPosition)this.mainGui.rootElement);
        PipeBehaviourEmzuli.SlotIndex currentSlot = ((ContainerEmzuliPipe_BC8)this.container).behaviour.getCurrentSlot();
        for (PipeBehaviourEmzuli.SlotIndex index : ((ContainerEmzuliPipe_BC8)this.container).behaviour.getActiveSlots()) {
            boolean current = index == currentSlot;
            int x = index.ordinal() < 2 ? 4 : 155;
            int y = index.ordinal() % 2 == 0 ? 21 : 49;
            SpriteHolderRegistry.SpriteHolder sprite = current ? BCCoreSprites.TRIGGER_TRUE : BCLibSprites.LOCK;
            GuiIcon.drawAt((ISprite)sprite, (double)(this.mainGui.rootElement.getX() + (double)x), (double)(this.mainGui.rootElement.getY() + (double)y), (double)16.0);
        }
    }

    protected void drawForegroundLayer() {
        String title = LocaleUtil.localize((String)"gui.pipes.emzuli.title");
        double titleX = this.mainGui.rootElement.getX() + (double)((this.field_146999_f - this.field_146289_q.func_78256_a(title)) / 2);
        this.field_146289_q.func_78276_b(title, (int)titleX, (int)this.mainGui.rootElement.getY() + 6, 0x404040);
        int invX = (int)this.mainGui.rootElement.getX() + 8;
        int invY = (int)this.mainGui.rootElement.getY() + this.field_147000_g - 93;
        this.field_146289_q.func_78276_b(LocaleUtil.localize((String)"gui.inventory"), invX, invY, 0x404040);
    }

    static {
        GuiRectangle rect = new GuiRectangle(20.0, 20.0);
        GuiIcon enabled = new GuiIcon(TEXTURE, 176.0, 0.0, 20.0, 20.0, 256);
        PAINT_BUTTON_BUILDER = new GuiButtonDrawable.Builder((IGuiArea)rect, (ISimpleDrawable)enabled);
        GuiEmzuliPipe_BC8.PAINT_BUTTON_BUILDER.active = enabled.offset(0.0, 20.0);
    }
}

