/*
 * Decompiled with CFR 0.152.
 */
package com.kashdeya.tinyprogressions.tiles;

import com.kashdeya.tinyprogressions.capabilities.InventoryStorage;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemHandlerHelper;

public class TileEntityCobblegen
extends TileEntity
implements ITickable {
    int cycle = 0;
    public InventoryStorage outputInventory = new InventoryStorage(1){

        @Override
        public boolean canInsertSlot(int slot, ItemStack stack) {
            return false;
        }

        @Override
        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74782_a("outputInventory", (NBTBase)this.serializeNBT());
        }

        @Override
        public void readFromNBT(NBTTagCompound compound) {
            this.deserializeNBT(compound.func_74775_l("outputInventory"));
        }
    };

    public int getCycleUpdate() {
        return 40;
    }

    public int getMaxStackSize() {
        return 32;
    }

    public ItemStack getStack() {
        return this.outputInventory.getStackInSlot(0);
    }

    public void func_73660_a() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        ++this.cycle;
        if (this.cycle >= this.getCycleUpdate()) {
            this.cycle = 0;
            if (this.getStack() == ItemStack.field_190927_a || this.getStack().func_77973_b() != Item.func_150898_a((Block)Blocks.field_150347_e)) {
                this.outputInventory.setStackInSlot(0, new ItemStack(Blocks.field_150347_e));
            } else {
                this.getStack().func_190920_e(Math.min(this.getMaxStackSize(), this.getStack().func_190916_E() + 1));
            }
            this.outputInventory.setStackInSlot(0, this.getStack());
            TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(EnumFacing.UP));
            if (tile != null && tile.hasCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN)) {
                IItemHandler handler = (IItemHandler)tile.getCapability(CapabilityItemHandler.ITEM_HANDLER_CAPABILITY, EnumFacing.DOWN);
                if (this.outputInventory.getStackInSlot(0) != ItemStack.field_190927_a) {
                    ItemStack stack = this.outputInventory.getStackInSlot(0).func_77946_l();
                    stack.func_190920_e(1);
                    ItemStack stack1 = ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)stack, (boolean)true);
                    if (stack1 == ItemStack.field_190927_a || stack1.func_190916_E() == 0) {
                        ItemHandlerHelper.insertItem((IItemHandler)handler, (ItemStack)this.outputInventory.extractItemInternal(0, 1, false), (boolean)false);
                        this.func_70296_d();
                    }
                }
            } else if (tile instanceof IInventory) {
                IInventory iinventory = (IInventory)tile;
                if (this.isInventoryFull(iinventory, EnumFacing.UP)) {
                    return;
                }
                if (this.outputInventory.getStackInSlot(0) != ItemStack.field_190927_a) {
                    ItemStack stack = this.outputInventory.getStackInSlot(0).func_77946_l();
                    ItemStack stack1 = TileEntityCobblegen.putStackInInventoryAllSlots(iinventory, this.outputInventory.extractItemInternal(0, 1, false), EnumFacing.UP);
                    if (stack1 == ItemStack.field_190927_a || stack1.func_190916_E() == 0) {
                        iinventory.func_70296_d();
                    } else {
                        this.outputInventory.setStackInSlot(0, stack);
                    }
                }
            }
            this.func_70296_d();
        }
    }

    protected boolean isInventoryFull(IInventory inventoryIn, EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory) {
            int[] aint;
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            for (int k : aint = isidedinventory.func_180463_a(side)) {
                ItemStack itemstack1 = isidedinventory.func_70301_a(k);
                if (itemstack1 != ItemStack.field_190927_a && itemstack1.func_190916_E() == itemstack1.func_77976_d()) continue;
                return false;
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i; ++j) {
                ItemStack itemstack = inventoryIn.func_70301_a(j);
                if (itemstack != ItemStack.field_190927_a && itemstack.func_190916_E() == itemstack.func_77976_d()) continue;
                return false;
            }
        }
        return true;
    }

    public static ItemStack putStackInInventoryAllSlots(IInventory inventoryIn, ItemStack stack, @Nullable EnumFacing side) {
        if (inventoryIn instanceof ISidedInventory && side != null && !(inventoryIn instanceof TileEntityCobblegen) && inventoryIn.func_94041_b(0, stack.func_77946_l())) {
            ISidedInventory isidedinventory = (ISidedInventory)inventoryIn;
            int[] aint = isidedinventory.func_180463_a(side);
            for (int k = 0; k < aint.length && stack != ItemStack.field_190927_a && stack.func_190916_E() > 0; ++k) {
                stack = TileEntityCobblegen.insertStack(inventoryIn, stack, aint[k], side);
            }
        } else {
            int i = inventoryIn.func_70302_i_();
            for (int j = 0; j < i && stack != ItemStack.field_190927_a && stack.func_190916_E() > 0; ++j) {
                stack = TileEntityCobblegen.insertStack(inventoryIn, stack, j, side);
            }
        }
        if (stack != ItemStack.field_190927_a && stack.func_190916_E() == 0) {
            stack = ItemStack.field_190927_a;
        }
        return stack;
    }

    private static ItemStack insertStack(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        ItemStack itemstack = inventoryIn.func_70301_a(index);
        if (TileEntityCobblegen.canInsertItemInSlot(inventoryIn, stack, index, side)) {
            int max;
            if (itemstack == ItemStack.field_190927_a) {
                int max2 = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_());
                if (max2 >= stack.func_190916_E()) {
                    inventoryIn.func_70299_a(index, stack);
                    stack = ItemStack.field_190927_a;
                } else {
                    inventoryIn.func_70299_a(index, stack.func_77979_a(max2));
                }
            } else if (TileEntityCobblegen.canCombine(itemstack, stack) && (max = Math.min(stack.func_77976_d(), inventoryIn.func_70297_j_())) > itemstack.func_190916_E()) {
                int i = max - itemstack.func_190916_E();
                int j = Math.min(stack.func_190916_E(), i);
                stack.func_190920_e(stack.func_190916_E() - j);
                itemstack.func_190920_e(itemstack.func_190916_E() + j);
            }
        }
        return stack;
    }

    private static boolean canInsertItemInSlot(IInventory inventoryIn, ItemStack stack, int index, EnumFacing side) {
        return inventoryIn.func_94041_b(index, stack) && (!(inventoryIn instanceof ISidedInventory) || ((ISidedInventory)inventoryIn).func_180462_a(index, stack, side));
    }

    private static boolean canCombine(ItemStack stack1, ItemStack stack2) {
        return stack1.func_77973_b() == stack2.func_77973_b() && stack1.func_77960_j() == stack2.func_77960_j() && stack1.func_190916_E() <= stack1.func_77976_d() && ItemStack.func_77970_a((ItemStack)stack1, (ItemStack)stack2);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return (T)((Object)this.outputInventory);
        }
        return (T)super.getCapability(capability, facing);
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY || super.hasCapability(capability, facing);
    }
}

