/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.enderdecoration.blocks;

import com.thiakil.enderdecoration.EnderDecoration;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.NonNullList;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class BlockBase
extends Block {
    protected Item myItem;
    protected String blockName;

    public BlockBase(String name, MapColor mapColor) {
        super(Material.field_151576_e, mapColor);
        this.blockName = name;
        this.func_149663_c("enderportaldecoration." + name);
        this.setRegistryName(name);
        this.func_149647_a(EnderDecoration.creativeTab);
        this.myItem = new ItemBlock((Block)this);
        this.myItem.func_77627_a(true);
        this.myItem.setRegistryName(name);
    }

    public BlockBase(String name) {
        this(name, Material.field_151576_e.func_151565_r());
    }

    @SideOnly(value=Side.CLIENT)
    public void initModel() {
        NonNullList subtypes = NonNullList.func_191196_a();
        this.func_149666_a(this.func_149708_J(), subtypes);
        for (ItemStack variant : subtypes) {
            ModelLoader.setCustomModelResourceLocation((Item)this.myItem, (int)variant.func_77960_j(), (ModelResourceLocation)new ModelResourceLocation(this.getRegistryName(), "inventory"));
        }
    }

    public Item getItem() {
        return this.myItem;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, @Nullable World world, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, world, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)("tile.enderportaldecoration." + this.blockName + ".desc"), (Object[])new Object[0]));
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    public abstract IRecipe getRecipe();
}

