/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.enderdecoration.blocks;

import com.thiakil.enderdecoration.blocks.BlockBase;
import java.util.List;
import java.util.Random;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.material.MapColor;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyBool;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class BlockPortal
extends BlockBase {
    public static final PropertyBool LIT = PropertyBool.func_177716_a((String)"lit");
    public static final PropertyBool PARTICLES = PropertyBool.func_177716_a((String)"particles");

    public BlockPortal() {
        super("portal", MapColor.field_151646_E);
    }

    @Nonnull
    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{LIT, PARTICLES});
    }

    @Nonnull
    @Deprecated
    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a((IProperty)LIT, (Comparable)Boolean.valueOf((meta & 1) == 1)).func_177226_a((IProperty)PARTICLES, (Comparable)Boolean.valueOf((meta & 2) == 2));
    }

    public int func_176201_c(IBlockState state) {
        int ret;
        int n = ret = (Boolean)state.func_177229_b((IProperty)LIT) != false ? 1 : 0;
        if (((Boolean)state.func_177229_b((IProperty)PARTICLES)).booleanValue()) {
            ret &= 2;
        }
        return ret;
    }

    public boolean func_180639_a(World worldIn, BlockPos pos, IBlockState state, EntityPlayer playerIn, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!worldIn.field_72995_K && hand == EnumHand.MAIN_HAND) {
            if (playerIn.func_70093_af()) {
                IBlockState newState = state.func_177231_a((IProperty)PARTICLES);
                worldIn.func_175656_a(pos, newState);
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("enderportaldecoration.particles." + ((Boolean)newState.func_177229_b((IProperty)PARTICLES) != false ? "on" : "off"), new Object[0]));
            } else {
                IBlockState newState = state.func_177231_a((IProperty)LIT);
                worldIn.func_175656_a(pos, newState);
                playerIn.func_145747_a((ITextComponent)new TextComponentTranslation("enderportaldecoration.lit." + ((Boolean)newState.func_177229_b((IProperty)LIT) != false ? "on" : "off"), new Object[0]));
            }
        }
        return true;
    }

    @Deprecated
    public int func_149750_m(IBlockState state) {
        return (Boolean)state.func_177229_b((IProperty)LIT) != false ? 15 : 0;
    }

    @SideOnly(value=Side.CLIENT)
    public int getParticleAmount(World worldIn, BlockPos pos) {
        int i = 0;
        IBlockState state = worldIn.func_180495_p(pos);
        for (EnumFacing enumfacing : EnumFacing.values()) {
            i += state.func_185894_c((IBlockAccess)worldIn, pos, enumfacing) ? 1 : 0;
        }
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_180655_c(IBlockState stateIn, World worldIn, BlockPos pos, Random rand) {
        if (((Boolean)stateIn.func_177229_b((IProperty)PARTICLES)).booleanValue()) {
            int i = this.getParticleAmount(worldIn, pos);
            for (int j = 0; j < i; ++j) {
                double d0 = (float)pos.func_177958_n() + rand.nextFloat();
                double d1 = (float)pos.func_177956_o() + rand.nextFloat();
                double d2 = (float)pos.func_177952_p() + rand.nextFloat();
                double d3 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d4 = ((double)rand.nextFloat() - 0.5) * 0.5;
                double d5 = ((double)rand.nextFloat() - 0.5) * 0.5;
                int k = rand.nextInt(2) * 2 - 1;
                if (rand.nextBoolean()) {
                    d2 = (double)pos.func_177952_p() + 0.5 + 0.25 * (double)k;
                    d5 = rand.nextFloat() * 2.0f * (float)k;
                } else {
                    d0 = (double)pos.func_177958_n() + 0.5 + 0.25 * (double)k;
                    d3 = rand.nextFloat() * 2.0f * (float)k;
                }
                worldIn.func_175688_a(EnumParticleTypes.PORTAL, d0, d1, d2, d3, d4, d5, new int[0]);
            }
        }
    }

    public IBlockState getStateForPlacement(World world, BlockPos pos, EnumFacing facing, float hitX, float hitY, float hitZ, int meta, EntityLivingBase placer, EnumHand hand) {
        return super.getStateForPlacement(world, pos, facing, hitX, hitY, hitZ, meta, placer, hand);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void func_190948_a(ItemStack stack, World playerIn, List<String> tooltip, ITooltipFlag advanced) {
        super.func_190948_a(stack, playerIn, tooltip, advanced);
        tooltip.add(I18n.func_135052_a((String)"enderportaldecoration.lit.toggle", (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)"enderportaldecoration.particles.toggle", (Object[])new Object[0]));
        tooltip.add("");
        IBlockState state = this.func_176203_a(stack.func_77960_j());
        tooltip.add(I18n.func_135052_a((String)("enderportaldecoration.lit." + ((Boolean)state.func_177229_b((IProperty)LIT) != false ? "on" : "off")), (Object[])new Object[0]));
        tooltip.add(I18n.func_135052_a((String)("enderportaldecoration.particles." + ((Boolean)state.func_177229_b((IProperty)PARTICLES) != false ? "on" : "off")), (Object[])new Object[0]));
    }

    @SideOnly(value=Side.CLIENT)
    public void func_149666_a(CreativeTabs tab, NonNullList<ItemStack> list) {
        list.add((Object)new ItemStack(this.myItem, 1, 0));
        list.add((Object)new ItemStack(this.myItem, 1, 1));
        list.add((Object)new ItemStack(this.myItem, 1, 2));
        list.add((Object)new ItemStack(this.myItem, 1, 3));
    }

    @Override
    public IRecipe getRecipe() {
        return (IRecipe)new ShapedOreRecipe(null, new ItemStack(this.myItem), new Object[]{"xxx", "x x", "xxx", Character.valueOf('x'), Items.field_151079_bi}).setRegistryName(this.getRegistryName());
    }
}

