/*
 * Decompiled with CFR 0.152.
 */
package com.thiakil.enderdecoration.tile.render;

import com.thiakil.enderdecoration.tile.TileEntityGateway;
import java.nio.FloatBuffer;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class TileEntitySpeialRendererGateway
extends TileEntitySpecialRenderer<TileEntityGateway> {
    private static final ResourceLocation END_SKY_TEXTURE = new ResourceLocation("textures/environment/end_sky.png");
    private static final ResourceLocation END_PORTAL_TEXTURE = new ResourceLocation("textures/entity/end_portal.png");
    private static final ResourceLocation END_GATEWAY_BEAM_TEXTURE = new ResourceLocation("textures/entity/end_gateway_beam.png");
    private static final Random RANDOM = new Random(31100L);
    private static final FloatBuffer MODELVIEW = GLAllocation.func_74529_h((int)16);
    private static final FloatBuffer PROJECTION = GLAllocation.func_74529_h((int)16);
    FloatBuffer buffer = GLAllocation.func_74529_h((int)16);

    public void render(TileEntityGateway te, double x, double y, double z, float partialTicks, int destroyStage, float alpha) {
        GlStateManager.func_179106_n();
        GlStateManager.func_179140_f();
        RANDOM.setSeed(31100L);
        GlStateManager.func_179111_a((int)2982, (FloatBuffer)MODELVIEW);
        GlStateManager.func_179111_a((int)2983, (FloatBuffer)PROJECTION);
        double d1 = x * x + y * y + z * z;
        int i = d1 > 36864.0 ? 2 : (d1 > 25600.0 ? 4 : (d1 > 16384.0 ? 6 : (d1 > 9216.0 ? 8 : (d1 > 4096.0 ? 10 : (d1 > 1024.0 ? 12 : (d1 > 576.0 ? 14 : (d1 > 256.0 ? 15 : 16)))))));
        for (int k = 0; k < i; ++k) {
            GlStateManager.func_179094_E();
            float f5 = 2.0f / (float)(18 - k);
            if (k == 0) {
                this.func_147499_a(END_SKY_TEXTURE);
                f5 = 0.15f;
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
            }
            if (k >= 1) {
                this.func_147499_a(END_PORTAL_TEXTURE);
            }
            if (k == 1) {
                GlStateManager.func_179147_l();
                GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE);
            }
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9216);
            GlStateManager.func_179149_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9216);
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.S, (int)9474, (FloatBuffer)this.getBuffer(1.0f, 0.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.T, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 1.0f, 0.0f, 0.0f));
            GlStateManager.func_179105_a((GlStateManager.TexGen)GlStateManager.TexGen.R, (int)9474, (FloatBuffer)this.getBuffer(0.0f, 0.0f, 1.0f, 0.0f));
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.S);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.T);
            GlStateManager.func_179087_a((GlStateManager.TexGen)GlStateManager.TexGen.R);
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5890);
            GlStateManager.func_179094_E();
            GlStateManager.func_179096_D();
            GlStateManager.func_179109_b((float)0.5f, (float)0.5f, (float)0.0f);
            GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
            float f1 = k + 1;
            GlStateManager.func_179109_b((float)(17.0f / f1), (float)((2.0f + f1 / 1.5f) * ((float)Minecraft.func_71386_F() % 800000.0f / 800000.0f)), (float)0.0f);
            GlStateManager.func_179114_b((float)((f1 * f1 * 4321.0f + f1 * 9.0f) * 2.0f), (float)0.0f, (float)0.0f, (float)1.0f);
            GlStateManager.func_179152_a((float)(4.5f - f1 / 4.0f), (float)(4.5f - f1 / 4.0f), (float)1.0f);
            GlStateManager.func_179110_a((FloatBuffer)PROJECTION);
            GlStateManager.func_179110_a((FloatBuffer)MODELVIEW);
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder vertexbuffer = tessellator.func_178180_c();
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
            float f2 = (RANDOM.nextFloat() * 0.5f + 0.1f) * f5;
            float f3 = (RANDOM.nextFloat() * 0.5f + 0.4f) * f5;
            float f4 = (RANDOM.nextFloat() * 0.5f + 0.5f) * f5;
            if (te.shouldRenderFace(EnumFacing.SOUTH)) {
                vertexbuffer.func_181662_b(x, y, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
            }
            if (te.shouldRenderFace(EnumFacing.NORTH)) {
                vertexbuffer.func_181662_b(x, y + 1.0, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
            }
            if (te.shouldRenderFace(EnumFacing.EAST)) {
                vertexbuffer.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
            }
            if (te.shouldRenderFace(EnumFacing.WEST)) {
                vertexbuffer.func_181662_b(x, y, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y + 1.0, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
            }
            if (te.shouldRenderFace(EnumFacing.DOWN)) {
                vertexbuffer.func_181662_b(x, y, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
            }
            if (te.shouldRenderFace(EnumFacing.UP)) {
                vertexbuffer.func_181662_b(x, y + 1.0, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y + 1.0, z + 1.0).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x + 1.0, y + 1.0, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
                vertexbuffer.func_181662_b(x, y + 1.0, z).func_181666_a(f2, f3, f4, 1.0f).func_181675_d();
            }
            tessellator.func_78381_a();
            GlStateManager.func_179121_F();
            GlStateManager.func_179128_n((int)5888);
            this.func_147499_a(END_SKY_TEXTURE);
        }
        GlStateManager.func_179084_k();
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.S);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.T);
        GlStateManager.func_179100_b((GlStateManager.TexGen)GlStateManager.TexGen.R);
        GlStateManager.func_179145_e();
        GlStateManager.func_179127_m();
    }

    private FloatBuffer getBuffer(float p_188193_1_, float p_188193_2_, float p_188193_3_, float p_188193_4_) {
        this.buffer.clear();
        this.buffer.put(p_188193_1_).put(p_188193_2_).put(p_188193_3_).put(p_188193_4_);
        this.buffer.flip();
        return this.buffer;
    }

    public boolean isGlobalRenderer(TileEntityGateway te) {
        return false;
    }
}

