/*
 * Decompiled with CFR 0.152.
 */
package cofh.cofhworld.parser.generator;

import cofh.cofhworld.parser.IGeneratorParser;
import cofh.cofhworld.parser.variables.BlockData;
import cofh.cofhworld.parser.variables.NumberData;
import cofh.cofhworld.util.random.WeightedBlock;
import cofh.cofhworld.world.generator.WorldGenDecoration;
import cofh.shade.com.typesafe.config.Config;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.world.gen.feature.WorldGenerator;
import org.apache.logging.log4j.Logger;

public class GenParserDecoration
implements IGeneratorParser {
    private static String[] FIELDS = new String[]{"block", "cluster-size"};

    @Override
    public String[] getRequiredFields() {
        return FIELDS;
    }

    @Override
    @Nonnull
    public WorldGenerator parseGenerator(String name, Config genObject, Logger log, List<WeightedBlock> resList, List<WeightedBlock> matList) {
        int clusterSize = genObject.getInt("cluster-size");
        if (clusterSize <= 0) {
            log.warn("Invalid cluster size for generator '{}'", (Object)name);
            return null;
        }
        ArrayList<WeightedBlock> list = new ArrayList<WeightedBlock>();
        if (!genObject.hasPath("surface")) {
            log.debug("Entry does not specify surface for 'decoration' generator. Using grass.");
            list.add(new WeightedBlock((Block)Blocks.field_150349_c));
        } else if (!BlockData.parseBlockList(genObject.getValue("surface"), list, false)) {
            log.warn("Entry specifies invalid surface for 'decoration' generator! Using grass!");
            list.clear();
            list.add(new WeightedBlock((Block)Blocks.field_150349_c));
        }
        WorldGenDecoration r = new WorldGenDecoration(resList, clusterSize, matList, list);
        if (genObject.hasPath("see-sky")) {
            r.setSeeSky(genObject.getBoolean("see-sky"));
        }
        if (genObject.hasPath("check-stay")) {
            r.setCheckStay(genObject.getBoolean("check-stay"));
        }
        if (genObject.hasPath("stack-height")) {
            r.setStackHeight(NumberData.parseNumberValue(genObject.getValue("stack-height")));
        }
        if (genObject.hasPath("x-variance")) {
            r.setXVar(NumberData.parseNumberValue(genObject.getValue("x-variance"), 0, 15));
        }
        if (genObject.hasPath("y-variance")) {
            r.setYVar(NumberData.parseNumberValue(genObject.getValue("y-variance")));
        }
        if (genObject.hasPath("z-variance")) {
            r.setZVar(NumberData.parseNumberValue(genObject.getValue("z-variance"), 0, 15));
        }
        return r;
    }
}

