/*
 * Decompiled with CFR 0.152.
 */
package net.malisis.doors;

import net.malisis.core.item.MalisisItem;
import net.malisis.doors.DoorDescriptor;
import net.malisis.doors.MalisisDoors;
import net.malisis.doors.MalisisDoorsSettings;
import net.malisis.doors.bigdoors.Door3x3;
import net.malisis.doors.bigdoors.Door3x3Tile;
import net.malisis.doors.block.BigDoor;
import net.malisis.doors.block.CustomDoor;
import net.malisis.doors.block.Door;
import net.malisis.doors.block.DoorFactory;
import net.malisis.doors.block.FenceGate;
import net.malisis.doors.block.Forcefield;
import net.malisis.doors.block.GarageDoor;
import net.malisis.doors.block.ModelDoor;
import net.malisis.doors.block.RustyHatch;
import net.malisis.doors.block.RustyLadder;
import net.malisis.doors.block.SaloonDoorBlock;
import net.malisis.doors.block.TrapDoor;
import net.malisis.doors.block.VerticalHatchDoor;
import net.malisis.doors.descriptor.Curtain;
import net.malisis.doors.descriptor.FactoryDoor;
import net.malisis.doors.descriptor.GlassDoor;
import net.malisis.doors.descriptor.JailDoor;
import net.malisis.doors.descriptor.LaboratoryDoor;
import net.malisis.doors.descriptor.SaloonDoor;
import net.malisis.doors.descriptor.ShojiDoor;
import net.malisis.doors.descriptor.SlidingTrapDoor;
import net.malisis.doors.descriptor.VanillaDoor;
import net.malisis.doors.descriptor.VanillaTrapDoor;
import net.malisis.doors.descriptor.VerticalHatch;
import net.malisis.doors.descriptor.WoodTrapDoor;
import net.malisis.doors.item.CustomDoorItem;
import net.malisis.doors.item.DoorItem;
import net.malisis.doors.item.ForcefieldItem;
import net.malisis.doors.item.SaloonDoorItem;
import net.malisis.doors.item.VerticalHatchItem;
import net.malisis.doors.tileentity.BigDoorTileEntity;
import net.malisis.doors.tileentity.CustomDoorTileEntity;
import net.malisis.doors.tileentity.DoorFactoryTileEntity;
import net.malisis.doors.tileentity.DoorTileEntity;
import net.malisis.doors.tileentity.FenceGateTileEntity;
import net.malisis.doors.tileentity.ForcefieldTileEntity;
import net.malisis.doors.tileentity.GarageDoorTileEntity;
import net.malisis.doors.tileentity.RustyHatchTileEntity;
import net.malisis.doors.tileentity.SaloonDoorTileEntity;
import net.malisis.doors.tileentity.TrapDoorTileEntity;
import net.malisis.doors.tileentity.VerticalHatchTileEntity;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraftforge.fml.common.registry.GameRegistry;

public class Registers {
    public static void init() {
        if (((Boolean)MalisisDoorsSettings.modifyVanillaDoors.get()).booleanValue()) {
            Registers.registerVanillaDoors();
        }
        Registers.registerDoors();
        Registers.registerCustomDoor();
        Registers.registerSaloonDoor();
        if (((Boolean)MalisisDoorsSettings.modifyVanillaDoors.get()).booleanValue()) {
            Registers.registerVanillaTrapDoor();
        }
        Registers.registerTrapDoors();
        if (((Boolean)MalisisDoorsSettings.modifyVanillaDoors.get()).booleanValue()) {
            Registers.registerVanillaFenceGate();
        }
        Registers.registerCamoFenceGate();
        Registers.registerVerticalHatch();
        Registers.registerGarageDoor();
        Registers.registerBigDoors();
        Registers.registerRustyHatch();
        Registers.registerDoorFactory();
        Registers.registerForcefield();
        MalisisDoors.Blocks.modelDoor = new ModelDoor();
        MalisisDoors.Blocks.modelDoor.register();
        GameRegistry.registerTileEntity(DoorTileEntity.class, (String)"doorTileEntity");
        GameRegistry.registerTileEntity(TrapDoorTileEntity.class, (String)"trapDoorTileEntity");
        GameRegistry.registerTileEntity(FenceGateTileEntity.class, (String)"fenceGateTileEntity");
    }

    private static void registerVanillaDoors() {
        VanillaDoor oakDoor = new VanillaDoor(VanillaDoor.Type.OAK);
        oakDoor.register();
        MalisisDoors.Blocks.doorOak = (Door)oakDoor.getBlock();
        MalisisDoors.Items.doorOakItem = (DoorItem)oakDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorOakItem);
        VanillaDoor acaciaDoor = new VanillaDoor(VanillaDoor.Type.ACACIA);
        acaciaDoor.register();
        MalisisDoors.Blocks.doorAcacia = (Door)acaciaDoor.getBlock();
        MalisisDoors.Items.doorAcaciaItem = (DoorItem)acaciaDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorAcaciaItem);
        VanillaDoor birchDoor = new VanillaDoor(VanillaDoor.Type.BIRCH);
        birchDoor.register();
        MalisisDoors.Blocks.doorBirch = (Door)birchDoor.getBlock();
        MalisisDoors.Items.doorBirchItem = (DoorItem)birchDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorBirchItem);
        VanillaDoor darkOakDoor = new VanillaDoor(VanillaDoor.Type.DARK_OAK);
        darkOakDoor.register();
        MalisisDoors.Blocks.doorDarkOak = (Door)darkOakDoor.getBlock();
        MalisisDoors.Items.doorDarkOakItem = (DoorItem)darkOakDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorDarkOakItem);
        VanillaDoor jungleDoor = new VanillaDoor(VanillaDoor.Type.JUNGLE);
        jungleDoor.register();
        MalisisDoors.Blocks.doorJungle = (Door)jungleDoor.getBlock();
        MalisisDoors.Items.doorJungleItem = (DoorItem)jungleDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorJungleItem);
        VanillaDoor spruceDoor = new VanillaDoor(VanillaDoor.Type.SPRUCE);
        spruceDoor.register();
        MalisisDoors.Blocks.doorSpruce = (Door)spruceDoor.getBlock();
        MalisisDoors.Items.doorSpruceItem = (DoorItem)spruceDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorSpruceItem);
        VanillaDoor ironDoor = new VanillaDoor(VanillaDoor.Type.IRON);
        ironDoor.register();
        MalisisDoors.Blocks.doorIron = (Door)ironDoor.getBlock();
        MalisisDoors.Items.doorIronItem = (DoorItem)ironDoor.getItem();
        MalisisDoors.tab.addItem((Item)MalisisDoors.Items.doorIronItem);
    }

    private static void registerVanillaTrapDoor() {
        VanillaTrapDoor trapDoorOak = new VanillaTrapDoor(VanillaTrapDoor.Type.WOOD);
        trapDoorOak.register();
        MalisisDoors.Blocks.oakTrapDoor = (TrapDoor)trapDoorOak.getBlock();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.oakTrapDoor);
        VanillaTrapDoor trapDoorIron = new VanillaTrapDoor(VanillaTrapDoor.Type.IRON);
        trapDoorIron.register();
        MalisisDoors.Blocks.ironTrapDoor = (TrapDoor)trapDoorIron.getBlock();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.ironTrapDoor);
    }

    private static void registerVanillaFenceGate() {
        MalisisDoors.Blocks.oakFenceGate = new FenceGate(FenceGate.Type.OAK);
        MalisisDoors.Blocks.oakFenceGate.register();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.oakFenceGate);
        MalisisDoors.Blocks.acaciaFenceGate = new FenceGate(FenceGate.Type.ACACIA);
        MalisisDoors.Blocks.acaciaFenceGate.register();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.acaciaFenceGate);
        MalisisDoors.Blocks.birchFenceGate = new FenceGate(FenceGate.Type.BIRCH);
        MalisisDoors.Blocks.birchFenceGate.register();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.birchFenceGate);
        MalisisDoors.Blocks.darkOakFenceGate = new FenceGate(FenceGate.Type.DARK_OAK);
        MalisisDoors.Blocks.darkOakFenceGate.register();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.darkOakFenceGate);
        MalisisDoors.Blocks.jungleFenceGate = new FenceGate(FenceGate.Type.JUNGLE);
        MalisisDoors.Blocks.jungleFenceGate.register();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.jungleFenceGate);
        MalisisDoors.Blocks.spruceFenceGate = new FenceGate(FenceGate.Type.SPRUCE);
        MalisisDoors.Blocks.spruceFenceGate.register();
        MalisisDoors.tab.addItem((Block)MalisisDoors.Blocks.spruceFenceGate);
    }

    private static void registerDoors() {
        DoorDescriptor desc = new GlassDoor(Material.field_151575_d).register();
        MalisisDoors.Blocks.woodSlidingDoor = (Door)desc.getBlock();
        MalisisDoors.Items.woodSlidingDoorItem = (DoorItem)desc.getItem();
        desc = new GlassDoor(Material.field_151573_f).register();
        MalisisDoors.Blocks.ironSlidingDoor = (Door)desc.getBlock();
        MalisisDoors.Items.ironSlidingDoorItem = (DoorItem)desc.getItem();
        desc = new JailDoor().register();
        MalisisDoors.Blocks.jailDoor = (Door)desc.getBlock();
        MalisisDoors.Items.jailDoorItem = (DoorItem)desc.getItem();
        desc = new LaboratoryDoor().register();
        MalisisDoors.Blocks.laboratoryDoor = (Door)desc.getBlock();
        MalisisDoors.Items.laboratoryDoorItem = (DoorItem)desc.getItem();
        desc = new FactoryDoor().register();
        MalisisDoors.Blocks.factoryDoor = (Door)desc.getBlock();
        MalisisDoors.Items.factoryDoorItem = (DoorItem)desc.getItem();
        desc = new ShojiDoor().register();
        MalisisDoors.Blocks.shojiDoor = (Door)desc.getBlock();
        MalisisDoors.Items.shojiDoorItem = (DoorItem)desc.getItem();
        for (EnumDyeColor color : EnumDyeColor.values()) {
            new Curtain(color).register();
        }
    }

    private static void registerSaloonDoor() {
        DoorDescriptor desc = new SaloonDoor().register();
        MalisisDoors.Blocks.saloonDoor = (SaloonDoorBlock)desc.getBlock();
        MalisisDoors.Items.saloonDoorItem = (SaloonDoorItem)desc.getItem();
        GameRegistry.registerTileEntity(SaloonDoorTileEntity.class, (String)"saloonDoorTileEntity");
    }

    private static void registerVerticalHatch() {
        DoorDescriptor desc = new VerticalHatch().register();
        MalisisDoors.Blocks.verticalHatch = (VerticalHatchDoor)desc.getBlock();
        MalisisDoors.Items.verticalHatchItem = (VerticalHatchItem)desc.getItem();
        GameRegistry.registerTileEntity(VerticalHatchTileEntity.class, (String)"verticalHatchTileEntity");
    }

    private static void registerTrapDoors() {
        DoorDescriptor desc = new SlidingTrapDoor().register();
        MalisisDoors.Blocks.slidingTrapDoor = (TrapDoor)desc.getBlock();
        MalisisDoors.Items.slidingTrapDoorItem = desc.getItem();
        for (WoodTrapDoor.Type type : WoodTrapDoor.Type.values()) {
            desc = new WoodTrapDoor(type).register();
        }
    }

    private static void registerCamoFenceGate() {
        MalisisDoors.Blocks.camoFenceGate = new FenceGate(FenceGate.Type.CAMO);
        MalisisDoors.Blocks.camoFenceGate.register();
    }

    private static void registerGarageDoor() {
        MalisisDoors.Blocks.garageDoor = new GarageDoor();
        MalisisDoors.Blocks.garageDoor.register();
        GameRegistry.registerTileEntity(GarageDoorTileEntity.class, (String)"garageDoorTileEntity");
    }

    private static void registerDoorFactory() {
        MalisisDoors.Blocks.doorFactory = new DoorFactory();
        MalisisDoors.Blocks.doorFactory.register();
        GameRegistry.registerTileEntity(DoorFactoryTileEntity.class, (String)"doorFactoryTileEntity");
    }

    private static void registerCustomDoor() {
        MalisisDoors.Blocks.customDoor = new CustomDoor();
        MalisisDoors.Blocks.customDoor.register();
        MalisisDoors.Items.customDoorItem = new CustomDoorItem();
        MalisisDoors.Items.customDoorItem.register();
        GameRegistry.registerTileEntity(CustomDoorTileEntity.class, (String)"customDoorTileEntity");
    }

    private static void registerRustyHatch() {
        MalisisDoors.Blocks.rustyHatch = new RustyHatch();
        MalisisDoors.Blocks.rustyHatch.register();
        MalisisDoors.Items.rustyHandle = new MalisisItem().setName("rustyHandle");
        MalisisDoors.Items.rustyHandle.func_77637_a((CreativeTabs)MalisisDoors.tab);
        MalisisDoors.Items.rustyHandle.register();
        GameRegistry.registerTileEntity(RustyHatchTileEntity.class, (String)"rustyHatchTileEntity");
        MalisisDoors.Blocks.rustyLadder = new RustyLadder();
        MalisisDoors.Blocks.rustyLadder.register();
    }

    private static void registerBigDoors() {
        MalisisDoors.Blocks.carriageDoor = new BigDoor(BigDoor.Type.CARRIAGE);
        MalisisDoors.Blocks.carriageDoor.register();
        MalisisDoors.Blocks.medievalDoor = new BigDoor(BigDoor.Type.MEDIEVAL);
        MalisisDoors.Blocks.medievalDoor.register();
        MalisisDoors.Blocks.bigDoorOak = new Door3x3(Door3x3.Type.OAK);
        MalisisDoors.Blocks.bigDoorOak.register();
        MalisisDoors.Blocks.bigDoorSpruce = new Door3x3(Door3x3.Type.SPRUCE);
        MalisisDoors.Blocks.bigDoorSpruce.register();
        MalisisDoors.Blocks.bigDoorBirch = new Door3x3(Door3x3.Type.BIRCH);
        MalisisDoors.Blocks.bigDoorBirch.register();
        MalisisDoors.Blocks.bigDoorJungle = new Door3x3(Door3x3.Type.JUNGLE);
        MalisisDoors.Blocks.bigDoorJungle.register();
        MalisisDoors.Blocks.bigDoorAcacia = new Door3x3(Door3x3.Type.ACACIA);
        MalisisDoors.Blocks.bigDoorAcacia.register();
        MalisisDoors.Blocks.bigDoorDarkOak = new Door3x3(Door3x3.Type.DARK_OAK);
        MalisisDoors.Blocks.bigDoorDarkOak.register();
        MalisisDoors.Blocks.bigDoorIron = new Door3x3(Door3x3.Type.IRON);
        MalisisDoors.Blocks.bigDoorIron.register();
        MalisisDoors.Blocks.bigDoorRusty = new Door3x3(Door3x3.Type.RUSTY);
        MalisisDoors.Blocks.bigDoorRusty.register();
        GameRegistry.registerTileEntity(Door3x3Tile.class, (String)"door3x3");
        GameRegistry.registerTileEntity(BigDoorTileEntity.class, (String)"bigDoorTileEntity");
    }

    private static void registerForcefield() {
        MalisisDoors.Blocks.forcefieldDoor = new Forcefield();
        MalisisDoors.Blocks.forcefieldDoor.register();
        MalisisDoors.Items.forcefieldItem = new ForcefieldItem();
        MalisisDoors.Items.forcefieldItem.register();
        GameRegistry.registerTileEntity(ForcefieldTileEntity.class, (String)"forcefieldTileEntity");
    }
}

