/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_exchange.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.currency.CurrencyHelperServer;
import austeretony.oxygen_core.common.main.OxygenMain;
import austeretony.oxygen_core.common.network.Packet;
import austeretony.oxygen_core.common.sound.OxygenSoundEffects;
import austeretony.oxygen_core.common.util.ByteBufUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_core.server.api.SoundEventHelperServer;
import austeretony.oxygen_core.server.api.WatcherHelperServer;
import austeretony.oxygen_exchange.common.EnumExchangeOperation;
import austeretony.oxygen_exchange.common.inventory.ExchangeMenuContainer;
import austeretony.oxygen_exchange.common.main.EnumExchangeStatusMessage;
import austeretony.oxygen_exchange.common.network.client.CPExchangeOperation;
import austeretony.oxygen_exchange.common.network.client.CPSyncOtherPlayerOffer;
import austeretony.oxygen_exchange.server.ExchangeManagerServer;
import austeretony.oxygen_exchange.server.QueuedExchangeOperation;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import java.util.Queue;
import java.util.UUID;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;

public class ExchangeProcess {
    private final Queue<QueuedExchangeOperation> operations = new ConcurrentLinkedQueue<QueuedExchangeOperation>();
    public final ExchangeParticipant firstParticipant;
    public final ExchangeParticipant secondParticipant;

    public ExchangeProcess(EntityPlayerMP firstPlayer, int firstPlayerIndex, EntityPlayerMP secondPlayer, int secondPlayerIndex) {
        this.firstParticipant = new ExchangeParticipant(firstPlayer, firstPlayerIndex);
        this.secondParticipant = new ExchangeParticipant(secondPlayer, secondPlayerIndex);
    }

    public void processAction(int playerIndex, EnumExchangeOperation operation, long offeredCurrency) {
        if (operation != EnumExchangeOperation.CLOSE && !OxygenHelperServer.isPlayerOnline((int)(playerIndex == this.firstParticipant.playerIndex ? this.secondParticipant.playerIndex : this.firstParticipant.playerIndex))) {
            operation = EnumExchangeOperation.CLOSE;
        }
        this.operations.offer(new QueuedExchangeOperation(playerIndex, operation, offeredCurrency));
    }

    public boolean process() {
        while (!this.operations.isEmpty()) {
            QueuedExchangeOperation operation = this.operations.poll();
            if (operation == null) continue;
            switch (operation.operation) {
                case OFFER: {
                    int i;
                    Container container;
                    if (operation.playerIndex == this.firstParticipant.playerIndex) {
                        this.firstParticipant.setOfferedCurrency(operation.offeredCurrency);
                        container = this.firstParticipant.player.field_71070_bA;
                        if (this.disableOfferSlots(container)) {
                            return true;
                        }
                        for (i = 5; i < 10; ++i) {
                            this.firstParticipant.offeredItems[i - 5] = ((Slot)container.field_75151_b.get(i)).func_75211_c().func_77946_l();
                        }
                        if (this.validateOfferedItems(this.firstParticipant.offeredItems)) {
                            this.notifyPlayer(this.firstParticipant.player, CPExchangeOperation.EnumOperation.OFFERED);
                            this.syncOfferWith(this.secondParticipant.player, this.firstParticipant.offeredCurrency, this.firstParticipant.offeredItems);
                            break;
                        }
                        OxygenHelperServer.sendStatusMessage((EntityPlayerMP)this.firstParticipant.player, (int)3, (int)EnumExchangeStatusMessage.ITEM_BLACKLISTED.ordinal());
                        break;
                    }
                    this.secondParticipant.setOfferedCurrency(operation.offeredCurrency);
                    container = this.secondParticipant.player.field_71070_bA;
                    if (this.disableOfferSlots(container)) {
                        return true;
                    }
                    for (i = 5; i < 10; ++i) {
                        this.secondParticipant.offeredItems[i - 5] = ((Slot)container.field_75151_b.get(i)).func_75211_c().func_77946_l();
                    }
                    if (this.validateOfferedItems(this.secondParticipant.offeredItems)) {
                        this.notifyPlayer(this.secondParticipant.player, CPExchangeOperation.EnumOperation.OFFERED);
                        this.syncOfferWith(this.firstParticipant.player, this.secondParticipant.offeredCurrency, this.secondParticipant.offeredItems);
                        break;
                    }
                    OxygenHelperServer.sendStatusMessage((EntityPlayerMP)this.secondParticipant.player, (int)3, (int)EnumExchangeStatusMessage.ITEM_BLACKLISTED.ordinal());
                    break;
                }
                case CANCEL: {
                    Container container;
                    if (operation.playerIndex == this.firstParticipant.playerIndex) {
                        this.firstParticipant.setConfirmed(false);
                        this.secondParticipant.setConfirmed(false);
                        this.firstParticipant.resetOffer();
                        this.secondParticipant.resetOffer();
                        container = this.firstParticipant.player.field_71070_bA;
                        if (this.enableOfferSlots(container)) {
                            return true;
                        }
                        container = this.secondParticipant.player.field_71070_bA;
                        if (this.enableOfferSlots(container)) {
                            return true;
                        }
                        this.notifyPlayer(this.firstParticipant.player, CPExchangeOperation.EnumOperation.CANCELED);
                        this.notifyPlayer(this.secondParticipant.player, CPExchangeOperation.EnumOperation.OTHER_CANCELED);
                        break;
                    }
                    this.firstParticipant.setConfirmed(false);
                    this.secondParticipant.setConfirmed(false);
                    this.firstParticipant.resetOffer();
                    this.secondParticipant.resetOffer();
                    container = this.firstParticipant.player.field_71070_bA;
                    if (this.enableOfferSlots(container)) {
                        return true;
                    }
                    container = this.secondParticipant.player.field_71070_bA;
                    if (this.enableOfferSlots(container)) {
                        return true;
                    }
                    this.notifyPlayer(this.secondParticipant.player, CPExchangeOperation.EnumOperation.CANCELED);
                    this.notifyPlayer(this.firstParticipant.player, CPExchangeOperation.EnumOperation.OTHER_CANCELED);
                    break;
                }
                case CONFIRM: {
                    if (operation.playerIndex == this.firstParticipant.playerIndex) {
                        this.firstParticipant.setConfirmed(true);
                        this.notifyPlayer(this.firstParticipant.player, CPExchangeOperation.EnumOperation.CONFIRMED);
                        this.notifyPlayer(this.secondParticipant.player, CPExchangeOperation.EnumOperation.OTHER_CONFIRMED);
                    } else {
                        this.secondParticipant.setConfirmed(true);
                        this.notifyPlayer(this.secondParticipant.player, CPExchangeOperation.EnumOperation.CONFIRMED);
                        this.notifyPlayer(this.firstParticipant.player, CPExchangeOperation.EnumOperation.OTHER_CONFIRMED);
                    }
                    if (!this.firstParticipant.confirmedExchange() || !this.secondParticipant.confirmedExchange()) break;
                    this.transferOffers();
                    return true;
                }
                case CLOSE: {
                    return true;
                }
            }
        }
        return false;
    }

    private boolean validateOfferedItems(ItemStack[] offeredItems) {
        for (ItemStack itemStack : offeredItems) {
            if (!ExchangeManagerServer.instance().getItemsBlacklist().isBlackListed(itemStack)) continue;
            return false;
        }
        return true;
    }

    private boolean disableOfferSlots(Container container) {
        if (!(container instanceof ExchangeMenuContainer)) {
            return true;
        }
        ((ExchangeMenuContainer)container).disableClientOfferSlots();
        return false;
    }

    private boolean enableOfferSlots(Container container) {
        if (!(container instanceof ExchangeMenuContainer)) {
            return true;
        }
        ((ExchangeMenuContainer)container).enableClientOfferSlots();
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void syncOfferWith(EntityPlayerMP playerMP, long offeredCurrency, ItemStack[] offeredItems) {
        ByteBuf buffer = null;
        try {
            buffer = Unpooled.buffer();
            for (ItemStack itemStack : offeredItems) {
                ByteBufUtils.writeItemStack((ItemStack)itemStack, (ByteBuf)buffer);
            }
            byte[] compressedItems = new byte[buffer.writerIndex()];
            buffer.readBytes(compressedItems);
            OxygenMain.network().sendTo((Packet)new CPSyncOtherPlayerOffer(offeredCurrency, compressedItems), playerMP);
        }
        finally {
            if (buffer != null) {
                buffer.release();
            }
        }
    }

    private void notifyPlayer(EntityPlayerMP playerMP, CPExchangeOperation.EnumOperation operation) {
        OxygenMain.network().sendTo((Packet)new CPExchangeOperation(operation), playerMP);
    }

    private void transferOffers() {
        if (this.firstParticipant.offeredCurrency > 0L || this.secondParticipant.offeredCurrency > 0L) {
            UUID firstUUID = CommonReference.getPersistentUUID((Entity)this.firstParticipant.player);
            UUID secondUUID = CommonReference.getPersistentUUID((Entity)this.secondParticipant.player);
            if (this.firstParticipant.offeredCurrency > 0L) {
                CurrencyHelperServer.removeCurrency((UUID)firstUUID, (long)this.firstParticipant.offeredCurrency);
                CurrencyHelperServer.addCurrency((UUID)secondUUID, (long)this.firstParticipant.offeredCurrency);
            }
            if (this.secondParticipant.offeredCurrency > 0L) {
                CurrencyHelperServer.removeCurrency((UUID)secondUUID, (long)this.secondParticipant.offeredCurrency);
                CurrencyHelperServer.addCurrency((UUID)firstUUID, (long)this.secondParticipant.offeredCurrency);
            }
            CurrencyHelperServer.save((UUID)firstUUID);
            CurrencyHelperServer.save((UUID)secondUUID);
            WatcherHelperServer.setValue((UUID)firstUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)firstUUID));
            WatcherHelperServer.setValue((UUID)secondUUID, (int)0, (long)CurrencyHelperServer.getCurrency((UUID)secondUUID));
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)this.firstParticipant.player, (int)OxygenSoundEffects.SELL.id);
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)this.secondParticipant.player, (int)OxygenSoundEffects.SELL.id);
        }
        for (int i = 5; i < 10; ++i) {
            ((Slot)this.firstParticipant.player.field_71070_bA.field_75151_b.get(i)).func_75215_d(ItemStack.field_190927_a);
            ((Slot)this.secondParticipant.player.field_71070_bA.field_75151_b.get(i)).func_75215_d(ItemStack.field_190927_a);
        }
        boolean itemsAdded = false;
        for (ItemStack itemStack : this.secondParticipant.offeredItems) {
            if (!itemStack.func_190926_b()) {
                itemsAdded = true;
            }
            CommonReference.delegateToServerThread(() -> this.firstParticipant.player.field_71071_by.func_70441_a(itemStack));
        }
        if (itemsAdded) {
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)this.firstParticipant.player, (int)OxygenSoundEffects.INVENTORY.id);
        }
        itemsAdded = false;
        for (ItemStack itemStack : this.firstParticipant.offeredItems) {
            if (itemStack.func_190926_b()) {
                itemsAdded = true;
            }
            CommonReference.delegateToServerThread(() -> this.secondParticipant.player.field_71071_by.func_70441_a(itemStack));
        }
        if (itemsAdded) {
            SoundEventHelperServer.playSoundClient((EntityPlayerMP)this.secondParticipant.player, (int)OxygenSoundEffects.INVENTORY.id);
        }
        this.firstParticipant.player.field_71070_bA.func_75142_b();
        this.secondParticipant.player.field_71070_bA.func_75142_b();
    }

    public static class ExchangeParticipant {
        public final EntityPlayerMP player;
        public final int playerIndex;
        public final ItemStack[] offeredItems = new ItemStack[]{ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a, ItemStack.field_190927_a};
        private long offeredCurrency;
        private boolean confirmed;

        public ExchangeParticipant(EntityPlayerMP player, int playerIndex) {
            this.player = player;
            this.playerIndex = playerIndex;
        }

        public long getOfferedCurrency() {
            return this.offeredCurrency;
        }

        public void setOfferedCurrency(long value) {
            this.offeredCurrency = value;
        }

        public boolean confirmedExchange() {
            return this.confirmed;
        }

        public void setConfirmed(boolean flag) {
            this.confirmed = flag;
        }

        public void resetOffer() {
            this.offeredCurrency = 0L;
            for (int i = 0; i < 5; ++i) {
                this.offeredItems[i] = ItemStack.field_190927_a;
            }
        }
    }
}

