/*
 * Decompiled with CFR 0.152.
 */
package austeretony.oxygen_exchange.server;

import austeretony.oxygen_core.common.api.CommonReference;
import austeretony.oxygen_core.common.currency.CurrencyHelperServer;
import austeretony.oxygen_core.common.main.EnumOxygenStatusMessage;
import austeretony.oxygen_core.common.notification.Notification;
import austeretony.oxygen_core.common.util.MathUtils;
import austeretony.oxygen_core.server.api.OxygenHelperServer;
import austeretony.oxygen_exchange.common.EnumExchangeOperation;
import austeretony.oxygen_exchange.common.main.ExchangeMain;
import austeretony.oxygen_exchange.server.ExchangeProcess;
import austeretony.oxygen_exchange.server.ExchangeRequest;
import java.util.Iterator;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;

public class ExchangeProcessesManagerServer {
    private final Map<Long, ExchangeProcess> exchangeProcesses = new ConcurrentHashMap<Long, ExchangeProcess>();
    private final Map<Integer, Long> access = new ConcurrentHashMap<Integer, Long>();

    public boolean haveExchangeProcess(int index) {
        return this.access.containsKey(index);
    }

    public ExchangeProcess getExchangeProcess(int index) {
        return this.exchangeProcesses.get(this.access.get(index));
    }

    public void onPlayerUnloaded(EntityPlayerMP playerMP) {
        int index = OxygenHelperServer.getPlayerIndex((UUID)CommonReference.getPersistentUUID((Entity)playerMP));
        if (this.haveExchangeProcess(index)) {
            this.getExchangeProcess(index).processAction(index, EnumExchangeOperation.CLOSE, 0L);
        }
    }

    public void runExchangeProcesses() {
        OxygenHelperServer.addRoutineTask(() -> {
            Iterator<ExchangeProcess> iterator = this.exchangeProcesses.values().iterator();
            while (iterator.hasNext()) {
                ExchangeProcess exchangeProcess = iterator.next();
                if (!exchangeProcess.process()) continue;
                this.access.remove(exchangeProcess.firstParticipant.playerIndex);
                this.access.remove(exchangeProcess.secondParticipant.playerIndex);
                if (OxygenHelperServer.isPlayerOnline((int)exchangeProcess.firstParticipant.playerIndex)) {
                    exchangeProcess.firstParticipant.player.func_71053_j();
                }
                if (OxygenHelperServer.isPlayerOnline((int)exchangeProcess.secondParticipant.playerIndex)) {
                    exchangeProcess.secondParticipant.player.func_71053_j();
                }
                iterator.remove();
            }
        });
    }

    public void sendExchangeRequest(EntityPlayerMP senderMP, int playerIndex) {
        UUID senderUUID = CommonReference.getPersistentUUID((Entity)senderMP);
        if (OxygenHelperServer.isPlayerOnline((int)playerIndex)) {
            UUID targetUUID = OxygenHelperServer.getPlayerSharedData((int)playerIndex).getPlayerUUID();
            EntityPlayerMP target = CommonReference.playerByUUID((UUID)targetUUID);
            if (CommonReference.isEntitiesNear((Entity)senderMP, (Entity)target, (double)5.0) && !this.haveExchangeProcess(playerIndex) && !senderUUID.equals(targetUUID)) {
                OxygenHelperServer.sendRequest((EntityPlayerMP)senderMP, (EntityPlayerMP)target, (Notification)new ExchangeRequest(30, senderUUID, CommonReference.getName((Entity)senderMP)));
            } else {
                OxygenHelperServer.sendStatusMessage((EntityPlayerMP)senderMP, (int)0, (int)EnumOxygenStatusMessage.REQUEST_RESET.ordinal());
            }
        }
    }

    public void processExchangeRequestReply(EntityPlayer target, UUID senderUUID) {
        if (OxygenHelperServer.isPlayerOnline((UUID)senderUUID)) {
            UUID targetUUID = CommonReference.getPersistentUUID((Entity)target);
            EntityPlayerMP sender = CommonReference.playerByUUID((UUID)senderUUID);
            if (CommonReference.isEntitiesNear((Entity)sender, (Entity)target, (double)5.0)) {
                long id = System.nanoTime();
                int firstIndex = OxygenHelperServer.getPlayerIndex((UUID)senderUUID);
                int secondIndex = OxygenHelperServer.getPlayerIndex((UUID)targetUUID);
                this.exchangeProcesses.put(id, new ExchangeProcess(sender, firstIndex, (EntityPlayerMP)target, secondIndex));
                this.access.put(firstIndex, id);
                this.access.put(secondIndex, id);
                ExchangeProcessesManagerServer.openExchangeMenu(target);
                ExchangeProcessesManagerServer.openExchangeMenu((EntityPlayer)sender);
            }
        }
    }

    public void processExchangeOperation(EntityPlayer player, EnumExchangeOperation operation, long offeredCurrency) {
        UUID playerUUID = CommonReference.getPersistentUUID((Entity)player);
        int index = OxygenHelperServer.getPlayerIndex((UUID)playerUUID);
        if (this.haveExchangeProcess(index)) {
            this.getExchangeProcess(index).processAction(index, operation, offeredCurrency > 0L ? MathUtils.clamp((long)offeredCurrency, (long)0L, (long)CurrencyHelperServer.getCurrency((UUID)playerUUID)) : 0L);
        }
    }

    public static void openExchangeMenu(EntityPlayer player) {
        player.openGui((Object)ExchangeMain.instance, 0, player.field_70170_p, (int)player.field_70165_t, (int)player.field_70163_u, (int)player.field_70161_v);
    }
}

