/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.abilities;

import com.blocklings.abilities.AbilityHelper;
import java.awt.Color;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.UUID;
import net.minecraft.nbt.NBTTagCompound;
import org.jline.utils.Log;

public class Ability
implements Cloneable {
    public UUID uuid;
    public UUID parentUuid;
    public int x;
    public int y;
    public int width = 24;
    public int height = 24;
    public int iconX;
    public int iconY;
    public int shapeX;
    public int shapeY;
    public int skillPointCost;
    public String name = "Name";
    public List<Ability> conflictingAbilities = new ArrayList<Ability>();
    public List<String> description = new ArrayList<String>();
    public HashMap<String, Integer> levelRequirements = new HashMap();
    public State state = State.LOCKED;
    public Ability parentAbility;
    public Color highlightColour = new Color(223894);

    public Ability initInfo(String uuid, String name, String[] description, Ability parentAbility, int skillPointCost) {
        this.uuid = UUID.fromString(uuid);
        this.name = name;
        this.description = Arrays.asList(description);
        this.parentAbility = parentAbility;
        this.parentUuid = parentAbility != null ? parentAbility.uuid : null;
        this.skillPointCost = skillPointCost;
        return this;
    }

    public Ability initGui(int x, int y, int iconX, int iconY, int shapeX, int shapeY, Color highlightColour) {
        this.x = x;
        this.y = y;
        this.iconX = iconX;
        this.iconY = iconY;
        this.shapeX = shapeX;
        this.shapeY = shapeY;
        this.highlightColour = highlightColour;
        return this;
    }

    public Ability initConflictingAbilities(Ability[] conflictingAbilities) {
        this.conflictingAbilities = Arrays.asList(conflictingAbilities);
        return this;
    }

    public void addLevelRequirement(String skill, int level) {
        this.levelRequirements.put(skill, level);
    }

    public void initFromDefaults() {
        this.checkList(AbilityHelper.generalAbilities);
        this.checkList(AbilityHelper.combatAbilities);
        this.checkList(AbilityHelper.miningAbilities);
        this.checkList(AbilityHelper.woodcuttingAbilities);
        this.checkList(AbilityHelper.farmingAbilities);
    }

    private void checkList(List<Ability> abilities) {
        if (abilities.contains(this)) {
            for (Ability ability : abilities) {
                if (!this.equals(ability)) continue;
                this.uuid = ability.uuid;
                this.name = ability.name;
                this.description = ability.description;
                this.parentUuid = ability.parentAbility != null ? ability.parentAbility.uuid : null;
                this.x = ability.x;
                this.y = ability.y;
                this.iconX = ability.iconX;
                this.iconY = ability.iconY;
                this.shapeX = ability.shapeX;
                this.shapeY = ability.shapeY;
                this.skillPointCost = ability.skillPointCost;
                this.highlightColour = ability.highlightColour;
                this.conflictingAbilities = ability.conflictingAbilities;
                this.levelRequirements = ability.levelRequirements;
            }
        }
    }

    public void writeToNBT(NBTTagCompound c) {
        c.func_74768_a(this.uuid.toString() + ":StateId", this.state.ordinal());
    }

    public void initFromNBT(NBTTagCompound c, UUID uuid) {
        this.state = State.values()[c.func_74762_e(uuid.toString() + ":StateId")];
        this.initFromDefaults();
    }

    public boolean tryCycleState(List<Ability> baseList) {
        if (!this.hasConflictingAbility(baseList)) {
            if (this.state.ordinal() == State.values().length - 1) {
                for (Ability child : this.getChildren(baseList)) {
                    if (child.state.ordinal() < this.state.ordinal()) continue;
                    return false;
                }
                this.state = State.UNLOCKED;
                return true;
            }
            if (this.parentAbility == null) {
                this.state = State.values()[this.state.ordinal() + 1];
                return true;
            }
            if (this.parentAbility.state.ordinal() > this.state.ordinal()) {
                this.state = State.values()[this.state.ordinal() + 1];
                return true;
            }
        }
        return false;
    }

    public boolean hasConflictingAbility(List<Ability> baseList) {
        if (this.state == State.UNLOCKED) {
            for (Ability ability : baseList) {
                if (!this.conflictingAbilities.contains(ability) || ability.state != State.ACQUIRED) continue;
                return true;
            }
        }
        return false;
    }

    public List<Ability> getChildren(List<Ability> baseList) {
        ArrayList<Ability> list = new ArrayList<Ability>();
        for (Ability ability : baseList) {
            if (this != ability.parentAbility) continue;
            list.add(ability);
        }
        return list;
    }

    protected Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public Ability copy() {
        try {
            return (Ability)this.clone();
        }
        catch (CloneNotSupportedException e) {
            Log.error((Object[])new Object[]{"Couldn't clone ability: " + this.name});
            Log.error((Object[])e.getStackTrace());
            return null;
        }
    }

    public boolean equals(Object o) {
        Ability ability = (Ability)o;
        return ability.uuid.equals(this.uuid);
    }

    public static enum State {
        LOCKED(new Color(0x444444)),
        UNLOCKED(new Color(0xF4F4F4)),
        ACQUIRED(new Color(16761865));

        public Color colour;

        private State(Color colour) {
            this.colour = colour;
        }
    }
}

