/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.entities.EntityBlockling;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityFlying;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.monster.EntityCreeper;
import net.minecraft.entity.passive.EntityVillager;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.pathfinding.Path;
import net.minecraft.pathfinding.PathPoint;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class BlocklingAIAttackMelee
extends EntityAIBase {
    World world;
    protected EntityCreature attacker;
    protected int attackTick;
    boolean longMemory;
    Path path;
    private int delayCounter;
    private double targetX;
    private double targetY;
    private double targetZ;
    private int failedPathFindingPenalty = 0;
    private boolean canPenalize = false;
    private EntityBlockling blockling;

    public BlocklingAIAttackMelee(EntityCreature creature, boolean useLongMemory) {
        this.attacker = creature;
        this.blockling = (EntityBlockling)creature;
        this.world = creature.field_70170_p;
        this.longMemory = useLongMemory;
        this.func_75248_a(3);
    }

    public boolean func_75250_a() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (this.blockling.func_70906_o()) {
            return false;
        }
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (this.canPenalize) {
            if (--this.delayCounter <= 0) {
                this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
                this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
                return this.path != null;
            }
            return true;
        }
        this.path = this.attacker.func_70661_as().func_75494_a((Entity)entitylivingbase);
        if (this.path != null) {
            return true;
        }
        return this.getAttackReachSqr(entitylivingbase) >= this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
    }

    public boolean func_75253_b() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase == null) {
            return false;
        }
        if (!entitylivingbase.func_70089_S()) {
            return false;
        }
        if (!this.longMemory) {
            return !this.attacker.func_70661_as().func_75500_f();
        }
        if (!this.attacker.func_180485_d(new BlockPos((Entity)entitylivingbase))) {
            return false;
        }
        return !(entitylivingbase instanceof EntityPlayer) && !(entitylivingbase instanceof EntityCreeper) && !(entitylivingbase instanceof EntityVillager) && !(entitylivingbase instanceof EntityFlying);
    }

    public void func_75249_e() {
        this.attacker.func_70661_as().func_75484_a(this.path, this.blockling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e());
        this.delayCounter = 0;
    }

    public void func_75251_c() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        if (entitylivingbase instanceof EntityPlayer || entitylivingbase instanceof EntityCreeper || entitylivingbase instanceof EntityVillager || entitylivingbase instanceof EntityFlying) {
            this.attacker.func_70624_b((EntityLivingBase)null);
        }
        this.attacker.func_70661_as().func_75499_g();
    }

    public void func_75246_d() {
        EntityLivingBase entitylivingbase = this.attacker.func_70638_az();
        this.attacker.func_70671_ap().func_75651_a((Entity)entitylivingbase, 30.0f, 30.0f);
        double d0 = this.attacker.func_70092_e(entitylivingbase.field_70165_t, entitylivingbase.func_174813_aQ().field_72338_b, entitylivingbase.field_70161_v);
        --this.delayCounter;
        if ((this.longMemory || this.attacker.func_70635_at().func_75522_a((Entity)entitylivingbase)) && this.delayCounter <= 0 && (this.targetX == 0.0 && this.targetY == 0.0 && this.targetZ == 0.0 || entitylivingbase.func_70092_e(this.targetX, this.targetY, this.targetZ) >= 1.0 || this.attacker.func_70681_au().nextFloat() < 0.05f)) {
            this.targetX = entitylivingbase.field_70165_t;
            this.targetY = entitylivingbase.func_174813_aQ().field_72338_b;
            this.targetZ = entitylivingbase.field_70161_v;
            this.delayCounter = 4 + this.attacker.func_70681_au().nextInt(7);
            if (this.canPenalize) {
                PathPoint finalPathPoint;
                this.delayCounter += this.failedPathFindingPenalty;
                this.failedPathFindingPenalty = this.attacker.func_70661_as().func_75505_d() != null ? ((finalPathPoint = this.attacker.func_70661_as().func_75505_d().func_75870_c()) != null && entitylivingbase.func_70092_e((double)finalPathPoint.field_75839_a, (double)finalPathPoint.field_75837_b, (double)finalPathPoint.field_75838_c) < 1.0 ? 0 : (this.failedPathFindingPenalty += 10)) : (this.failedPathFindingPenalty += 10);
            }
            if (d0 > 1024.0) {
                this.delayCounter += 10;
            } else if (d0 > 256.0) {
                this.delayCounter += 5;
            }
            if (this.blockling.blocklingType.textureName != "slimey_0") {
                if (!this.attacker.func_70661_as().func_75497_a((Entity)entitylivingbase, this.blockling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e())) {
                    this.delayCounter += 15;
                }
            } else {
                this.blockling.func_70625_a((Entity)this.blockling.func_70638_az(), 10.0f, 10.0f);
                ((EntityBlockling.SlimeMoveHelper)this.blockling.func_70605_aq()).setDirection(this.blockling.field_70177_z, true);
                ((EntityBlockling.SlimeMoveHelper)this.blockling.func_70605_aq()).setSpeed(1.0);
            }
        }
        this.attackTick = Math.max(this.attackTick - 1, 0);
        this.checkAndPerformAttack(entitylivingbase, d0);
    }

    protected void checkAndPerformAttack(EntityLivingBase p_190102_1_, double p_190102_2_) {
        double d0 = this.getAttackReachSqr(p_190102_1_);
        if (!this.blockling.isAttacking()) {
            this.blockling.startAttacking();
        }
        if (p_190102_2_ <= d0 && this.blockling.getAttackTimer() >= this.blockling.getAttackInterval()) {
            this.blockling.stopAttacking();
            this.attacker.func_70652_k((Entity)p_190102_1_);
        }
    }

    protected double getAttackReachSqr(EntityLivingBase attackTarget) {
        return this.attacker.field_70130_N * 2.0f * this.attacker.field_70130_N * 2.0f + attackTarget.field_70130_N;
    }
}

