/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.abilities.AbilityHelper;
import com.blocklings.entities.BlocklingAIGatherBase;
import com.blocklings.entities.EntityBlockling;
import com.blocklings.util.helpers.BlockHelper;
import com.blocklings.util.helpers.DropHelper;
import com.blocklings.util.helpers.EntityHelper;
import net.minecraft.block.Block;
import net.minecraft.block.BlockCrops;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Items;
import net.minecraft.item.Item;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BlocklingAIFarming
extends BlocklingAIGatherBase {
    private static final int X_RADIUS = 10;
    private static final int Y_RADIUS = 10;
    private int targetYValue;

    public BlocklingAIFarming(EntityBlockling blockling) {
        super(blockling);
    }

    public void func_75251_c() {
        this.blockling.stopMining();
        if (this.hasTarget()) {
            this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, -1);
        }
        this.resetTarget();
        super.func_75251_c();
    }

    @Override
    public boolean func_75250_a() {
        if (!this.canExecute()) {
            return false;
        }
        boolean foundCrop = false;
        this.resetTarget();
        this.targetPathSquareDistance = 10000.0;
        this.targetYValue = -1000;
        int x = (int)this.blockling.field_70165_t - 10;
        while ((double)x < this.blockling.field_70165_t + 10.0) {
            int y = (int)this.blockling.field_70163_u + 10;
            while ((double)y > this.blockling.field_70163_u - 10.0) {
                int z = (int)this.blockling.field_70161_v - 10;
                while ((double)z < this.blockling.field_70161_v + 10.0) {
                    Block block = this.getBlockAt(x, y, z);
                    if (BlockHelper.isCrop(block) && BlockHelper.isGrown(this.world.func_180495_p(new BlockPos(x, y, z)))) {
                        Path pathToBlock;
                        double xx = (float)x + 0.5f;
                        double yy = (float)y + 0.5f;
                        double zz = (float)z + 0.5f;
                        BlockPos blockPos = new BlockPos(x, y, z);
                        Vec3d blockVec = this.getVecFromBlockPos(blockPos);
                        if (y >= this.targetYValue && this.blockling.func_174791_d().func_72438_d(blockVec) < (double)this.range) {
                            this.targetPathSquareDistance = 1.0;
                            this.targetYValue = y;
                            this.setTarget(blockPos);
                            foundCrop = true;
                        }
                        if ((pathToBlock = this.getSafishPathTo(blockPos)) != null && this.isPathDestInRange(pathToBlock, blockPos)) {
                            double pathSquareDistance = this.getPathSquareDistance(pathToBlock);
                            if (y >= this.targetYValue && pathSquareDistance - 10.0 < this.targetPathSquareDistance) {
                                this.targetPathSquareDistance = pathSquareDistance;
                                this.targetYValue = y;
                                this.setTarget(blockPos, pathToBlock);
                                foundCrop = true;
                            }
                        }
                    }
                    ++z;
                }
                --y;
            }
            ++x;
        }
        return foundCrop;
    }

    public boolean func_75253_b() {
        return this.canContinueExecuting();
    }

    @Override
    boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (this.blockling.getTask() != EntityHelper.Task.FARM) {
            return false;
        }
        return this.blockling.hasHoe();
    }

    @Override
    boolean canContinueExecuting() {
        return super.canContinueExecuting();
    }

    public void func_75246_d() {
        if (this.hasTarget()) {
            if (this.isBlocklingInRange(this.targetPos)) {
                if (this.tryHarvestTarget()) {
                    this.resetTarget();
                }
            } else if (!this.moveToTarget()) {
                this.resetTarget();
            }
        }
    }

    private boolean tryHarvestTarget() {
        this.blockling.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 1000.0f, 100.0f);
        if (!this.blockling.isMining()) {
            this.blockling.startMining();
        }
        if (this.blockling.getMiningTimer() >= this.blockling.getFarmingInterval()) {
            this.harvestBlock();
            this.blockling.stopMining();
            this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, -1);
            return true;
        }
        int progress = (int)((float)this.blockling.getMiningTimer() / (float)this.blockling.getFarmingInterval() * 9.0f);
        this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, progress);
        return false;
    }

    private void harvestBlock() {
        Item seed;
        if (this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.scythe) && this.rand.nextFloat() < 0.1f) {
            for (int x = -1; x < 2; ++x) {
                for (int z = -1; z < 2; ++z) {
                    IBlockState surroundingState;
                    BlockPos surroundingPos = new BlockPos(this.targetPos.func_177958_n() + x, this.targetPos.func_177956_o(), this.targetPos.func_177952_p() + z);
                    Block surroundingBlock = this.getBlockFromPos(surroundingPos);
                    if (!BlockHelper.isCrop(surroundingBlock) || !BlockHelper.isGrown(surroundingState = this.world.func_180495_p(surroundingPos))) continue;
                    NonNullList<ItemStack> dropStacks = DropHelper.getDops(this.blockling, this.world, surroundingPos);
                    for (ItemStack dropStack : dropStacks) {
                        ItemStack leftoverStack;
                        if (this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.plentifulHarvest) && this.rand.nextFloat() <= 0.5f && !(dropStack.func_77973_b() instanceof ItemBlock)) {
                            dropStack.func_190917_f(dropStack.func_190916_E());
                        }
                        if ((leftoverStack = this.blockling.inv.func_174894_a(dropStack)).func_190926_b()) continue;
                        this.blockling.func_70099_a(leftoverStack, 0.0f);
                    }
                    Item seed2 = BlockHelper.getSeed(this.getBlockFromPos(surroundingPos));
                    if (seed2 != Items.field_190931_a) {
                        int slot = this.blockling.inv.find(seed2);
                        this.world.func_175698_g(surroundingPos);
                        this.world.func_175656_a(surroundingPos, surroundingBlock.func_176223_P());
                        if (slot == -1) continue;
                        if (this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.clinicalDibber) && (double)this.rand.nextFloat() < 0.5) {
                            this.blockling.inv.func_70301_a(slot).func_190918_g(1);
                        }
                        if (!this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.fertilisationFarming) || !this.blockling.inv.takeStackFromInventory(new ItemStack(Items.field_151100_aR, 1, 15))) continue;
                        BlockCrops cropBlock = (BlockCrops)this.getBlockFromPos(surroundingPos);
                        cropBlock.func_176474_b(this.world, this.rand, surroundingPos, this.world.func_180495_p(surroundingPos));
                        this.world.func_175718_b(2005, surroundingPos, 0);
                        continue;
                    }
                    this.world.func_175698_g(surroundingPos);
                }
            }
        }
        NonNullList<ItemStack> dropStacks = DropHelper.getDops(this.blockling, this.world, this.targetPos);
        for (ItemStack dropStack : dropStacks) {
            ItemStack leftoverStack;
            if (this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.plentifulHarvest) && this.rand.nextFloat() <= 0.5f && !(dropStack.func_77973_b() instanceof ItemBlock)) {
                dropStack.func_190917_f(dropStack.func_190916_E());
            }
            if ((leftoverStack = this.blockling.inv.func_174894_a(dropStack)).func_190926_b()) continue;
            this.blockling.func_70099_a(leftoverStack, 0.0f);
        }
        if (this.blockling.isUsingHoeRight()) {
            this.blockling.damageItem(EnumHand.MAIN_HAND);
        }
        if (this.blockling.isUsingHoeLeft()) {
            this.blockling.damageItem(EnumHand.OFF_HAND);
        }
        this.blockling.incrementFarmingXp(this.rand.nextInt(5) + 3);
        Item item = seed = this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.replanter) ? BlockHelper.getSeed(this.getBlockFromPos(this.targetPos)) : Items.field_190931_a;
        if (seed != Items.field_190931_a) {
            int slot = this.blockling.inv.find(seed);
            this.world.func_175698_g(this.targetPos);
            this.world.func_175656_a(this.targetPos, this.targetBlock.func_176223_P());
            if (slot != -1) {
                if (this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.clinicalDibber) && (double)this.rand.nextFloat() < 0.5) {
                    this.blockling.inv.func_70301_a(slot).func_190918_g(1);
                }
                if (this.blockling.farmingAbilities.isAbilityAcquired(AbilityHelper.fertilisationFarming) && this.blockling.inv.takeStackFromInventory(new ItemStack(Items.field_151100_aR, 1, 15))) {
                    BlockCrops cropBlock = (BlockCrops)this.getBlockFromPos(this.targetPos);
                    cropBlock.func_176474_b(this.world, this.rand, this.targetPos, this.world.func_180495_p(this.targetPos));
                    this.world.func_175718_b(2005, this.targetPos, 0);
                }
            }
        } else {
            this.world.func_175698_g(this.targetPos);
        }
    }
}

