/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.entities;

import com.blocklings.abilities.AbilityHelper;
import com.blocklings.entities.BlocklingAIGatherBase;
import com.blocklings.entities.EntityBlockling;
import com.blocklings.util.helpers.BlockHelper;
import com.blocklings.util.helpers.DropHelper;
import com.blocklings.util.helpers.EntityHelper;
import net.minecraft.block.Block;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.pathfinding.Path;
import net.minecraft.util.EnumHand;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3d;

public class BlocklingAIMining
extends BlocklingAIGatherBase {
    private int xRadius = 10;
    private int yRadius = 10;
    private int targetYValue;

    public BlocklingAIMining(EntityBlockling blockling) {
        super(blockling);
    }

    public void func_75251_c() {
        this.blockling.stopMining();
        if (this.hasTarget()) {
            this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, -1);
        }
        this.resetTarget();
        super.func_75251_c();
    }

    @Override
    public boolean func_75250_a() {
        if (!this.canExecute()) {
            return false;
        }
        if (this.blockling.miningAbilities.isAbilityAcquired(AbilityHelper.dwarvenSenses1)) {
            this.xRadius = 20;
            this.yRadius = 20;
        } else {
            this.xRadius = 10;
            this.yRadius = 10;
        }
        boolean foundOre = false;
        this.resetTarget();
        this.targetPathSquareDistance = 10000.0;
        this.targetYValue = -1000;
        int x = (int)this.blockling.field_70165_t - this.xRadius;
        while ((double)x < this.blockling.field_70165_t + (double)this.xRadius) {
            int y = (int)this.blockling.field_70163_u + this.yRadius;
            while ((double)y > this.blockling.field_70163_u - (double)this.yRadius) {
                int z = (int)this.blockling.field_70161_v - this.xRadius;
                while ((double)z < this.blockling.field_70161_v + (double)this.xRadius) {
                    Block block = this.getBlockAt(x, y, z);
                    if (BlockHelper.isOre(block) && (this.blockling.miningAbilities.isAbilityAcquired(AbilityHelper.dwarvenSenses2) || this.canSeeBlock(x, y, z))) {
                        double xx = (float)x + 0.5f;
                        double yy = (float)y + 0.5f;
                        double zz = (float)z + 0.5f;
                        BlockPos blockPos = new BlockPos(x, y, z);
                        Vec3d blockVec = this.getVecFromBlockPos(blockPos);
                        if (this.blockling.func_184614_ca().func_150998_b(this.world.func_180495_p(blockPos)) || this.blockling.func_184592_cb().func_150998_b(this.world.func_180495_p(blockPos))) {
                            Path pathToBlock;
                            if (y >= this.targetYValue && this.blockling.func_174791_d().func_72438_d(blockVec) < (double)this.range) {
                                this.targetPathSquareDistance = 1.0;
                                this.targetYValue = y;
                                this.setTarget(blockPos);
                                foundOre = true;
                            }
                            if ((pathToBlock = this.getSafishPathTo(blockPos)) != null && this.isPathDestInRange(pathToBlock, blockPos)) {
                                double pathSquareDistance = this.getPathSquareDistance(pathToBlock);
                                if (y > this.targetYValue) {
                                    this.targetPathSquareDistance = pathSquareDistance;
                                    this.targetYValue = y;
                                    this.setTarget(blockPos, pathToBlock);
                                    foundOre = true;
                                } else if (pathSquareDistance < this.targetPathSquareDistance) {
                                    this.targetPathSquareDistance = pathSquareDistance;
                                    this.targetYValue = y;
                                    this.setTarget(blockPos, pathToBlock);
                                    foundOre = true;
                                }
                            }
                        }
                    }
                    ++z;
                }
                --y;
            }
            ++x;
        }
        return foundOre;
    }

    public boolean func_75253_b() {
        return this.canContinueExecuting();
    }

    @Override
    boolean canExecute() {
        if (!super.canExecute()) {
            return false;
        }
        if (this.blockling.getTask() != EntityHelper.Task.MINE) {
            return false;
        }
        return this.blockling.hasPickaxe();
    }

    @Override
    boolean canContinueExecuting() {
        return super.canContinueExecuting();
    }

    public void func_75246_d() {
        if (this.hasTarget()) {
            if (this.isBlocklingInRange(this.targetPos)) {
                if (this.tryMineTarget()) {
                    this.resetTarget();
                }
            } else if (!this.moveToTarget()) {
                this.resetTarget();
            }
        }
    }

    private boolean tryMineTarget() {
        this.blockling.func_70671_ap().func_75650_a(this.targetVec.field_72450_a, this.targetVec.field_72448_b, this.targetVec.field_72449_c, 1000.0f, 100.0f);
        if (!this.blockling.isMining()) {
            this.blockling.startMining();
        }
        if (this.blockling.getMiningTimer() == 0 && this.blockling.miningAbilities.isAbilityAcquired(AbilityHelper.brittleBlock) && this.rand.nextFloat() < 0.1f) {
            this.mineTarget();
            this.blockling.stopMining();
            this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, -1);
            return true;
        }
        if (this.blockling.getMiningTimer() >= this.blockling.getMiningInterval()) {
            this.mineTarget();
            this.blockling.stopMining();
            this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, -1);
            return true;
        }
        int progress = (int)((float)this.blockling.getMiningTimer() / (float)this.blockling.getMiningInterval() * 9.0f);
        this.world.func_175715_c(this.blockling.func_145782_y(), this.targetPos, progress);
        return false;
    }

    private void mineTarget() {
        NonNullList<ItemStack> dropStacks = DropHelper.getDops(this.blockling, this.world, this.targetPos);
        for (ItemStack dropStack : dropStacks) {
            ItemStack leftoverStack;
            if (this.blockling.miningAbilities.isAbilityAcquired(AbilityHelper.blocksmith)) {
                ItemStack smeltResult = DropHelper.getFurnaceResult(this.blockling, dropStack);
                ItemStack itemStack = dropStack = smeltResult != ItemStack.field_190927_a && smeltResult.func_77973_b() != Items.field_190931_a ? smeltResult : dropStack;
            }
            if ((leftoverStack = this.blockling.inv.func_174894_a(dropStack)).func_190926_b()) continue;
            this.blockling.func_70099_a(leftoverStack, 0.0f);
        }
        if (this.blockling.isUsingPickaxeRight()) {
            this.blockling.damageItem(EnumHand.MAIN_HAND);
        }
        if (this.blockling.isUsingPickaxeLeft()) {
            this.blockling.damageItem(EnumHand.OFF_HAND);
        }
        this.blockling.incrementMiningXp(this.rand.nextInt(5) + 3);
        this.world.func_175698_g(this.targetPos);
    }
}

