/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.guis;

import com.blocklings.abilities.Ability;
import com.blocklings.entities.EntityBlockling;
import com.blocklings.guis.GuiBlocklingBase;
import com.blocklings.util.ResourceLocationBlocklings;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Random;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;

abstract class GuiBlocklingAbility
extends GuiBlocklingBase {
    protected Random rand = new Random();
    protected ResourceLocation BACKGROUND = new ResourceLocationBlocklings("textures/guis/inventory_overlay.png");
    protected static final ResourceLocation ABILITIES = new ResourceLocationBlocklings("textures/guis/inventory_abilities.png");
    protected static final ResourceLocation ABILITIES2 = new ResourceLocationBlocklings("textures/guis/inventory_abilities2.png");
    protected static final ResourceLocation ABILITIES3 = new ResourceLocationBlocklings("textures/guis/inventory_abilities3.png");
    protected static ResourceLocation WINDOW = new ResourceLocationBlocklings("textures/guis/inventory3.png");
    protected int minScreenX = 0;
    protected int minScreenY = 0;
    protected int maxScreenX = 0;
    protected int maxScreenY = 0;
    protected List<Ability> abilities = new ArrayList<Ability>();
    protected int x;
    protected int y;
    protected Ability hoveredAbility;
    protected boolean init = true;
    private boolean haveNotMovedSinceMouseClick = false;
    private int beforeReleaseX;
    private int beforeReleaseY;
    private GuiButton buyButton;
    GuiButton reallocateButton;
    Ability selectedAbility = null;
    private int totalDifX = 0;
    private int totalDifY = 0;
    private int timeMoving = 0;

    protected GuiBlocklingAbility(EntityBlockling blockling, EntityPlayer player) {
        super(blockling, player);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.buyButton = new GuiButton(0, this.field_146294_l / 2 - 77, this.field_146295_m / 2 + 76, 72, 20, "Buy Ability");
        this.field_146292_n.add(this.buyButton);
        this.reallocateButton = new GuiButton(1, this.field_146294_l / 2 + 5, this.field_146295_m / 2 + 76, 72, 20, "Reallocate");
        this.field_146292_n.add(this.reallocateButton);
        if (this.init) {
            int minX = -10000;
            int minY = -10000;
            int maxX = 10000;
            int maxY = 10000;
            for (Ability ability : this.abilities) {
                minX = ability.x + ability.width > minX ? ability.x + ability.width : minX;
                minY = ability.y + ability.height > minY ? ability.y + ability.height : minY;
                maxX = ability.x < maxX ? ability.x : maxX;
                maxY = ability.y < maxY ? ability.y : maxY;
            }
            this.minScreenX = 160 - minX - 35;
            this.minScreenY = 150 - minY - 35;
            this.maxScreenX = -maxX + 35;
            this.maxScreenY = -maxY + 35;
            this.x = this.minScreenX + (this.maxScreenX - this.minScreenX) / 2;
            this.y = this.minScreenY + (this.maxScreenY - this.minScreenY) / 2;
            this.init = false;
        }
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        for (Ability ability : this.abilities) {
            boolean hasLevels = true;
            for (String skill : ability.levelRequirements.keySet()) {
                if (this.blockling.getLevel(skill) >= ability.levelRequirements.get(skill)) continue;
                hasLevels = false;
                break;
            }
            if (ability.state != Ability.State.ACQUIRED && hasLevels && (ability.parentAbility == null || ability.parentAbility.state == Ability.State.ACQUIRED)) {
                ability.state = Ability.State.UNLOCKED;
                continue;
            }
            if (ability.state != Ability.State.UNLOCKED) continue;
            ability.state = Ability.State.LOCKED;
        }
        this.buyButton.field_146124_l = this.selectedAbility != null && this.blockling.getSkillPoints() >= this.selectedAbility.skillPointCost;
        this.reallocateButton.field_146124_l = false;
        for (Ability ability : this.abilities) {
            if (ability.state != Ability.State.ACQUIRED) continue;
            this.reallocateButton.field_146124_l = true;
            break;
        }
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        this.hoveredAbility = this.getAbilityAtMouseLocation(mouseX, mouseY);
        this.updateXY(mouseX, mouseY);
        this.func_146276_q_();
        this.setDefaultRenderSettings();
        this.field_146297_k.func_110434_K().func_110577_a(this.BACKGROUND);
        this.func_73729_b(this.screenLeft, this.screenTop, 16 - Math.abs((this.x + 10000) % 16), 16 - Math.abs((this.y + 10000) % 16), 160, 150);
        this.drawLines();
        this.drawAbilities();
        this.setDefaultRenderSettings();
        int colour = 0xFFFFFF;
        if (this.getAbilityAtMouseLocation(mouseX, mouseY) != null) {
            colour = 0x6A000000;
        }
        GuiBlocklingAbility.func_73734_a((int)this.screenLeft, (int)this.screenTop, (int)(this.screenLeft + 160), (int)(this.screenTop + 150), (int)colour);
        this.setDefaultRenderSettings();
        this.field_146297_k.func_110434_K().func_110577_a(WINDOW);
        this.drawWindow();
        this.drawHover();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    @Override
    protected void func_146286_b(int mouseX, int mouseY, int state) {
        if (this.beforeReleaseX == this.x && this.beforeReleaseY == this.y) {
            Ability ability;
            this.selectedAbility = ability = this.getAbilityAtMouseLocation(mouseX, mouseY);
            if (ability != null && (ability.state != Ability.State.UNLOCKED || ability.hasConflictingAbility(this.abilities))) {
                this.selectedAbility = null;
            }
            super.func_146286_b(mouseX, mouseY, state);
        }
        this.isClicking = false;
        this.haveNotMovedSinceMouseClick = false;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.buyButton) {
            if (this.buyButton.field_146124_l) {
                this.selectedAbility.state = Ability.State.ACQUIRED;
                this.blockling.incrementSkillPoints(-this.selectedAbility.skillPointCost);
                if (this.rand.nextFloat() < 0.5f) {
                    this.player.func_184185_a(SoundEvents.field_193807_ew, 0.75f, 1.0f);
                } else {
                    this.player.func_184185_a(SoundEvents.field_193808_ex, 0.75f, 1.0f);
                }
            }
        } else if (button == this.reallocateButton) {
            for (Ability ability : this.abilities) {
                boolean loseSkillPoint;
                if (ability.state != Ability.State.ACQUIRED) continue;
                boolean bl = loseSkillPoint = (double)this.rand.nextFloat() >= 0.5;
                if (loseSkillPoint) {
                    int i = 0;
                    int highest = this.blockling.getCombatLevel();
                    if (this.blockling.getMiningLevel() > highest) {
                        highest = this.blockling.getMiningLevel();
                        i = 1;
                    }
                    if (this.blockling.getWoodcuttingLevel() > highest) {
                        highest = this.blockling.getWoodcuttingLevel();
                        i = 2;
                    }
                    if (this.blockling.getFarmingLevel() > highest) {
                        i = 3;
                    }
                    int noOfSkillPointsToLose = 0;
                    for (int highest2 = highest; highest2 > 1 && noOfSkillPointsToLose != ability.skillPointCost; ++noOfSkillPointsToLose, highest2 -= 5) {
                    }
                    if (noOfSkillPointsToLose > 0) {
                        this.blockling.incrementSkillPoints(-noOfSkillPointsToLose);
                        switch (i) {
                            case 0: {
                                this.blockling.setCombatLevel(highest - noOfSkillPointsToLose * 5);
                                if (this.blockling.getCombatLevel() <= 0) {
                                    this.blockling.setCombatLevel(1);
                                }
                                this.blockling.setCombatXp(0);
                                break;
                            }
                            case 1: {
                                this.blockling.setMiningLevel(highest - noOfSkillPointsToLose * 5);
                                if (this.blockling.getMiningLevel() <= 0) {
                                    this.blockling.setMiningLevel(1);
                                }
                                this.blockling.setMiningXp(0);
                                break;
                            }
                            case 2: {
                                this.blockling.setWoodcuttingLevel(highest - noOfSkillPointsToLose * 5);
                                if (this.blockling.getWoodcuttingLevel() <= 0) {
                                    this.blockling.setWoodcuttingLevel(1);
                                }
                                this.blockling.setWoodcuttingXp(0);
                                break;
                            }
                            case 3: {
                                this.blockling.setFarmingLevel(highest - noOfSkillPointsToLose * 5);
                                if (this.blockling.getFarmingLevel() <= 0) {
                                    this.blockling.setFarmingLevel(1);
                                }
                                this.blockling.setFarmingXp(0);
                            }
                        }
                    }
                }
                ability.state = Ability.State.LOCKED;
                this.blockling.incrementSkillPoints(ability.skillPointCost);
            }
        }
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.haveNotMovedSinceMouseClick = true;
        this.beforeReleaseX = this.x;
        this.beforeReleaseY = this.y;
    }

    protected void drawHover() {
        this.field_146297_k.func_110434_K().func_110577_a(WINDOW);
        this.field_73735_i += 15.0f;
        if (this.hoveredAbility != null) {
            int i;
            String text1 = this.hoveredAbility.name;
            LinkedHashMap<String, Integer> desc = new LinkedHashMap<String, Integer>(){
                {
                    for (String str : GuiBlocklingAbility.this.hoveredAbility.description) {
                        this.put(str, 0xFFFFFF);
                    }
                    this.put("", 0xFFFFFF);
                    this.put("Skill Point(s): " + Integer.toString(GuiBlocklingAbility.this.hoveredAbility.skillPointCost), GuiBlocklingAbility.this.blockling.getSkillPoints() >= GuiBlocklingAbility.this.hoveredAbility.skillPointCost ? 0xAAFFAA : 0xFFAAAA);
                    for (String skill : GuiBlocklingAbility.this.hoveredAbility.levelRequirements.keySet()) {
                        this.put(skill + " Level: " + Integer.toString(GuiBlocklingAbility.this.hoveredAbility.levelRequirements.get(skill)), GuiBlocklingAbility.this.blockling.getLevel(skill) >= GuiBlocklingAbility.this.hoveredAbility.levelRequirements.get(skill) ? 0xAAFFAA : 0xFFAAAA);
                    }
                }
            };
            int width1 = this.field_146289_q.func_78256_a(text1) + 34;
            int width2 = 100;
            for (String string : desc.keySet()) {
                width2 = width2 < this.field_146289_q.func_78256_a(string) ? this.field_146289_q.func_78256_a(string) : width2;
            }
            int startX = this.actualAbilityX(this.hoveredAbility) - 5;
            int startY = this.actualAbilityY(this.hoveredAbility) + 2;
            int width = 90;
            width = width1 > width2 ? width1 : width2 + 2;
            for (i = 0; i < desc.size(); ++i) {
                if (i == 0) {
                    this.func_73729_b(startX, startY + 17 + 16 * i, 0, 186, width, 20);
                    this.func_73729_b(startX + width, startY + 17 + 16 * i, 192, 186, 8, 20);
                    continue;
                }
                if (i == desc.size() - 1) {
                    this.func_73729_b(startX, startY + 17 + 12 * i + 2, 0, 188, width, 18);
                    this.func_73729_b(startX + width, startY + 17 + 12 * i + 2, 192, 188, 8, 18);
                    continue;
                }
                this.func_73729_b(startX, startY + 17 + 12 * i - 2, 0, 188, width, 18);
                this.func_73729_b(startX + width, startY + 17 + 12 * i - 2, 192, 188, 8, 18);
            }
            GlStateManager.func_179124_c((float)((float)this.hoveredAbility.highlightColour.getRed() / 255.0f), (float)((float)this.hoveredAbility.highlightColour.getGreen() / 255.0f), (float)((float)this.hoveredAbility.highlightColour.getBlue() / 255.0f));
            this.func_73729_b(startX, startY, 0, 166, width, 20);
            this.func_73729_b(startX + width, startY, 192, 166, 8, 20);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)25.0f);
            this.field_146289_q.func_175065_a(text1, (float)(startX + 34), (float)(startY + 6), 0xFFFFFF, true);
            for (i = 0; i < desc.size(); ++i) {
                String string = (String)desc.keySet().toArray()[i];
                this.field_146289_q.func_175065_a(string, (float)(startX + 5), (float)(startY + 24 + 12 * i), ((Integer)desc.get(string)).intValue(), true);
            }
            GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-25.0f);
        }
        this.field_73735_i -= 15.0f;
    }

    protected void drawWindow() {
        this.field_73735_i += 10.0f;
        this.func_73729_b(this.left, this.top, 0, 0, 232, 166);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)11.0f);
        String skillPoints = Integer.toString(this.blockling.getSkillPoints());
        int center = this.field_146289_q.func_78256_a(skillPoints) / 2;
        if (skillPoints.length() == 2) {
            center = 0;
        }
        this.field_146289_q.func_78276_b(skillPoints, this.screenLeft + 12 + center, this.screenTop - 1, 0x333333);
        this.field_146289_q.func_78276_b(skillPoints, this.screenLeft + 11 + center, this.screenTop - 2, 0xFFFFFF);
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)-11.0f);
        this.field_73735_i -= 10.0f;
    }

    private void drawLines() {
        for (Ability ability : this.abilities) {
            for (Ability child : ability.getChildren(this.abilities)) {
                int i;
                int colour1 = ability.state.colour.brighter().getRGB();
                int colour2 = -15592942;
                int abilityX = ability.x + ability.width / 2;
                int abilityY = ability.y + ability.height / 2;
                int childX = child.x + child.width / 2;
                int childY = child.y + child.height / 2;
                int difX = abilityX - childX;
                int difY = abilityY - childY;
                int cornerX = abilityX - difX;
                int cornerY = abilityY - difY;
                int startX = this.screenLeft + this.x + abilityX;
                int endX = this.screenLeft + this.x + cornerX;
                int startY = this.screenTop + this.y + abilityY;
                int endY = this.screenTop + this.y + cornerY;
                if (difX > 0) {
                    i = startX;
                    startX = endX;
                    endX = i;
                }
                if (difY > 0) {
                    i = startY;
                    startY = endY;
                    endY = i;
                }
                if (startX < this.screenLeft) {
                    startX = this.screenLeft;
                } else if (startX > this.screenLeft + 160) {
                    startX = this.screenLeft + 160;
                }
                if (startY < this.screenTop) {
                    startY = this.screenTop;
                } else if (startY > this.screenTop + 150 + 4) {
                    startY = this.screenTop + 150 + 4;
                }
                if (endX < this.screenLeft) {
                    endX = this.screenLeft;
                } else if (endX > this.screenLeft + 160) {
                    endX = this.screenLeft + 160;
                }
                if (endY < this.screenTop) {
                    endY = this.screenTop;
                } else if (endY > this.screenTop + 150 + 4) {
                    endY = this.screenTop + 150 + 4;
                }
                int changeX = 0;
                int changeY = 0;
                if (difX < 0) {
                    changeX = -1;
                }
                this.func_73730_a(startX + changeX, endX + changeX, startY + changeY, colour1);
                if (difX > 0) {
                    this.func_73728_b(startX + changeX, endY + changeY, startY + changeY, colour1);
                    this.func_73728_b(startX + changeX, endY + changeY - 2, endY + changeY, colour2);
                } else {
                    this.func_73728_b(endX + changeX, endY + changeY, startY + changeY, colour1);
                    this.func_73728_b(endX + changeX, endY + changeY - 2, endY + changeY, colour2);
                }
                changeX = -1;
                changeY = -1;
                if (difX < 0) {
                    changeX = 0;
                }
                this.func_73730_a(startX + changeX, endX + changeX, startY + changeY, colour1);
                if (difX > 0) {
                    this.func_73728_b(startX + changeX, endY + changeY, startY + changeY, colour1);
                    this.func_73728_b(startX + changeX, endY + changeY - 2, endY + changeY, colour2);
                } else {
                    this.func_73728_b(endX + changeX, endY + changeY, startY + changeY, colour1);
                    this.func_73728_b(endX + changeX, endY + changeY - 2, endY + changeY, colour2);
                }
                changeX = -2;
                changeY = -2;
                if (difX < 0) {
                    changeX = 1;
                }
                this.func_73730_a(startX + changeX, endX + changeX, startY + changeY, colour2);
                if (difX > 0) {
                    this.func_73728_b(startX + changeX, endY + changeY - 2, startY + changeY, colour2);
                } else {
                    this.func_73728_b(endX + changeX, endY + changeY - 2, startY + changeY, colour2);
                }
                changeX = 1;
                changeY = 1;
                if (difX < 0) {
                    changeX = -2;
                }
                this.func_73730_a(startX + changeX, endX + changeX, startY + changeY, colour2);
                if (difX > 0) {
                    this.func_73728_b(startX + changeX, endY + changeY - 2, startY + changeY, colour2);
                    continue;
                }
                this.func_73728_b(endX + changeX, endY + changeY - 2, startY + changeY, colour2);
            }
        }
    }

    private void drawAbilities() {
        for (Ability ability : this.abilities) {
            this.drawAbility(ability);
        }
    }

    private void drawAbility(Ability ability) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_179147_l();
        RenderHelper.func_74518_a();
        int startX = 0;
        int startY = 0;
        int startDrawX = 0;
        int startDrawY = 0;
        int difX = 0;
        int difY = 0;
        if (this.hoveredAbility == null || this.hoveredAbility != ability) {
            if (this.x + ability.x < 0) {
                startX = difX = -(this.x + ability.x);
                startDrawX = difX;
            }
            if (this.x + ability.x + ability.width > 160) {
                difX = -(160 - (this.x + ability.x + ability.width));
                startX = 0;
                startDrawX = 0;
            }
            if (this.y + ability.y < 0) {
                startY = difY = -(this.y + ability.y);
                startDrawY = difY;
            }
            if (this.y + ability.y + ability.height > 150) {
                difY = -(150 - (this.y + ability.y + ability.height));
                startY = 0;
                startDrawY = 0;
            }
        }
        if (difX <= ability.width && difY <= ability.height) {
            Color abilityColour = ability.state.colour;
            if (ability.hasConflictingAbility(this.abilities)) {
                abilityColour = new Color(5117973);
            }
            if (this.selectedAbility != null && ability == this.selectedAbility) {
                abilityColour = new Color(4569391);
            }
            float transparency = 1.0f;
            if (this.selectedAbility != null && ability == this.selectedAbility) {
                transparency = 1.0f;
            } else if (ability.state == Ability.State.LOCKED) {
                transparency = 0.5f;
            } else if (ability.hasConflictingAbility(this.abilities)) {
                transparency = 0.5f;
            }
            if (this.hoveredAbility != null) {
                int i = this.hoveredAbility == ability ? 20 : 0;
                this.field_73735_i += (float)i;
                this.field_146297_k.func_110434_K().func_110577_a(ABILITIES);
                GlStateManager.func_179124_c((float)((float)abilityColour.getRed() / 255.0f), (float)((float)abilityColour.getGreen() / 255.0f), (float)((float)abilityColour.getBlue() / 255.0f));
                this.func_73729_b(this.screenLeft + this.x + ability.x + startX, this.screenTop + this.y + ability.y + startY, ability.shapeX + startDrawX, ability.shapeY + startDrawY, ability.width - difX, ability.height - difY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                this.field_146297_k.func_110434_K().func_110577_a(ABILITIES2);
                this.func_73729_b(this.screenLeft + this.x + ability.x + startX, this.screenTop + this.y + ability.y + startY, ability.iconX + startDrawX, ability.iconY + startDrawY, ability.width - difX, ability.height - difY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                this.field_73735_i -= (float)i;
            } else {
                this.field_146297_k.func_110434_K().func_110577_a(ABILITIES);
                GlStateManager.func_179124_c((float)((float)abilityColour.getRed() / 255.0f), (float)((float)abilityColour.getGreen() / 255.0f), (float)((float)abilityColour.getBlue() / 255.0f));
                this.func_73729_b(this.screenLeft + this.x + ability.x + startX, this.screenTop + this.y + ability.y + startY, ability.shapeX + startDrawX, ability.shapeY + startDrawY, ability.width - difX, ability.height - difY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)transparency);
                this.field_146297_k.func_110434_K().func_110577_a(ABILITIES2);
                this.func_73729_b(this.screenLeft + this.x + ability.x + startX, this.screenTop + this.y + ability.y + startY, ability.iconX + startDrawX, ability.iconY + startDrawY, ability.width - difX, ability.height - difY);
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            }
        }
    }

    private void updateXY(int mouseX, int mouseY) {
        if (this.isClicking && (this.getAbilityAtMouseLocation(mouseX, mouseY) == null || !this.haveNotMovedSinceMouseClick || this.totalDifX > 12 || this.totalDifY > 12 || this.timeMoving > 10)) {
            this.x += mouseX - this.prevMouseX;
            this.y += mouseY - this.prevMouseY;
            this.totalDifX = 0;
            this.totalDifY = 0;
            this.timeMoving = 0;
            this.haveNotMovedSinceMouseClick = false;
        } else if (this.isClicking) {
            this.totalDifX += Math.abs(mouseX - this.prevMouseX);
            this.totalDifY += Math.abs(mouseY - this.prevMouseY);
            ++this.timeMoving;
        }
        if (this.x < this.minScreenX) {
            this.x = this.minScreenX;
        } else if (this.x > this.maxScreenX) {
            this.x = this.maxScreenX;
        }
        if (this.y < this.minScreenY) {
            this.y = this.minScreenY;
        } else if (this.y > this.maxScreenY) {
            this.y = this.maxScreenY;
        }
    }

    private Ability getAbilityAtMouseLocation(int mouseX, int mouseY) {
        if (this.isMouseOverScreen(mouseX, mouseY)) {
            for (Ability ability : this.abilities) {
                if (mouseX < this.actualAbilityX(ability) || mouseX >= this.actualAbilityX(ability) + ability.width || mouseY < this.actualAbilityY(ability) || mouseY >= this.actualAbilityY(ability) + ability.height) continue;
                return ability;
            }
        }
        return null;
    }

    private int actualAbilityX(Ability ability) {
        return this.screenLeft + this.x + ability.x;
    }

    private int actualAbilityY(Ability ability) {
        return this.screenTop + this.y + ability.y;
    }

    @Override
    public void func_146281_b() {
        this.blockling.syncAbilities();
        super.func_146281_b();
    }
}

