/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.guis;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.guis.GuiBlocklingBase;
import com.blocklings.guis.GuiTextFieldCentered;
import com.blocklings.util.ResourceLocationBlocklings;
import com.blocklings.util.helpers.EntityHelper;
import com.blocklings.util.helpers.GuiHelper;
import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.entity.RenderManager;
import net.minecraft.entity.Entity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.TextFormatting;

public class GuiBlocklingStats
extends GuiBlocklingBase {
    private static final ResourceLocation WINDOW = new ResourceLocationBlocklings("textures/guis/inventory" + GuiHelper.Tab.STATS.id + ".png");
    private GuiButton taskButton;
    private GuiButton guardButton;
    private GuiButton stateButton;
    private GuiTextFieldCentered nameTextField;

    GuiBlocklingStats(EntityBlockling blockling, EntityPlayer player) {
        super(blockling, player);
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.taskButton = new GuiButton(0, this.field_146294_l / 2 - 81, this.field_146295_m / 2 + 46, 52, 20, this.blockling.getTask().name);
        this.field_146292_n.add(this.taskButton);
        this.guardButton = new GuiButton(1, this.field_146294_l / 2 - 25, this.field_146295_m / 2 + 46, 51, 20, this.blockling.getGuard().name);
        this.field_146292_n.add(this.guardButton);
        this.stateButton = new GuiButton(2, this.field_146294_l / 2 + 29, this.field_146295_m / 2 + 46, 52, 20, this.blockling.getState().name);
        this.field_146292_n.add(this.stateButton);
        this.nameTextField = new GuiTextFieldCentered(3, this.field_146289_q, this.field_146294_l / 2 - 80, this.field_146295_m / 2 - 85, 160, 20){

            @Override
            public void setFocused(boolean isFocusedIn) {
                GuiBlocklingStats.this.blockling.setName(GuiBlocklingStats.this.nameTextField.getText());
                GuiBlocklingStats.this.nameTextField.setText(GuiBlocklingStats.this.blockling.func_95999_t());
                super.setFocused(isFocusedIn);
            }
        };
        this.nameTextField.setText(this.blockling.func_95999_t());
    }

    @Override
    public void func_73876_c() {
        super.func_73876_c();
        this.nameTextField.updateCursorCounter();
    }

    @Override
    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        int speed;
        int nextXp;
        int xp;
        this.func_146276_q_();
        this.setDefaultRenderSettings();
        this.field_146297_k.func_110434_K().func_110577_a(WINDOW);
        this.func_73729_b(this.left, this.top, 0, 0, 232, 166);
        this.drawInfo();
        this.setDefaultRenderSettings();
        int yness = this.blockling.hasTool() ? 0 : 4;
        GuiBlocklingStats.drawEntityOnScreen(this.field_146294_l / 2, this.field_146295_m / 2 + 16 - yness, 55, this.field_146294_l / 2 - mouseX, this.field_146295_m / 2 - mouseY - 16 - yness, this.blockling);
        int size = 11;
        int i = -50;
        int j = -22;
        int k = -72;
        int xx = this.field_146294_l / 2 + k;
        int yy = this.field_146295_m / 2 + i;
        if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 0, size, size)) {
            xp = this.blockling.getCombatXp();
            nextXp = EntityHelper.getXpUntilNextLevel(this.blockling.getCombatLevel());
            speed = this.blockling.getAttackInterval();
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Combat");
            info.add(TextFormatting.GRAY + "XP: " + TextFormatting.DARK_AQUA + xp + "/" + nextXp);
            info.add(TextFormatting.GRAY + "Attack Interval: " + TextFormatting.DARK_RED + speed);
            this.func_146283_a(info, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 1, size, size)) {
            xp = this.blockling.getMiningXp();
            nextXp = EntityHelper.getXpUntilNextLevel(this.blockling.getMiningLevel());
            speed = this.blockling.getMiningInterval();
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Mining");
            info.add(TextFormatting.GRAY + "XP: " + TextFormatting.DARK_AQUA + xp + "/" + nextXp);
            info.add(TextFormatting.GRAY + "Mining Interval: " + TextFormatting.DARK_RED + speed);
            this.func_146283_a(info, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 2, size, size)) {
            xp = this.blockling.getWoodcuttingXp();
            nextXp = EntityHelper.getXpUntilNextLevel(this.blockling.getWoodcuttingLevel());
            speed = this.blockling.getChoppingInterval();
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Woodcutting");
            info.add(TextFormatting.GRAY + "XP: " + TextFormatting.DARK_AQUA + xp + "/" + nextXp);
            info.add(TextFormatting.GRAY + "Chopping Interval: " + TextFormatting.DARK_RED + speed);
            this.func_146283_a(info, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 3, size, size)) {
            xp = this.blockling.getFarmingXp();
            nextXp = EntityHelper.getXpUntilNextLevel(this.blockling.getFarmingLevel());
            speed = this.blockling.getFarmingInterval();
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Farming");
            info.add(TextFormatting.GRAY + "XP: " + TextFormatting.DARK_AQUA + xp + "/" + nextXp);
            info.add(TextFormatting.GRAY + "Farming Interval: " + TextFormatting.DARK_RED + speed);
            this.func_146283_a(info, mouseX, mouseY);
        }
        xx = this.field_146294_l / 2 - k - size;
        if (this.isMouseOver(mouseX, mouseY, xx, (yy -= 2) - j * 0, size, size)) {
            float maxHealth;
            float health = this.blockling.func_110143_aJ();
            double healthPercentage = health / (maxHealth = this.blockling.func_110138_aP());
            TextFormatting tf = healthPercentage < 0.33 ? TextFormatting.DARK_RED : (healthPercentage < 0.66 ? TextFormatting.YELLOW : TextFormatting.GREEN);
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Health");
            info.add(tf + "" + (int)health + "/" + (int)maxHealth);
            this.func_146283_a(info, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 1, size, size)) {
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Damage");
            this.func_146283_a(info, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 2, size, size)) {
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Attack Interval");
            this.func_146283_a(info, mouseX, mouseY);
        } else if (this.isMouseOver(mouseX, mouseY, xx, yy - j * 3, size, size)) {
            ArrayList<String> info = new ArrayList<String>();
            info.add(TextFormatting.GOLD + "Movement Speed");
            this.func_146283_a(info, mouseX, mouseY);
        }
        this.setDefaultRenderSettings();
        this.nameTextField.drawTextBox();
        super.func_73863_a(mouseX, mouseY, partialTicks);
    }

    private void drawInfo() {
        int size = 11;
        int i = -50;
        int j = -22;
        int k = -72;
        int xx = this.field_146294_l / 2 + k;
        int yy = this.field_146295_m / 2 + i;
        this.func_73729_b(xx, yy - j * 3, 0, 166, size, size);
        this.func_73729_b(xx, yy - j * 0, 11, 166, size, size);
        this.func_73729_b(xx, yy - j * 1, 22, 166, size, size);
        this.func_73729_b(xx, yy - j * 2, 33, 166, size, size);
        int colour = 0xD1D1D1;
        colour = 0xB30000;
        colour = 0xFF4D4D;
        String combatLevelString = Integer.toString(this.blockling.getCombatLevel());
        this.field_146289_q.func_175065_a(combatLevelString, (float)(xx += 15), (float)((yy += 2) - j * 0), colour, true);
        colour = 2708131;
        colour = 7378139;
        String miningLevelString = Integer.toString(this.blockling.getMiningLevel());
        this.field_146289_q.func_175065_a(miningLevelString, (float)xx, (float)(yy - j * 1), colour, true);
        colour = 692998;
        colour = 5744219;
        String woodcuttingLevelString = Integer.toString(this.blockling.getWoodcuttingLevel());
        this.field_146289_q.func_175065_a(woodcuttingLevelString, (float)xx, (float)(yy - j * 2), colour, true);
        colour = 8998160;
        colour = 10317130;
        String farmingLevelString = Integer.toString(this.blockling.getFarmingLevel());
        this.field_146289_q.func_175065_a(farmingLevelString, (float)xx, (float)(yy - j * 3), colour, true);
        this.setDefaultRenderSettings();
        this.field_146297_k.func_110434_K().func_110577_a(WINDOW);
        xx = this.field_146294_l / 2 - k - size;
        this.func_73729_b(xx, (yy -= 2) - j * 0, 0, 166 + size, size, size);
        this.func_73729_b(xx, yy - j * 1, 11, 166 + size, size, size);
        this.func_73729_b(xx, yy - j * 2, 22, 166 + size, size, size);
        this.func_73729_b(xx, yy - j * 3, 33, 166 + size, size, size);
        xx -= 15 - size;
        yy += 2;
        double health = this.blockling.func_110143_aJ();
        double maxHealth = this.blockling.func_110138_aP();
        double r = 163.0 - 92.0 * (health / maxHealth);
        double g = 0.0 + 171.0 * (health / maxHealth);
        double b = 0.0 + 3.0 * (health / maxHealth);
        colour = (int)r;
        colour = (colour << 8) + (int)g;
        colour = (colour << 8) + (int)b;
        String healthString = Integer.toString((int)health);
        this.field_146289_q.func_175065_a(healthString, (float)(xx - this.field_146289_q.func_78256_a(healthString)), (float)(yy - j * 0), colour, true);
        colour = 16497184;
        String damageString = "" + (int)this.blockling.func_110148_a(SharedMonsterAttributes.field_111264_e).func_111126_e();
        this.field_146289_q.func_175065_a(damageString, (float)(xx - this.field_146289_q.func_78256_a(damageString)), (float)(yy - j * 1), colour, true);
        String attackSpeedString = "" + this.blockling.getAttackInterval();
        this.field_146289_q.func_175065_a(attackSpeedString, (float)(xx - this.field_146289_q.func_78256_a(attackSpeedString)), (float)(yy - j * 2), colour, true);
        String speedString = "" + (int)(this.blockling.func_110148_a(SharedMonsterAttributes.field_111263_d).func_111126_e() * 40.0);
        this.field_146289_q.func_175065_a(speedString, (float)(xx - this.field_146289_q.func_78256_a(speedString)), (float)(yy - j * 3), colour, true);
        size = 11;
        i = -50;
        j = -22;
        k = -72;
        xx = this.field_146294_l / 2 + k;
        yy = this.field_146295_m / 2 + i;
    }

    private static void drawEntityOnScreen(int posX, int posY, int scale, float mouseX, float mouseY, EntityBlockling ent) {
        float scale2 = ent.getBlocklingScale();
        GlStateManager.func_179142_g();
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)posX, (float)posY, (float)50.0f);
        GlStateManager.func_179152_a((float)((float)(-scale) / scale2), (float)((float)scale / scale2), (float)((float)scale / scale2));
        GlStateManager.func_179114_b((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        float f = ent.field_70761_aq;
        float f1 = ent.field_70177_z;
        float f2 = ent.field_70125_A;
        float f3 = ent.field_70758_at;
        float f4 = ent.field_70759_as;
        GlStateManager.func_179114_b((float)135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        RenderHelper.func_74519_b();
        GlStateManager.func_179114_b((float)-135.0f, (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.func_179114_b((float)(-((float)Math.atan(mouseY / 40.0f)) * 20.0f), (float)1.0f, (float)0.0f, (float)0.0f);
        ent.field_70761_aq = (float)Math.atan(mouseX / 40.0f) * 20.0f;
        ent.field_70177_z = (float)Math.atan(mouseX / 40.0f) * 40.0f;
        ent.field_70125_A = -((float)Math.atan(mouseY / 40.0f)) * 20.0f;
        ent.field_70759_as = ent.field_70177_z;
        ent.field_70758_at = ent.field_70177_z;
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)0.0f);
        RenderManager rendermanager = Minecraft.func_71410_x().func_175598_ae();
        rendermanager.func_178631_a(180.0f);
        rendermanager.func_178633_a(false);
        rendermanager.func_188391_a((Entity)ent, 0.0, 0.0, 0.0, 0.0f, 1.0f, false);
        rendermanager.func_178633_a(true);
        ent.field_70761_aq = f;
        ent.field_70177_z = f1;
        ent.field_70125_A = f2;
        ent.field_70758_at = f3;
        ent.field_70759_as = f4;
        GlStateManager.func_179121_F();
        RenderHelper.func_74518_a();
        GlStateManager.func_179101_C();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77476_b);
        GlStateManager.func_179090_x();
        GlStateManager.func_179138_g((int)OpenGlHelper.field_77478_a);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        if (button == this.taskButton) {
            this.blockling.cycleTask();
            this.taskButton.field_146126_j = this.blockling.getTask().name;
        } else if (button == this.guardButton) {
            this.blockling.cycleGuard();
            this.guardButton.field_146126_j = this.blockling.getGuard().name;
        } else if (button == this.stateButton) {
            this.blockling.cycleState();
            this.stateButton.field_146126_j = this.blockling.getState().name;
        }
    }

    @Override
    public boolean func_73868_f() {
        return false;
    }

    @Override
    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        this.nameTextField.mouseClicked(mouseX, mouseY, mouseButton);
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        super.func_73869_a(typedChar, keyCode);
        switch (keyCode) {
            case 28: {
                this.nameTextField.setFocused(false);
            }
        }
        this.nameTextField.textboxKeyTyped(typedChar, keyCode);
    }

    @Override
    public void func_146281_b() {
        if (this.nameTextField != null) {
            this.nameTextField.setFocused(false);
        }
        this.blockling.setTask(this.blockling.getTask());
        this.blockling.setGuard(this.blockling.getGuard());
        this.blockling.setState(this.blockling.getState());
        super.func_146281_b();
    }
}

