/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.util.helpers;

import com.blocklings.abilities.AbilityHelper;
import com.blocklings.entities.EntityBlockling;
import com.blocklings.util.helpers.EntityHelper;
import com.blocklings.util.helpers.ToolHelper;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public class DropHelper {
    private static final Random rand = new Random();

    public static NonNullList<ItemStack> getDops(EntityBlockling blockling, World world, BlockPos blockPos) {
        Block block;
        IBlockState blockState;
        ToolHelper.Enchantment enchantment;
        List<NBTTagCompound> enchantments;
        boolean toolMatchesTaskOff;
        NonNullList dropStacks = NonNullList.func_191196_a();
        ItemStack mainStack = blockling.func_184614_ca();
        ItemStack offStack = blockling.func_184592_cb();
        int fortuneLevel = 0;
        boolean silkTouch = false;
        boolean toolMatchesTaskMain = blockling.isUsingPickaxeRight() && blockling.getTask() == EntityHelper.Task.MINE || blockling.isUsingAxeRight() && blockling.getTask() == EntityHelper.Task.CHOP;
        boolean bl = toolMatchesTaskOff = blockling.isUsingPickaxeLeft() && blockling.getTask() == EntityHelper.Task.MINE || blockling.isUsingAxeLeft() && blockling.getTask() == EntityHelper.Task.CHOP;
        if (toolMatchesTaskMain) {
            enchantments = ToolHelper.getEnchantmentTagsFromTool(mainStack);
            for (NBTTagCompound enchantmentTag : enchantments) {
                enchantment = ToolHelper.Enchantment.getEnchantmentFromTag(enchantmentTag);
                if (enchantment == ToolHelper.Enchantment.FORTUNE) {
                    fortuneLevel += enchantmentTag.func_74762_e("lvl");
                }
                if (enchantment != ToolHelper.Enchantment.SILKTOUCH) continue;
                silkTouch = true;
            }
        }
        if (toolMatchesTaskOff) {
            enchantments = ToolHelper.getEnchantmentTagsFromTool(offStack);
            for (NBTTagCompound enchantmentTag : enchantments) {
                enchantment = ToolHelper.Enchantment.getEnchantmentFromTag(enchantmentTag);
                if (enchantment == ToolHelper.Enchantment.FORTUNE) {
                    fortuneLevel += enchantmentTag.func_74762_e("lvl");
                }
                if (enchantment != ToolHelper.Enchantment.SILKTOUCH) continue;
                silkTouch = true;
            }
        }
        if (silkTouch) {
            blockState = world.func_180495_p(blockPos);
            block = blockState.func_177230_c();
            dropStacks.add((Object)new ItemStack(Item.func_150898_a((Block)block)));
        } else {
            blockState = world.func_180495_p(blockPos);
            block = blockState.func_177230_c();
            block.getDrops(dropStacks, (IBlockAccess)world, blockPos, blockState, fortuneLevel);
        }
        return dropStacks;
    }

    public static ItemStack getFurnaceResult(EntityBlockling blockling, ItemStack stack) {
        ItemStack result = FurnaceRecipes.func_77602_a().func_151395_a(stack);
        ItemStack copy = result.func_77946_l();
        if (rand.nextFloat() < 0.25f) {
            if (blockling.miningAbilities.isAbilityAcquired(AbilityHelper.metallurgy2)) {
                copy.func_190920_e(copy.func_190916_E() * 3);
            } else if (blockling.miningAbilities.isAbilityAcquired(AbilityHelper.metallurgy1)) {
                copy.func_190920_e(copy.func_190916_E() * 2);
            }
        }
        return copy;
    }
}

