/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.util.helpers;

import com.blocklings.entities.EntityBlockling;
import com.blocklings.main.Blocklings;
import com.blocklings.render.RenderBlockling;
import com.blocklings.util.ResourceLocationBlocklings;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.init.Biomes;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityHelper {
    public static final float BASE_SCALE = 0.75f;
    public static final float BASE_SCALE_FOR_HITBOX = 0.7125f;
    public static final int SKILL_POINT_INTERVAL = 5;
    public static final float SWING_SPEED_COEF = 0.75f;

    public static void registerEntities() {
        int id = 1;
        EntityRegistry.registerModEntity((ResourceLocation)new ResourceLocationBlocklings("entity_blockling"), EntityBlockling.class, (String)"blockling", (int)id++, (Object)Blocklings.instance, (int)64, (int)3, (boolean)true, (int)7951674, (int)7319108);
        EntityRegistry.addSpawn(EntityBlockling.class, (int)10, (int)1, (int)2, (EnumCreatureType)EnumCreatureType.CREATURE, (Biome[])new Biome[]{Biomes.field_76772_c, Biomes.field_76767_f, Biomes.field_76785_t, Biomes.field_150578_U, Biomes.field_150585_R, Biomes.field_76768_g, Biomes.field_76784_u});
    }

    @SideOnly(value=Side.CLIENT)
    public static void registerRenderers() {
        RenderingRegistry.registerEntityRenderingHandler(EntityBlockling.class, (IRenderFactory)RenderBlockling.FACTORY);
    }

    public static int getXpUntilNextLevel(int level) {
        return (int)(Math.exp((double)level / 25.0) * 40.0) - 30;
    }

    public static enum State {
        STAY("Stay", 1),
        FOLLOW("Follow", 2),
        WANDER("Wander", 3);

        public String name;
        public int id;

        private State(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static State getFromID(int id) {
            for (State state : State.values()) {
                if (state.id != id) continue;
                return state;
            }
            return WANDER;
        }
    }

    public static enum Guard {
        NOGUARD("Ignore", 1),
        GUARD("Guard", 2);

        public String name;
        public int id;

        private Guard(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static Guard getFromID(int id) {
            for (Guard guard : Guard.values()) {
                if (guard.id != id) continue;
                return guard;
            }
            return NOGUARD;
        }
    }

    public static enum Task {
        IDLE("Idle", 1),
        HUNT("Hunt", 2),
        MINE("Mine", 3),
        CHOP("Chop", 4),
        FARM("Farm", 5);

        public String name;
        public int id;

        private Task(String name, int id) {
            this.name = name;
            this.id = id;
        }

        public static Task getFromID(int id) {
            for (Task task : Task.values()) {
                if (task.id != id) continue;
                return task;
            }
            return IDLE;
        }
    }
}

