/*
 * Decompiled with CFR 0.152.
 */
package com.blocklings.util.helpers;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.init.Items;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class ToolHelper {
    public static List<Item> weapons = new ArrayList<Item>();
    public static List<Item> pickaxes = new ArrayList<Item>();
    public static List<Item> axes = new ArrayList<Item>();
    public static List<Item> hoes = new ArrayList<Item>();

    public static boolean isTool(Item item) {
        return weapons.contains(item) || pickaxes.contains(item) || axes.contains(item) || hoes.contains(item);
    }

    public static boolean isWeapon(Item item) {
        return weapons.contains(item);
    }

    public static boolean isPickaxe(Item item) {
        return pickaxes.contains(item);
    }

    public static boolean isAxe(Item item) {
        return axes.contains(item);
    }

    public static boolean isHoe(Item item) {
        return hoes.contains(item);
    }

    public static int getWeaponLevel(Item item) {
        return weapons.indexOf(item);
    }

    public static int getPickaxeLevel(Item item) {
        return pickaxes.indexOf(item);
    }

    public static int getAxeLevel(Item item) {
        return axes.indexOf(item);
    }

    public static int getHoeLevel(Item item) {
        return hoes.indexOf(item);
    }

    public static float getToolAttackDamage(ItemStack stack) {
        Object[] array;
        float damage = 0.0f;
        if (!stack.func_190926_b() && (array = stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackDamage").toArray()).length > 0) {
            damage = (float)((AttributeModifier)array[0]).func_111164_d() + 1.0f;
        }
        return damage;
    }

    public static float getToolAttackSpeed(ItemStack stack) {
        Object[] array;
        float speed = 1000.0f;
        if (!stack.func_190926_b() && (array = stack.func_111283_C(EntityEquipmentSlot.MAINHAND).get((Object)"generic.attackSpeed").toArray()).length > 0) {
            speed = (float)Math.abs(((AttributeModifier)array[0]).func_111164_d()) + 1.0f;
        }
        return 1.0f / speed;
    }

    public static float getToolAttackPower(ItemStack stack) {
        return (float)Math.log(ToolHelper.getToolAttackDamage(stack)) * ToolHelper.getToolAttackSpeed(stack);
    }

    public static List<Enchantment> getEnchantmentsFromTool(ItemStack toolStack) {
        ArrayList<Enchantment> enchantmentList = new ArrayList<Enchantment>();
        if (!toolStack.func_190926_b()) {
            NBTTagList enchantments = toolStack.func_77986_q();
            for (int e = 0; e < enchantments.func_74745_c(); ++e) {
                NBTTagCompound enchantmentTag = enchantments.func_150305_b(e);
                Enchantment enchantment = Enchantment.getEnchantmentFromID(enchantmentTag.func_74732_a());
                if (enchantment == null) continue;
                enchantmentList.add(enchantment);
            }
        }
        return enchantmentList;
    }

    public static List<NBTTagCompound> getEnchantmentTagsFromTool(ItemStack toolStack) {
        ArrayList<NBTTagCompound> enchantmentList = new ArrayList<NBTTagCompound>();
        if (!toolStack.func_190926_b()) {
            NBTTagList enchantments = toolStack.func_77986_q();
            for (int e = 0; e < enchantments.func_74745_c(); ++e) {
                enchantmentList.add(enchantments.func_150305_b(e));
            }
        }
        return enchantmentList;
    }

    static {
        weapons.add(Items.field_151041_m);
        weapons.add(Items.field_151052_q);
        weapons.add(Items.field_151010_B);
        weapons.add(Items.field_151040_l);
        weapons.add(Items.field_151048_u);
        pickaxes.add(Items.field_151039_o);
        pickaxes.add(Items.field_151050_s);
        pickaxes.add(Items.field_151005_D);
        pickaxes.add(Items.field_151035_b);
        pickaxes.add(Items.field_151046_w);
        axes.add(Items.field_151053_p);
        axes.add(Items.field_151049_t);
        axes.add(Items.field_151006_E);
        axes.add(Items.field_151036_c);
        axes.add(Items.field_151056_x);
        hoes.add(Items.field_151017_I);
        hoes.add(Items.field_151018_J);
        hoes.add(Items.field_151013_M);
        hoes.add(Items.field_151019_K);
        hoes.add(Items.field_151012_L);
    }

    public static enum Enchantment {
        FORTUNE(35),
        UNBREAKING(34),
        SILKTOUCH(33),
        EFFICIENCY(32),
        SHARPNESS(16),
        SMITE(17),
        BANEOFARTHROPODS(18),
        KNOCKBACK(19),
        FIREASPECT(20),
        LOOTING(21);

        private int id;

        private Enchantment(int id) {
            this.id = id;
        }

        public static Enchantment getEnchantmentFromID(int id) {
            for (Enchantment enchantment : Enchantment.values()) {
                if (enchantment.id != id) continue;
                return enchantment;
            }
            return null;
        }

        public static Enchantment getEnchantmentFromTag(NBTTagCompound tag) {
            return Enchantment.getEnchantmentFromID(tag.func_74762_e("id"));
        }
    }
}

