/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Capability;

import net.eldercodes.thercmod.Capability.IItemStackHandler;

public class ItemStackCapability
implements IItemStackHandler {
    private float batteryCharge = 100.0f;
    private float motorTemp = 25.0f;
    private boolean remoteControlPowerState = false;
    private boolean hasBattery = true;
    private boolean hasESC = true;
    private boolean hasMotor = true;

    @Override
    public void setCharge(float charge) {
        this.batteryCharge = charge;
    }

    @Override
    public float getCharge() {
        return this.batteryCharge;
    }

    @Override
    public double getNormalizedCharge() {
        return (double)this.batteryCharge / 100.0;
    }

    @Override
    public void drainBattery(float drain) {
        this.batteryCharge -= drain;
        this.batteryCharge = Math.max(0.0f, this.batteryCharge);
    }

    @Override
    public void togglePowerState() {
        this.remoteControlPowerState = !this.remoteControlPowerState;
    }

    @Override
    public boolean getPowerState() {
        return this.remoteControlPowerState;
    }

    @Override
    public void setPowerState(boolean state) {
        this.remoteControlPowerState = state;
    }

    @Override
    public void setMotorTemp(float temp) {
        this.motorTemp = temp;
    }

    @Override
    public float getMotorTemp() {
        return this.motorTemp;
    }

    @Override
    public void addMotorTemp(float delta) {
        this.motorTemp += delta;
    }

    @Override
    public void setEntityItems(boolean bat, boolean esc, boolean mot, float motTemp, float batCharge) {
        this.hasBattery = bat;
        this.hasESC = esc;
        this.hasMotor = mot;
        this.motorTemp = motTemp;
        this.batteryCharge = batCharge;
    }

    @Override
    public boolean hasBattery() {
        return this.hasBattery;
    }

    @Override
    public boolean hasESC() {
        return this.hasESC;
    }

    @Override
    public boolean hasMotor() {
        return this.hasMotor;
    }
}

