/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Gui;

import java.io.IOException;
import net.eldercodes.thercmod.Entities.GlobalEntity;
import net.eldercodes.thercmod.Gui.EntityContainer;
import net.eldercodes.thercmod.Gui.EntityGuiButton;
import net.eldercodes.thercmod.Items.ItemBattery;
import net.eldercodes.thercmod.Items.ItemElectricMotor;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.entity.player.InventoryPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.Slot;
import net.minecraft.util.ResourceLocation;

public class EntityGui
extends GuiContainer {
    private static final ResourceLocation guiTexture = new ResourceLocation("thercmod:textures/overlay/entitygui.png");
    private static final ResourceLocation guiPlaneIcon = new ResourceLocation("thercmod:textures/items/item_trainerplane.png");
    private static final ResourceLocation guiCarIcon = new ResourceLocation("thercmod:textures/items/item_car.png");
    private static final ResourceLocation guiBoatIcon = new ResourceLocation("thercmod:textures/items/item_boat.png");
    private static final ResourceLocation guiHeliIcon = new ResourceLocation("thercmod:textures/items/item_heli.png");
    private static final ResourceLocation guiDroneIcon = new ResourceLocation("thercmod:textures/items/item_drone.png");
    private static final ResourceLocation guiF22Icon = new ResourceLocation("thercmod:textures/items/item_f22.png");
    private static final ResourceLocation guiSubmarineIcon = new ResourceLocation("thercmod:textures/items/item_submarine.png");
    private static final ResourceLocation guiStuntPlaneIcon = new ResourceLocation("thercmod:textures/items/item_stuntplane.png");
    private static final ResourceLocation guiOctocopterIcon = new ResourceLocation("thercmod:textures/items/item_octocopter.png");
    private static final ResourceLocation guiRacerIcon = new ResourceLocation("thercmod:textures/items/item_racer.png");
    private final InventoryPlayer player;
    private final GlobalEntity rcentity;
    private ItemBattery itemBattery;
    private ItemElectricMotor itemMotor;

    public EntityGui(InventoryPlayer player, GlobalEntity rcentity) {
        super((Container)new EntityContainer(player, rcentity));
        this.player = player;
        this.rcentity = rcentity;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.add(new EntityGuiButton(1, this.field_147003_i + 106, this.field_147009_r + 47, 30, 7, this.rcentity.activated));
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        this.func_146276_q_();
        this.field_146297_k.func_110434_K().func_110577_a(guiTexture);
        this.func_73729_b(this.field_147003_i, this.field_147009_r, 0, 0, this.field_146999_f, this.field_147000_g);
        this.field_146297_k.func_110434_K().func_110577_a(this.getIconResourceLocation(this.rcentity.getID()));
        EntityGui.func_146110_a((int)(this.field_147003_i + 10), (int)(this.field_147009_r + 10), (float)0.0f, (float)0.0f, (int)64, (int)64, (float)64.0f, (float)64.0f);
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = ((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(1)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d();
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        String entityName = this.rcentity.getEntityName();
        this.field_146289_q.func_78276_b(entityName, this.field_146999_f / 2 - this.field_146289_q.func_78256_a(entityName) / 2, 6, 0x404040);
        this.field_146289_q.func_78276_b("Inventory", 8, 72, 0x404040);
        this.drawControlsText(this.rcentity.defaultControls);
        this.drawInfo();
        this.func_191948_b(mouseX - this.field_147003_i, mouseY - this.field_147009_r);
    }

    private ResourceLocation getIconResourceLocation(int id) {
        switch (id) {
            case 1: {
                return guiPlaneIcon;
            }
            case 2: {
                return guiDroneIcon;
            }
            case 3: {
                return guiCarIcon;
            }
            case 4: {
                return guiF22Icon;
            }
            case 5: {
                return guiHeliIcon;
            }
            case 6: {
                return guiF22Icon;
            }
            case 7: {
                return guiBoatIcon;
            }
            case 8: {
                return guiSubmarineIcon;
            }
            case 9: {
                return guiStuntPlaneIcon;
            }
            case 10: {
                return guiOctocopterIcon;
            }
            case 11: {
                return guiRacerIcon;
            }
        }
        return guiPlaneIcon;
    }

    private void drawControlsText(String[] controlList) {
        GlStateManager.func_179094_E();
        int HeightOffSet = this.field_147009_r - 20;
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        for (int i = 0; i < controlList.length; ++i) {
            this.field_146289_q.func_78276_b(controlList[i], -this.field_146999_f - 40, HeightOffSet, 0xFFFFFF);
            HeightOffSet += 16;
        }
        GlStateManager.func_179121_F();
    }

    private void drawInfo() {
        String strTemp = "0";
        String strPerc = "0";
        if (((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d()) {
            this.itemMotor = (ItemElectricMotor)((Slot)this.field_147002_h.field_75151_b.get(0)).func_75211_c().func_77973_b();
            strTemp = String.format("%.0f", Float.valueOf(this.itemMotor.getMotorTemp(this.field_147002_h.func_75139_a(0).func_75211_c())));
        }
        if (((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d()) {
            this.itemBattery = (ItemBattery)((Slot)this.field_147002_h.field_75151_b.get(2)).func_75211_c().func_77973_b();
            strPerc = String.format("%.0f", Float.valueOf(this.itemBattery.getCharge(this.field_147002_h.func_75139_a(2).func_75211_c())));
        }
        GlStateManager.func_179094_E();
        int HeightOffSet = 41;
        GlStateManager.func_179152_a((float)0.5f, (float)0.5f, (float)1.0f);
        this.field_146289_q.func_78276_b("Electric Motor", this.field_146999_f + 25, HeightOffSet, 0x404040);
        this.field_146289_q.func_78276_b("Temperature: " + strTemp + "\u00b0C", this.field_146999_f + 25, HeightOffSet + 12, 0x404040);
        this.field_146289_q.func_78276_b("Electric Speed Controller", this.field_146999_f + 25, HeightOffSet + 40, 0x404040);
        this.field_146289_q.func_78276_b("On", this.field_146999_f + 25, HeightOffSet + 40 + 16, 0x404040);
        this.field_146289_q.func_78276_b("Off", this.field_146999_f + 96, HeightOffSet + 40 + 16, 0x404040);
        this.field_146289_q.func_78276_b("Battery", this.field_146999_f + 25, HeightOffSet + 80, 0x404040);
        this.field_146289_q.func_78276_b("Charge: " + strPerc + "%", this.field_146999_f + 25, HeightOffSet + 12 + 80, 0x404040);
        GlStateManager.func_179121_F();
    }

    protected void func_146284_a(GuiButton parButton) {
        EntityGuiButton button = (EntityGuiButton)parButton;
        this.rcentity.sendStateToServer(button.getButtonState());
    }

    protected void func_73864_a(int mouseX, int mouseY, int mouseButton) throws IOException {
        super.func_73864_a(mouseX, mouseY, mouseButton);
        EntityGuiButton button = (EntityGuiButton)((Object)this.field_146292_n.get(0));
        if (!(((Slot)this.field_147002_h.field_75151_b.get(0)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(1)).func_75216_d() && ((Slot)this.field_147002_h.field_75151_b.get(2)).func_75216_d() || !button.getButtonState().booleanValue())) {
            this.rcentity.sendStateToServer(false);
            button.setState(false);
        }
    }
}

