/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Items;

import java.util.List;
import javax.annotation.Nullable;
import net.eldercodes.thercmod.Capability.IItemStackHandler;
import net.eldercodes.thercmod.Capability.ItemStackProvider;
import net.eldercodes.thercmod.RCM_Main;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.registries.IForgeRegistryEntry;

public class ItemElectricMotor
extends Item {
    public ItemElectricMotor() {
        this.setRegistryName("item_electricmotor");
        ForgeRegistries.ITEMS.register((IForgeRegistryEntry)this);
        this.func_77655_b("item_electricmotor");
        this.func_77637_a(RCM_Main.tab);
        this.field_77777_bU = 1;
        this.func_77627_a(false);
    }

    public void func_77663_a(ItemStack stack, World worldIn, Entity entityIn, int itemSlot, boolean isSelected) {
        if (!isSelected) {
            float altitude = (float)(entityIn.field_70163_u - worldIn.field_73011_w.getHorizon());
            float tempDiff = 25.0f + worldIn.func_180494_b(entityIn.func_180425_c()).func_180626_a(entityIn.func_180425_c()) * 10.0f - 0.4f * altitude - this.getMotorTemp(stack);
            float cooling = 2.3565001f * tempDiff / 2310.0f;
            this.changeMotorTemp(cooling, stack);
        }
    }

    public void setMotorTemp(float temp, ItemStack stack) {
        ((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null)).setMotorTemp(temp);
    }

    public float getMotorTemp(ItemStack stack) {
        return ((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null)).getMotorTemp();
    }

    public void changeMotorTemp(float delta, ItemStack stack) {
        ((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null)).addMotorTemp(delta);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<String> tooltip, ITooltipFlag flagIn) {
        String strPerc = String.format("%.0f", Float.valueOf(((IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null)).getMotorTemp()));
        tooltip.add(TextFormatting.BLUE + "Temperature: " + strPerc + "\u00b0C");
    }

    @Nullable
    public NBTTagCompound getNBTShareTag(ItemStack stack) {
        NBTTagCompound tag = stack.func_77978_p();
        if (tag == null) {
            tag = new NBTTagCompound();
        }
        IItemStackHandler handler = (IItemStackHandler)stack.getCapability(ItemStackProvider.ITEMSTACK_CAP, null);
        NBTBase capTag = ItemStackProvider.ITEMSTACK_CAP.getStorage().writeNBT(ItemStackProvider.ITEMSTACK_CAP, (Object)handler, null);
        tag.func_74782_a("ItemCap", capTag);
        return tag;
    }

    public void readNBTShareTag(ItemStack stack, @Nullable NBTTagCompound nbt) {
        stack.func_77982_d(nbt);
        if (nbt != null) {
            NBTTagCompound capTag = (NBTTagCompound)nbt.func_74781_a("ItemCap");
            this.setMotorTemp(capTag.func_74760_g("motorTemp"), stack);
        }
    }
}

