/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Physics.PhysicsHelper;

public class AutoControlHandler {
    private PhysicsHelper helper = new PhysicsHelper();
    private Vector3f sensePoint;
    private int ID;
    private float angGain;
    private float angLimit;
    private float output;

    public AutoControlHandler(int ID2, Vector3f sensePoint2, float linGain2, float linLimit2, float angGain2, float angLimit2) {
        this.ID = ID2;
        this.sensePoint = new Vector3f(sensePoint2);
        this.angGain = angGain2;
        this.angLimit = angLimit2;
    }

    public void update(Quat4f localQuat, Vector3f linearVelocity, Vector3f virtualFlyBar, Vector3f virtualTailBar, Vector3f virtualFlightBar) {
        Vector3f globalSensePoint = this.helper.rotateVector(localQuat, this.sensePoint);
        if (this.ID > 30 && virtualFlightBar.length() > 0.0f) {
            Vector3f difference = new Vector3f(virtualFlightBar);
            Vector3f dir = this.helper.rotateVector(localQuat, new Vector3f(this.sensePoint.y, -this.sensePoint.x, this.sensePoint.x));
            float diff = difference.dot(dir);
            dir.scale(diff);
            difference.sub((Tuple3f)dir);
            float angle = difference.angle(globalSensePoint) - 90.0f * this.helper.degToRad;
            float angOutput = this.angGain * angle;
            if (angOutput > this.angLimit) {
                angOutput = this.angLimit;
            } else if (angOutput < -this.angLimit) {
                angOutput = -this.angLimit;
            }
            this.output = angOutput;
        } else if (this.ID > 20) {
            float angle;
            float angOutput;
            Vector3f difference = new Vector3f(virtualTailBar);
            Vector3f dir = this.helper.rotateVector(localQuat, new Vector3f(1.0f, 0.0f, 0.0f));
            difference.sub((Tuple3f)globalSensePoint);
            if (difference.length() > 0.0f) {
                difference.normalize();
            }
            if ((angOutput = this.angGain * (angle = virtualTailBar.angle(globalSensePoint) * dir.dot(difference))) > this.angLimit) {
                angOutput = this.angLimit;
            } else if (angOutput < -this.angLimit) {
                angOutput = -this.angLimit;
            }
            this.output = angOutput;
        } else if (this.ID > 10) {
            float angle = virtualFlyBar.angle(globalSensePoint) - 90.0f * this.helper.degToRad;
            float angOutput = this.angGain * angle;
            if (angOutput > this.angLimit) {
                angOutput = this.angLimit;
            } else if (angOutput < -this.angLimit) {
                angOutput = -this.angLimit;
            }
            this.output = angOutput;
        }
    }

    public float getResponse() {
        return this.output;
    }

    public float getMotorResponse(float power) {
        if (power == 0.0f) {
            return 0.0f;
        }
        return this.output;
    }

    public int getID() {
        return this.ID;
    }
}

