/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import java.util.ArrayList;
import java.util.List;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Physics.PhysicsHelper;

public class FloatsHandler {
    private PhysicsHelper helper;
    private int sections;
    private float radius;
    private float dragCoef;
    private float totalVolume;
    private float totalArea;
    private float[] sectionPos;
    private float[] sectionVel;
    private List<Vector3f> sectionVelVect = new ArrayList<Vector3f>();
    private List<Vector3f> sectionBouy = new ArrayList<Vector3f>();
    private List<Vector3f> sectionDrag = new ArrayList<Vector3f>();
    private List<Vector3f> sectionPosVect = new ArrayList<Vector3f>();
    private Vector3f globalSpanVect;
    private Vector3f globalPosition;
    private Vector3f localSpanVect;
    private Vector3f localPositionVect;

    public FloatsHandler(Vector3f pos, Vector3f spanV, float drgC, float rad, int sect) {
        this.helper = new PhysicsHelper();
        this.sections = sect;
        this.radius = rad;
        this.dragCoef = drgC;
        this.totalVolume = 1.3333334f * (float)(Math.PI * Math.pow(rad, 3.0));
        this.totalArea = 4.0f * (float)(Math.PI * Math.pow(rad, 2.0));
        this.globalSpanVect = new Vector3f();
        this.globalPosition = new Vector3f();
        this.localSpanVect = new Vector3f(spanV);
        this.localPositionVect = new Vector3f(pos);
        this.sectionPos = new float[this.sections];
        this.sectionVel = new float[this.sections];
        this.calculateFloatSectionProperties();
    }

    private void calculateFloatSectionProperties() {
        for (int i = 0; i < this.sections; ++i) {
            this.sectionPos[i] = this.radius * 2.0f * (float)i;
            this.sectionVelVect.add(new Vector3f());
            this.sectionBouy.add(new Vector3f());
            this.sectionDrag.add(new Vector3f());
            this.sectionPosVect.add(new Vector3f());
        }
    }

    public void update(Vector3f pos, Quat4f localQuat, Vector3f linearVel, Vector3f rotationalVel, float floatReference, float density) {
        this.globalSpanVect.set((Tuple3f)this.helper.rotateVector(localQuat, this.localSpanVect));
        this.globalPosition.set((Tuple3f)this.helper.rotateVector(localQuat, this.localPositionVect));
        Vector3f dragVect = new Vector3f();
        Vector3f surfVelVec = new Vector3f();
        for (int i = 0; i < this.sections; ++i) {
            float capHeight;
            Vector3f sectionVect = new Vector3f(this.globalSpanVect);
            sectionVect.scale(this.sectionPos[i]);
            sectionVect.add((Tuple3f)this.globalPosition);
            this.sectionPosVect.get(i).set((Tuple3f)sectionVect);
            this.sectionVelVect.get(i).set((Tuple3f)this.helper.getVelocityAtPoint(linearVel, rotationalVel, sectionVect));
            this.sectionVelVect.get(i).scale(-1.0f);
            this.sectionVel[i] = this.sectionVelVect.get(i).length();
            surfVelVec.set(this.sectionVelVect.get((int)i).x, 0.0f, this.sectionVelVect.get((int)i).z);
            float surfaceVel = surfVelVec.length();
            float volume = 0.0f;
            float area = 0.0f;
            float lift = 0.0f;
            if (pos.y + sectionVect.y + this.radius <= floatReference) {
                volume = this.totalVolume;
                area = this.totalArea;
            } else if (pos.y + sectionVect.y <= floatReference) {
                capHeight = floatReference - (sectionVect.y + pos.y);
                float capVolume = (3.0f * this.radius - capHeight) * (this.helper.PI * capHeight * capHeight) / 3.0f;
                volume = this.totalVolume - capVolume;
                float capArea = 2.0f * this.helper.PI * this.radius * capHeight;
                area = this.totalArea - capArea;
            } else if (pos.y + sectionVect.y - this.radius <= floatReference) {
                capHeight = floatReference - (sectionVect.y - this.radius + pos.y);
                volume = (3.0f * this.radius - capHeight) * (this.helper.PI * capHeight * capHeight) / 3.0f;
                area = 2.0f * this.helper.PI * this.radius * capHeight;
                lift = 0.25f * density * surfaceVel * surfaceVel * this.dragCoef * area;
            }
            float bouyancy = density * 9.81f * volume + lift;
            float drag = 0.5f * density * this.sectionVel[i] * this.dragCoef * area;
            dragVect.set((Tuple3f)this.sectionVelVect.get(i));
            if (dragVect.length() > 0.0f) {
                dragVect.normalize();
            }
            dragVect.scale(drag);
            this.sectionBouy.get(i).setY(bouyancy);
            this.sectionDrag.get(i).set((Tuple3f)dragVect);
        }
    }

    public Vector3f getPosition(int i) {
        return this.sectionPosVect.get(i);
    }

    public Vector3f getBouyancy(int i) {
        return this.sectionBouy.get(i);
    }

    public int getSections() {
        return this.sections;
    }

    public Vector3f getDrag(int i) {
        return this.sectionDrag.get(i);
    }
}

