/*
 * Decompiled with CFR 0.152.
 */
package net.eldercodes.thercmod.Physics;

import javax.annotation.Nullable;
import javax.vecmath.AxisAngle4f;
import javax.vecmath.Quat4f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3f;
import net.eldercodes.thercmod.Physics.PhysicsHelper;

public class VirtualReferenceHandler {
    private Vector3f flyBar = new Vector3f(0.0f, 1.0f, 0.0f);
    private Vector3f tailBar = new Vector3f(0.0f, 0.0f, -1.0f);
    private Vector3f flightPath = new Vector3f();
    private float scaleFactor = 2.3f;
    private PhysicsHelper helper = new PhysicsHelper();
    private float limit = 0.2617994f;

    public void updateBars(Vector3f pitchAxis, Vector3f yawAxis, Vector3f rollAxis, float pitchControl, float yawControl, float rollControl, float deltaTime) {
        float pitchDeltAngle = this.virtualBarLimit(this.flyBar, rollAxis, pitchAxis, pitchControl * (float)Math.sqrt(Math.abs(pitchControl)) * deltaTime * this.scaleFactor);
        float rollDeltAngle = this.virtualBarLimit2(this.flyBar, pitchAxis, rollAxis, rollControl * (float)Math.sqrt(Math.abs(rollControl)) * deltaTime * this.scaleFactor);
        float yawDeltAngle = this.virtualBarLimit(this.tailBar, pitchAxis, yawAxis, yawControl * (float)Math.sqrt(Math.abs(yawControl)) * deltaTime * this.scaleFactor);
        AxisAngle4f pitchRot = new AxisAngle4f(pitchAxis.x, pitchAxis.y, pitchAxis.z, pitchDeltAngle);
        AxisAngle4f rollRot = new AxisAngle4f(rollAxis.x, rollAxis.y, rollAxis.z, rollDeltAngle);
        AxisAngle4f yawRot = new AxisAngle4f(yawAxis.x, yawAxis.y, yawAxis.z, yawDeltAngle);
        Quat4f rollQuat = new Quat4f();
        Quat4f pitchQuat = new Quat4f();
        Quat4f yawQuat = new Quat4f();
        rollQuat.set(rollRot);
        pitchQuat.set(pitchRot);
        yawQuat.set(yawRot);
        rollQuat.mul(pitchQuat);
        rollQuat.mul(yawQuat);
        this.flyBar = this.helper.rotateVector(rollQuat, this.flyBar);
        this.tailBar = this.helper.rotateVector(rollQuat, this.tailBar);
    }

    public void updateSafeBars(Vector3f pitchAxis, Vector3f yawAxis, Vector3f rollAxis, float pitchControl, float yawControl, float rollControl, float deltaTime) {
        float pitchDeltAngle = pitchControl * 0.349066f;
        float rollDeltAngle = rollControl * 0.349066f;
        float yawDeltAngle = this.virtualBarLimit(this.tailBar, pitchAxis, yawAxis, yawControl * (float)Math.sqrt(Math.abs(yawControl)) * deltaTime * this.scaleFactor);
        AxisAngle4f pitchRot = new AxisAngle4f(pitchAxis.x, pitchAxis.y, pitchAxis.z, pitchDeltAngle);
        AxisAngle4f rollRot = new AxisAngle4f(rollAxis.x, rollAxis.y, rollAxis.z, rollDeltAngle);
        AxisAngle4f yawRot = new AxisAngle4f(yawAxis.x, yawAxis.y, yawAxis.z, yawDeltAngle);
        Quat4f rollQuat = new Quat4f();
        Quat4f pitchQuat = new Quat4f();
        Quat4f yawQuat = new Quat4f();
        rollQuat.set(rollRot);
        pitchQuat.set(pitchRot);
        yawQuat.set(yawRot);
        rollQuat.mul(pitchQuat);
        rollQuat.mul(yawQuat);
        this.flyBar = this.helper.rotateVector(rollQuat, this.flyBar);
        this.tailBar = this.helper.rotateVector(rollQuat, this.tailBar);
    }

    public void resetFlybars(Vector3f Forward) {
        this.flyBar.set(0.0f, 1.0f, 0.0f);
        this.tailBar.set((Tuple3f)Forward);
    }

    public void updateFlyPath(Vector3f pitchAxis, Vector3f yawAxis, Vector3f rollAxis, @Nullable Vector3f targetPath, Vector3f frontPath) {
        if (targetPath == null) {
            this.flightPath.set((Tuple3f)frontPath);
            this.flightPath.scale(-1.0f);
        } else {
            this.flightPath.set((Tuple3f)targetPath);
        }
    }

    public float virtualBarLimit(Vector3f bar, Vector3f refAxis, Vector3f subAxis, float deltaAngle) {
        Vector3f subtractAxis = new Vector3f(subAxis);
        float subtractQty = subtractAxis.dot(bar);
        subtractAxis.scale(subtractQty);
        Vector3f refBar = new Vector3f(bar);
        refBar.sub((Tuple3f)subtractAxis);
        float diffAngle = refBar.angle(refAxis) - this.helper.degToRad * 90.0f;
        float unitAngle = 0.0f;
        if (Math.abs(diffAngle) > 0.0f) {
            unitAngle = diffAngle / Math.abs(diffAngle);
        }
        if (Math.abs(diffAngle - deltaAngle) > this.limit) {
            if (Math.abs(diffAngle) > this.limit) {
                return diffAngle - this.limit * unitAngle;
            }
            return this.limit * unitAngle - diffAngle;
        }
        return deltaAngle;
    }

    public float virtualBarLimit2(Vector3f bar, Vector3f refAxis, Vector3f subAxis, float deltaAngle) {
        Vector3f subtractAxis = new Vector3f(subAxis);
        float subtractQty = subtractAxis.dot(bar);
        subtractAxis.scale(subtractQty);
        Vector3f refBar = new Vector3f(bar);
        refBar.sub((Tuple3f)subtractAxis);
        float diffAngle = refBar.angle(refAxis) - this.helper.degToRad * 90.0f;
        float unitAngle = 0.0f;
        if (Math.abs(diffAngle) > 0.0f) {
            unitAngle = diffAngle / Math.abs(diffAngle);
        }
        if (Math.abs(diffAngle + deltaAngle) > this.limit) {
            if (Math.abs(diffAngle) > this.limit) {
                return this.limit * unitAngle - diffAngle;
            }
            return diffAngle - this.limit * unitAngle;
        }
        return deltaAngle;
    }

    public Vector3f getVirtualFlyBar() {
        return this.flyBar;
    }

    public Vector3f getVirtualTailBar() {
        return this.tailBar;
    }

    public Vector3f getVirtualFlightPath() {
        return this.flightPath;
    }
}

