/*
 * Decompiled with CFR 0.152.
 */
package forestry.energy.compat;

import forestry.energy.EnergyManager;
import forestry.energy.EnergyTransferMode;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyStorageWrapper
implements IEnergyStorage {
    private final EnergyManager energyManager;
    private final EnergyTransferMode mode;

    public EnergyStorageWrapper(EnergyManager energyManager, EnergyTransferMode mode) {
        this.energyManager = energyManager;
        this.mode = mode;
    }

    public boolean canExtract() {
        return this.mode.canExtract() && this.energyManager.canExtract();
    }

    public boolean canReceive() {
        return this.mode.canReceive() && this.energyManager.canReceive();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.mode.canReceive()) {
            return this.energyManager.receiveEnergy(maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.mode.canExtract()) {
            return this.energyManager.extractEnergy(maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.energyManager.getEnergyStored();
    }

    public int getMaxEnergyStored() {
        return this.energyManager.getMaxEnergyStored();
    }
}

