/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.banners;

import com.xcompwiz.mystcraft.api.word.DrawableWord;
import com.xcompwiz.mystcraft.client.render.PageBuilder;
import com.xcompwiz.mystcraft.client.render.RenderUtils;
import com.xcompwiz.mystcraft.words.DrawableWordManager;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BannerTextures;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@SideOnly(value=Side.CLIENT)
public class BannerGeneration {
    private static final Rectangle rectangle = new Rectangle(0, 20, 64, 64);

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static BufferedImage buildBackground() {
        ResourceLocation originalBackground = BannerTextures.field_187487_d;
        try (InputStream is = Minecraft.func_71410_x().func_110442_L().func_110536_a(originalBackground).func_110527_b();){
            BufferedImage image = ImageIO.read(is);
            BufferedImage bufferedImage = RenderUtils.scale(image, 3.0, 1, 6);
            return bufferedImage;
        }
        catch (IOException exc) {
            throw new RuntimeException("Couldn't find or open the page background image.", exc);
        }
    }

    public static BufferedImage createBufferedImage(String word) {
        if (word == null || word.isEmpty()) {
            return null;
        }
        DrawableWord wordDef = DrawableWordManager.getDrawableWord(word);
        if (wordDef == null) {
            return null;
        }
        BufferedImage baseImage = BannerGeneration.buildBackground();
        BufferedImage wordSource = PageBuilder.buildSymbolImage(DrawableWord.word_components);
        if (baseImage == null) {
            throw new IllegalStateException("Called texture loading outside of TextureManager's loading cycle!");
        }
        PageBuilder.PageSprite.stitchWord(baseImage, wordDef, rectangle, wordSource);
        BufferedImage down = RenderUtils.scale(baseImage, 0.3334, 2, 6);
        for (int y = 0; y < down.getHeight(); ++y) {
            for (int x = 0; x < down.getWidth(); ++x) {
                int rgb = down.getRGB(x, y);
                down.setRGB(x, y, -1 - rgb | 0xFF000000 & rgb);
            }
        }
        return down;
    }
}

