/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.command;

import com.xcompwiz.mystcraft.command.CommandBaseAdv;
import com.xcompwiz.mystcraft.debug.DebugHierarchy;
import com.xcompwiz.mystcraft.debug.DebugUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.command.WrongUsageException;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextComponentTranslation;

public class CommandDebug
extends CommandBaseAdv {
    public String func_71517_b() {
        return "myst-dbg";
    }

    public int func_82362_a() {
        return 2;
    }

    public String func_71518_a(ICommandSender par1ICommandSender) {
        return "/" + this.func_71517_b() + " <'read'> <param> OR <'set'> <flag>";
    }

    public boolean func_184882_a(MinecraftServer server, ICommandSender sender) {
        if (sender.func_70005_c_().equals("XCompWiz")) {
            return true;
        }
        return super.func_184882_a(server, sender);
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender par1ICommandSender, String[] args, @Nullable BlockPos targetPos) {
        if (args.length < 2) {
            return CommandDebug.func_71530_a((String[])args, (String[])new String[]{"read", "set", "run"});
        }
        if (args.length >= 2 && (args[0].equals("read") || args[0].equals("set") || args[0].equals("run"))) {
            return CommandDebug.func_71530_a((String[])args, (String[])this.getKeys(args));
        }
        return null;
    }

    protected String[] getKeys(String[] args) {
        String address = this.getAddress(Arrays.copyOf(args, args.length - 1));
        DebugHierarchy.IDebugElement elem = DebugUtils.getElement(address);
        if (elem == null) {
            elem = DebugHierarchy.root;
        }
        Collection<String> allflags = Collections.emptyList();
        if (elem instanceof DebugHierarchy.DebugNode) {
            allflags = ((DebugHierarchy.DebugNode)elem).getChildren();
        }
        String[] params = allflags.toArray(new String[allflags.size()]);
        return params;
    }

    private String getAddress(String[] args) {
        if (args.length == 0) {
            return null;
        }
        StringBuilder str = new StringBuilder();
        for (int i = 1; i < args.length; ++i) {
            if (str.length() > 0) {
                str.append(".");
            }
            str.append(args[i]);
        }
        return str.toString();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void func_184881_a(MinecraftServer server, ICommandSender agent, String[] args) throws CommandException {
        String command = null;
        String address = null;
        String setval = null;
        if (args.length <= 1) throw new WrongUsageException("Could not parse command.", new Object[0]);
        command = args[0];
        if (command.equals("set")) {
            setval = args[args.length - 1];
            args = Arrays.copyOf(args, args.length - 1);
        }
        address = this.getAddress(args);
        DebugHierarchy.IDebugElement elem = DebugUtils.getElement(address);
        if (command.equals("read")) {
            if (elem instanceof DebugHierarchy.DebugValueCallback) {
                String value = ((DebugHierarchy.DebugValueCallback)elem).get(agent);
                agent.func_145747_a((ITextComponent)new TextComponentString(value));
                return;
            } else {
                if (!(elem instanceof DebugHierarchy.DebugNode)) throw new CommandException("myst.debug.address.invalid", new Object[0]);
                Collection<String> children = ((DebugHierarchy.DebugNode)elem).getChildren();
                agent.func_145747_a((ITextComponent)new TextComponentTranslation("%s", new Object[]{children.toString()}));
            }
            return;
        } else if (command.equals("run")) {
            if (!(elem instanceof DebugHierarchy.DebugTaskCallback)) return;
            ((DebugHierarchy.DebugTaskCallback)elem).run(agent, setval);
            return;
        } else {
            if (!command.equals("set")) return;
            if (!(elem instanceof DebugHierarchy.DebugValueCallback)) throw new CommandException("myst.debug.address.invalid", new Object[0]);
            if (args.length <= 2) {
                throw new WrongUsageException("Could not parse command.", new Object[0]);
            }
            ((DebugHierarchy.DebugValueCallback)elem).set(agent, setval);
        }
    }
}

