/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.config;

import java.io.File;
import net.minecraftforge.common.config.Configuration;

public class MystConfig
extends Configuration {
    public static final String CATEGORY_TEXTURE = "texture";
    public static final String CATEGORY_ENTITY = "entity";
    public static final String CATEGORY_DEBUG = "debug";
    public static final String CATEGORY_SYMBOLS = "symbol";
    public static final String CATEGORY_INSTABILITY = "instability";
    public static final String CATEGORY_FLUIDS = "fluids";
    public static final String CATEGORY_RENDER = "render";
    public static final String CATEGORY_CLIENT = "client";
    public static final String CATEGORY_SERVER = "server";
    public static final String CATEGORY_BASELINING = "baselining";
    private boolean allowoptional = true;

    public MystConfig(File configfile) {
        super(configfile);
    }

    public void setAllowOptional(boolean b) {
        this.allowoptional = b;
    }

    public int getOptional(String category, String key, int val) {
        if (this.allowoptional) {
            String read = this.get(category, key, "").getString();
            if (read == null || read.length() == 0) {
                return val;
            }
            try {
                return Integer.parseInt(read);
            }
            catch (NumberFormatException numberFormatException) {
                return val;
            }
        }
        return this.get(category, key, val).getInt();
    }

    public float getOptional(String category, String key, float val) {
        if (this.allowoptional) {
            String read = this.get(category, key, "").getString();
            if (read == null || read.length() == 0) {
                return val;
            }
            try {
                return Float.parseFloat(read);
            }
            catch (NumberFormatException numberFormatException) {
                return val;
            }
        }
        return (float)this.get(category, key, val).getDouble();
    }

    public boolean getOptional(String category, String key, boolean val) {
        if (this.allowoptional) {
            String read = this.get(category, key, "").getString();
            if (read == null || read.length() == 0) {
                return val;
            }
            try {
                return Boolean.parseBoolean(read);
            }
            catch (NumberFormatException e) {
                return val;
            }
        }
        return this.get(category, key, val).getBoolean();
    }
}

