/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.imc;

import com.xcompwiz.mystcraft.explosion.effects.ExplosionEffectPlaceOres;
import com.xcompwiz.mystcraft.imc.IMCHandler;
import com.xcompwiz.mystcraft.logging.LoggerUtils;
import com.xcompwiz.mystcraft.nbt.NBTUtils;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.ItemBlock;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.event.FMLInterModComms;

public class IMCMeteorBlock
implements IMCHandler.IMCProcessor {
    @Override
    public void process(FMLInterModComms.IMCMessage message) {
        if (!message.isNBTMessage()) {
            throw new RuntimeException("Message type must be NBT");
        }
        NBTTagCompound nbt = message.getNBTValue();
        Block block = null;
        int metadata = 0;
        if (nbt.func_74764_b("ItemStack")) {
            ItemStack itemstack = new ItemStack(nbt.func_74775_l("ItemStack"));
            if (!(itemstack.func_77973_b() instanceof ItemBlock)) {
                throw new RuntimeException("Itemstacks references used for adding meteor ores must extend ItemBlock");
            }
            block = ((ItemBlock)itemstack.func_77973_b()).func_179223_d();
            metadata = itemstack.func_77952_i();
        }
        if (nbt.func_74764_b("BlockName")) {
            String blockname = nbt.func_74779_i("BlockName");
            block = (Block)Block.field_149771_c.func_82594_a((Object)new ResourceLocation(message.getSender(), blockname));
            if (block == null || block == Blocks.field_150350_a) {
                LoggerUtils.error("Could not find block by name %s belonging to mod [%s] when adding meteor ores via IMC message.", blockname, message.getSender());
                return;
            }
        }
        if (block == null) {
            LoggerUtils.error("No block specified when adding meteor ores via IMC message from mod [%s].", message.getSender());
            return;
        }
        if (nbt.func_74764_b("Metadata")) {
            metadata = NBTUtils.readNumber(nbt.func_74781_a("Metadata")).intValue();
        }
        ExplosionEffectPlaceOres.registerMeteorPlaceableBlock(block.func_176203_a(metadata), nbt.func_74760_g("Weight"));
    }
}

