/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.instability.decay;

import com.xcompwiz.mystcraft.data.ModBlocks;
import com.xcompwiz.mystcraft.entity.EntityFallingBlock;
import com.xcompwiz.mystcraft.instability.decay.DecayHandler;
import com.xcompwiz.mystcraft.world.WorldInfoUtils;
import java.util.Random;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;

public class DecayHandlerBlack
extends DecayHandler {
    @Override
    public String getIdentifier() {
        return "black";
    }

    @Override
    public void pulse(World world, BlockPos pos, Random random) {
        if (world.field_73012_v.nextInt(10) == 0) {
            this.decay(world, pos);
        } else if (world.field_73012_v.nextInt(5) == 0) {
            this.corrupt(world, pos.func_177976_e());
            this.corrupt(world, pos.func_177974_f());
            this.corrupt(world, pos.func_177978_c());
            this.corrupt(world, pos.func_177968_d());
        }
    }

    @Override
    public void onBlockAdded(World world, BlockPos pos) {
        if (!world.field_72995_K && world.func_180495_p(pos).func_177230_c() == ModBlocks.decay) {
            if (!WorldInfoUtils.isMystcraftAge(world)) {
                world.func_175698_g(pos);
                return;
            }
            if (!WorldInfoUtils.isInstabilityEnabled(world)) {
                return;
            }
            if (world.func_180495_p(pos.func_177977_b()) == this.getBlockState()) {
                world.func_175698_g(pos);
                EntityFallingBlock.drop(world, pos);
                return;
            }
            if (world.func_180495_p(pos.func_177984_a()) == this.getBlockState()) {
                world.func_175698_g(pos);
                EntityFallingBlock.drop(world, pos.func_177984_a());
            }
        }
    }

    private void decay(World world, BlockPos pos) {
        this.corrupt(world, pos.func_177976_e());
        this.corrupt(world, pos.func_177974_f());
        this.corrupt(world, pos.func_177978_c());
        this.corrupt(world, pos.func_177968_d());
        world.func_175698_g(pos.func_177977_b());
        EntityFallingBlock.drop(world, pos);
    }

    private void corrupt(World world, BlockPos pos) {
        if (world.func_180495_p(pos).func_185904_a().func_76224_d()) {
            world.func_175698_g(pos);
        }
        if (!world.func_175623_d(pos)) {
            world.func_180501_a(pos, this.getBlockState(), 3);
            this.addInstability(world, 1);
        }
    }
}

