/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.network.packet;

import com.xcompwiz.mystcraft.api.util.Color;
import com.xcompwiz.mystcraft.entity.EntityLightningBoltAdv;
import com.xcompwiz.mystcraft.network.packet.PacketBase;
import io.netty.buffer.ByteBuf;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MPacketSpawnLightningBolt
extends PacketBase<MPacketSpawnLightningBolt, MPacketSpawnLightningBolt> {
    private int entityId;
    private double x;
    private double y;
    private double z;
    private boolean colored;
    private float r;
    private float g;
    private float b;

    public MPacketSpawnLightningBolt() {
    }

    public MPacketSpawnLightningBolt(EntityLightningBoltAdv adv) {
        this.entityId = adv.func_145782_y();
        this.x = adv.field_70165_t;
        this.y = adv.field_70163_u;
        this.z = adv.field_70161_v;
        Color c = adv.getColor();
        if (c != null) {
            this.colored = true;
            this.r = c.r;
            this.g = c.g;
            this.b = c.b;
        } else {
            this.colored = false;
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.entityId = buf.readInt();
        this.x = buf.readDouble();
        this.y = buf.readDouble();
        this.z = buf.readDouble();
        this.colored = buf.readBoolean();
        if (this.colored) {
            this.r = buf.readFloat();
            this.g = buf.readFloat();
            this.b = buf.readFloat();
        }
    }

    public void toBytes(ByteBuf buf) {
        buf.writeInt(this.entityId);
        buf.writeDouble(this.x);
        buf.writeDouble(this.y);
        buf.writeDouble(this.z);
        buf.writeBoolean(this.colored);
        if (this.colored) {
            buf.writeFloat(this.r);
            buf.writeFloat(this.g);
            buf.writeFloat(this.b);
        }
    }

    public MPacketSpawnLightningBolt onMessage(MPacketSpawnLightningBolt message, MessageContext ctx) {
        this.playLightningBolt(message);
        return null;
    }

    @SideOnly(value=Side.CLIENT)
    private void playLightningBolt(MPacketSpawnLightningBolt p) {
        EntityLightningBoltAdv entity = new EntityLightningBoltAdv((World)Minecraft.func_71410_x().field_71441_e, p.x, p.y, p.z, false);
        entity.func_145769_d(this.entityId);
        if (p.colored) {
            entity.setColor(new Color(p.r, p.g, p.b));
        }
        Minecraft.func_71410_x().field_71441_e.func_72942_c((Entity)entity);
    }
}

