/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.symbol.symbols;

import com.xcompwiz.mystcraft.api.world.AgeDirector;
import com.xcompwiz.mystcraft.symbol.SymbolBase;
import com.xcompwiz.mystcraft.symbol.WeatherControllerToggleable;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class SymbolWeatherStorm
extends SymbolBase {
    public SymbolWeatherStorm(ResourceLocation identifier) {
        super(identifier);
    }

    @Override
    public void registerLogic(AgeDirector controller, long seed) {
        controller.registerInterface(new WeatherController());
    }

    @Override
    public boolean generatesConfigOption() {
        return true;
    }

    private static class WeatherController
    extends WeatherControllerToggleable {
        private Random random = new Random();
        private int updateLCG = this.random.nextInt();

        private WeatherController() {
        }

        @Override
        protected void onEnable() {
            this.rainingStrength = 1.0;
            this.thunderingStrength = 1.0;
            this.rainEnabled = true;
            this.snowEnabled = false;
        }

        @Override
        protected void onDisable() {
            this.rainingStrength = 0.0;
            this.thunderingStrength = 0.0;
        }

        @Override
        public void tick(World worldObj, Chunk chunk) {
            if (worldObj.func_72896_J() && worldObj.func_72911_I() && worldObj.field_73012_v.nextInt(100000) == 0) {
                int xBase = chunk.field_76635_g * 16;
                int zBase = chunk.field_76647_h * 16;
                this.updateLCG = this.updateLCG * 3 + 1013904223;
                int coords = this.updateLCG >> 2;
                int x = xBase + (coords & 0xF);
                int z = zBase + (coords >> 8 & 0xF);
                BlockPos precip = worldObj.func_175725_q(new BlockPos(x, 0, z));
                if (this.canLightningStrikeAt(worldObj, precip)) {
                    worldObj.func_72942_c((Entity)new EntityLightningBolt(worldObj, (double)precip.func_177958_n(), (double)precip.func_177956_o(), (double)precip.func_177952_p(), false));
                }
            }
        }

        @Override
        public float getTemperature(float current, ResourceLocation biomeId) {
            if (current < 0.2f) {
                return 0.2f;
            }
            return current;
        }

        public boolean canLightningStrikeAt(World worldObj, BlockPos pos) {
            if (!worldObj.func_72896_J()) {
                return false;
            }
            if (!worldObj.func_175678_i(pos)) {
                return false;
            }
            return worldObj.func_175725_q(pos).func_177956_o() <= pos.func_177956_o();
        }
    }
}

