/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world;

import com.xcompwiz.mystcraft.world.WorldProviderMyst;
import com.xcompwiz.mystcraft.world.biome.BiomeWrapperMyst;
import java.util.HashMap;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.chunk.Chunk;

public class BiomeWrapperManager {
    private WorldProviderMyst provider;
    private HashMap<ResourceLocation, BiomeWrapperMyst> biomes = new HashMap();

    public BiomeWrapperManager(WorldProviderMyst provider) {
        this.provider = provider;
    }

    public Biome getWrapper(BlockPos pos) {
        Biome biome = this.getBiomeForWorldCoords(pos);
        return this.getBiomeWrapperForBiome(biome);
    }

    private synchronized BiomeWrapperMyst getBiomeWrapperForBiome(Biome biome) {
        ResourceLocation biomeID = biome.getRegistryName();
        BiomeWrapperMyst wrapper = this.biomes.get(biomeID);
        if (wrapper == null) {
            wrapper = new BiomeWrapperMyst(this.provider, biome);
            this.biomes.put(biomeID, wrapper);
        }
        return wrapper;
    }

    private Biome getBiomeForWorldCoords(BlockPos pos) {
        if (this.provider.getWorld().func_175667_e(pos)) {
            Chunk chunk = this.provider.getWorld().func_175726_f(pos);
            return chunk.func_177411_a(pos, this.provider.func_177499_m());
        }
        return this.provider.func_177499_m().func_180631_a(pos);
    }
}

