/*
 * Decompiled with CFR 0.152.
 */
package com.xcompwiz.mystcraft.world.profiling;

import com.xcompwiz.mystcraft.MystcraftFirstRun;
import com.xcompwiz.mystcraft.world.profiling.IMystcraftProfilingCallback;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiOptionButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.resources.I18n;

public class GuiMystcraftProfiling
extends GuiScreen
implements IMystcraftProfilingCallback {
    private GuiScreen parentscreen;
    private final List<String> message;
    private String buttonText;
    private int valTotal;
    private int valQueued;
    private int valComplete;
    private int borderColor = -6250336;
    private int backgroundColor = -16777216;
    private int fillColor = -11473328;
    private int fillColor2 = -8336192;
    private boolean finished = false;

    public GuiMystcraftProfiling(GuiScreen parentscreen) {
        this.parentscreen = parentscreen;
        ArrayList<String> messages = new ArrayList<String>();
        messages.add("Mystcraft is setting up. It requires a profile be made of the mods in use.");
        messages.add("The profiling runs once each time you add and/or remove mods.");
        messages.add("The process must complete before you can play a single-player game.");
        messages.add("Sorry for the wait!");
        messages.add("");
        messages.add("This can be run in the background without affecting the profile.");
        messages.add("You can still join a multiplayer game.");
        this.message = messages;
        this.buttonText = I18n.func_135052_a((String)"gui.toMenu", (Object[])new Object[0]);
    }

    public boolean func_73868_f() {
        return false;
    }

    public void func_73866_w_() {
        this.field_146292_n.add(new GuiOptionButton(0, this.field_146294_l / 2 - 70, this.field_146295_m / 6 + 96, this.buttonText));
    }

    public void func_73863_a(int par1, int par2, float par3) {
        if (this.finished) {
            MystcraftFirstRun.end();
            if (Minecraft.func_71410_x().field_71462_r == this) {
                Minecraft.func_71410_x().func_147108_a(this.parentscreen);
            }
            return;
        }
        super.func_73863_a(par1, par2, par3);
        int y = 20;
        for (String msg : this.message) {
            this.func_73732_a(this.field_146289_q, msg, this.field_146294_l / 2, y, 0xFFFFFF);
            y += 10;
        }
        y += 10;
        float filled = (float)this.valComplete / (float)this.valTotal;
        float underfilled = (float)(this.valComplete + this.valQueued) / (float)this.valTotal;
        int xSize = this.field_146294_l / 2;
        int ySize = 20;
        int guiLeft = this.field_146294_l / 2 - xSize / 2;
        int guiTop = y;
        int fill1 = (int)((float)(xSize - 1) * filled);
        int fill2 = (int)((float)(xSize - 1) * underfilled);
        GuiMystcraftProfiling.func_73734_a((int)guiLeft, (int)guiTop, (int)(guiLeft + xSize), (int)(guiTop + ySize), (int)this.borderColor);
        GuiMystcraftProfiling.func_73734_a((int)(guiLeft + 1), (int)(guiTop + 1), (int)(guiLeft + xSize - 1), (int)(guiTop + ySize - 1), (int)this.backgroundColor);
        GuiMystcraftProfiling.func_73734_a((int)(guiLeft + 1), (int)(guiTop + 1), (int)(guiLeft + fill2), (int)(guiTop + ySize - 1), (int)this.fillColor2);
        GuiMystcraftProfiling.func_73734_a((int)(guiLeft + 1), (int)(guiTop + 1), (int)(guiLeft + fill1), (int)(guiTop + ySize - 1), (int)this.fillColor);
    }

    protected void func_146284_a(GuiButton button) {
        if (button.field_146127_k == 0) {
            Minecraft.func_71410_x().func_147108_a(this.parentscreen);
        }
    }

    @Override
    public void setCompleted(int count) {
        this.valComplete = count;
    }

    @Override
    public void setRemaining(int remaining) {
        this.valTotal = this.valComplete + remaining;
    }

    @Override
    public void setQueued(int queued) {
        this.valQueued = queued;
    }

    @Override
    public void onFinished() {
        this.finished = true;
    }
}

