/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.client.guide.parts.recipe;

import buildcraft.lib.client.guide.parts.GuidePartFactory;
import buildcraft.lib.client.guide.parts.recipe.GuideCraftingFactory;
import buildcraft.lib.client.guide.parts.recipe.IStackRecipes;
import buildcraft.lib.misc.ItemStackKey;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.recipe.ChangingItemStack;
import buildcraft.lib.recipe.IRecipeViewable;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.IdentityHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.IRecipe;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.util.NonNullList;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.oredict.OreDictionary;

public enum GuideCraftingRecipes implements IStackRecipes
{
    INSTANCE;

    private static final boolean USE_INDEX = true;
    private Map<Item, Set<IRecipe>> inputIndexMap;
    private Map<Item, Set<IRecipe>> outputIndexMap;

    @Override
    public List<GuidePartFactory> getUsages(@Nonnull ItemStack target) {
        this.generateInputIndex();
        Iterable recipes = this.inputIndexMap.get(target.func_77973_b());
        if (recipes == null) {
            return ImmutableList.of();
        }
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IRecipe recipe : recipes) {
            GuidePartFactory factory;
            if (!GuideCraftingRecipes.checkRecipeUses(recipe, target) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
            list.add(factory);
        }
        return list;
    }

    public void generateIndices() {
        this.generateInputIndex();
        this.generateOutputIndex();
    }

    private void generateInputIndex() {
        if (this.inputIndexMap == null) {
            this.inputIndexMap = new IdentityHashMap<Item, Set<IRecipe>>();
            for (IRecipe recipe : ForgeRegistries.RECIPES) {
                this.generateInputIndex0(recipe);
            }
        }
    }

    private void generateInputIndex0(IRecipe recipe) {
        for (Ingredient ing : recipe.func_192400_c()) {
            GuideCraftingRecipes.generateIngredientIndex(recipe, ing, this.inputIndexMap);
        }
    }

    private static void generateIngredientIndex(IRecipe recipe, Ingredient ing, Map<Item, Set<IRecipe>> indexMap) {
        for (ItemStack stack : ing.func_193365_a()) {
            GuideCraftingRecipes.appendIndex(stack, recipe, indexMap);
        }
    }

    private static void appendIndex(ItemStack stack, IRecipe recipe, Map<Item, Set<IRecipe>> indexMap) {
        Set<IRecipe> list = indexMap.get(stack.func_77973_b());
        if (list == null) {
            list = new LinkedHashSet<IRecipe>();
            indexMap.put(stack.func_77973_b(), list);
        }
        list.add(recipe);
    }

    private static boolean checkRecipeUses(IRecipe recipe, @Nonnull ItemStack target) {
        NonNullList ingrediants = recipe.func_192400_c();
        if (!ingrediants.isEmpty() || recipe instanceof IRecipeViewable) {
            // empty if block
        }
        for (Ingredient ing : ingrediants) {
            if (!ing.test((Object)target)) continue;
            return true;
        }
        return false;
    }

    private static boolean matches(@Nonnull ItemStack target, @Nullable Object in) {
        if (in instanceof ItemStack) {
            return StackUtil.doesEitherStackMatch((ItemStack)in, target);
        }
        if (in instanceof List) {
            for (Object obj : (List)in) {
                if (!(obj instanceof ItemStack) || !StackUtil.doesEitherStackMatch((ItemStack)obj, target)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public List<GuidePartFactory> getRecipes(@Nonnull ItemStack target) {
        this.generateOutputIndex();
        Iterable recipes = this.outputIndexMap.get(target.func_77973_b());
        if (recipes == null) {
            return ImmutableList.of();
        }
        ArrayList<GuidePartFactory> list = new ArrayList<GuidePartFactory>();
        for (IRecipe recipe : recipes) {
            GuidePartFactory factory;
            if (!GuideCraftingRecipes.checkRecipeOutputs(recipe, target) || (factory = GuideCraftingFactory.getFactory(recipe)) == null) continue;
            list.add(factory);
        }
        return list;
    }

    private void generateOutputIndex() {
        if (this.outputIndexMap == null) {
            this.outputIndexMap = new IdentityHashMap<Item, Set<IRecipe>>();
            for (IRecipe recipe : ForgeRegistries.RECIPES) {
                this.generateOutputIndex0(recipe);
            }
        }
    }

    private void generateOutputIndex0(IRecipe recipe) {
        if (recipe instanceof IRecipeViewable) {
            ChangingItemStack changing = ((IRecipeViewable)recipe).getRecipeOutputs();
            for (ItemStackKey stack : changing.getOptions()) {
                GuideCraftingRecipes.appendIndex(stack.baseStack, recipe, this.outputIndexMap);
            }
        } else {
            ItemStack output = recipe.func_77571_b();
            if (!output.func_190926_b()) {
                GuideCraftingRecipes.appendIndex(output, recipe, this.outputIndexMap);
            }
        }
        for (Ingredient ing : recipe.func_192400_c()) {
            GuideCraftingRecipes.generateIngredientIndex(recipe, ing, this.outputIndexMap);
        }
    }

    private static boolean checkRecipeOutputs(IRecipe recipe, ItemStack target) {
        ItemStack out;
        ChangingItemStack changing;
        return recipe instanceof IRecipeViewable ? (changing = ((IRecipeViewable)recipe).getRecipeOutputs()).matches(target) : OreDictionary.itemMatches((ItemStack)target, (ItemStack)(out = StackUtil.asNonNull(recipe.func_77571_b())), (boolean)false) || OreDictionary.itemMatches((ItemStack)out, (ItemStack)target, (boolean)false);
    }
}

