/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.net.cache;

import buildcraft.api.core.BCLog;
import buildcraft.lib.net.cache.NetworkedFluidStackCache;
import buildcraft.lib.net.cache.NetworkedItemStackCache;
import buildcraft.lib.net.cache.NetworkedObjectCache;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.LoaderState;

public class BuildCraftObjectCaches {
    public static final NetworkedItemStackCache CACHE_ITEMS = new NetworkedItemStackCache();
    public static final NetworkedFluidStackCache CACHE_FLUIDS = new NetworkedFluidStackCache();
    static final List<NetworkedObjectCache<?>> CACHES = new ArrayList();

    public static void registerCache(NetworkedObjectCache<?> cache) {
        if (Loader.instance().hasReachedState(LoaderState.POSTINITIALIZATION)) {
            throw new IllegalStateException("May only construct a cache BEFORE post-init!");
        }
        CACHES.add(cache);
    }

    public static int storeItemStack(@Nonnull ItemStack stack) {
        return CACHE_ITEMS.server().store(stack);
    }

    public static int getItemStackId(@Nonnull ItemStack stack) {
        return CACHE_ITEMS.server().getId(stack);
    }

    public static Supplier<ItemStack> retrieveItemStack(int id) {
        return CACHE_ITEMS.client().retrieve(id);
    }

    public static void fmlPreInit() {
        BuildCraftObjectCaches.registerCache(CACHE_ITEMS);
        BuildCraftObjectCaches.registerCache(CACHE_FLUIDS);
    }

    public static void fmlPostInit() {
        CACHES.sort(Comparator.comparing(a -> a.getClass().getSimpleName()));
        if (NetworkedObjectCache.DEBUG_LOG) {
            BCLog.logger.info("[lib.net.cache] Sorted list of networked object caches:");
            for (int i = 0; i < CACHES.size(); ++i) {
                NetworkedObjectCache<?> cache = CACHES.get(i);
                BCLog.logger.info("  " + i + " = " + cache.getCacheName());
            }
            BCLog.logger.info("[lib.net.cache] Total of " + CACHES.size() + " caches");
        }
    }

    public static void onClientTick() {
        for (NetworkedObjectCache<?> cache : CACHES) {
            cache.onClientWorldTick();
        }
    }

    public static void onClientJoinServer() {
        for (NetworkedObjectCache<?> cache : CACHES) {
            cache.onClientJoinServer();
        }
    }
}

