/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.BlockItemHolder;
import com.flansmod.common.FlansMod;
import com.flansmod.common.IFlansModContentProvider;
import com.flansmod.common.ItemHolderType;
import com.flansmod.common.driveables.ItemPlane;
import com.flansmod.common.driveables.ItemVehicle;
import com.flansmod.common.driveables.PlaneType;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.driveables.mechas.ItemMecha;
import com.flansmod.common.driveables.mechas.ItemMechaAddon;
import com.flansmod.common.driveables.mechas.MechaItemType;
import com.flansmod.common.driveables.mechas.MechaType;
import com.flansmod.common.enchantments.GloveType;
import com.flansmod.common.enchantments.ItemGlove;
import com.flansmod.common.guns.AAGunType;
import com.flansmod.common.guns.AttachmentType;
import com.flansmod.common.guns.BulletType;
import com.flansmod.common.guns.GrenadeType;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemAAGun;
import com.flansmod.common.guns.ItemAttachment;
import com.flansmod.common.guns.ItemBullet;
import com.flansmod.common.guns.ItemGrenade;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.boxes.BlockGunBox;
import com.flansmod.common.guns.boxes.GunBoxType;
import com.flansmod.common.parts.ItemPart;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.teams.ArmourBoxType;
import com.flansmod.common.teams.ArmourType;
import com.flansmod.common.teams.BlockArmourBox;
import com.flansmod.common.teams.ItemRewardBox;
import com.flansmod.common.teams.ItemTeamArmour;
import com.flansmod.common.teams.RewardBox;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.tools.ToolType;
import com.flansmod.common.types.EnumType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import java.util.zip.ZipInputStream;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.versioning.ArtifactVersion;
import org.apache.commons.io.FileUtils;

public class ContentManager {
    private HashMap<String, IFlansModContentProvider> packs = new HashMap();
    protected Pattern zipJar = Pattern.compile("(.+)\\.(zip|jar)$");
    private boolean wasAnythingInFlanFolder = false;

    public boolean LoadedAnyContentFromFlanFolder() {
        return this.wasAnythingInFlanFolder;
    }

    public void FindContentInFlanFolder() {
        for (File file : FlansMod.flanDir.listFiles()) {
            if (!file.isDirectory() && !this.zipJar.matcher(file.getName()).matches()) continue;
            if (this.packs.containsKey(file.getName())) {
                FlansMod.log.info("Skipping loading content pack from Flan folder as it is duplicated: " + file.getName());
                continue;
            }
            FlansMod.log.info("Loaded content pack from Flan folder : " + file.getName());
            this.packs.put(file.getName(), new ContentPackFlanFolder(file.getName(), file));
            this.wasAnythingInFlanFolder = true;
        }
        FlansMod.log.info("Loaded content pack list from Flan folder");
    }

    public void LoadAssetsFromFlanFolder() {
        FlansMod.proxy.LoadAssetsFromFlanFolder();
    }

    public void RegisterModelRedirects() {
        for (IFlansModContentProvider provider : this.packs.values()) {
            provider.RegisterModelRedirects();
        }
    }

    public void FindContentInModsFolder() {
        for (ModContainer container : Loader.instance().getActiveModList()) {
            for (ArtifactVersion requirement : container.getRequirements()) {
                if (!requirement.getLabel().equals("flansmod")) continue;
                if (container.getMod() instanceof IFlansModContentProvider) {
                    IFlansModContentProvider mod = (IFlansModContentProvider)container.getMod();
                    String folder = mod.GetContentFolder();
                    File source = container.getSource();
                    if (source.getName().endsWith("bin")) {
                        FlansMod.log.info("Found .java content pack" + source.getName() + " We must be in MCP. Loading from folder using IFlansModContentProvider");
                        this.packs.put(folder, new ContentPackMod(container, mod));
                        continue;
                    }
                    if (!this.zipJar.matcher(source.getName()).matches()) continue;
                    FlansMod.log.info("Found .jar content pack " + source.getName() + " in mods folder. Loading from jar");
                    this.packs.put(folder, new ContentPackMod(container, mod));
                    continue;
                }
                FlansMod.log.error("Found Flan's Mod content pack on the classpath which did not implement IFlansModContentProvider");
            }
        }
    }

    private void LoadTypesFromDirectory(String contentPackName, File contentPack) {
        for (EnumType typeToCheckFor : EnumType.values()) {
            File typesDir = new File(contentPack, "/" + typeToCheckFor.folderName + "/");
            if (!typesDir.exists()) continue;
            for (File file : FileUtils.listFiles((File)typesDir, (String[])new String[]{"txt"}, (boolean)true)) {
                if (file.isDirectory()) continue;
                try {
                    BufferedReader reader = new BufferedReader(new FileReader(file));
                    String[] splitName = file.getName().split("/");
                    TypeFile typeFile = new TypeFile(contentPackName, typeToCheckFor, splitName[splitName.length - 1].split("\\.")[0]);
                    while (true) {
                        String line = null;
                        try {
                            line = reader.readLine();
                        }
                        catch (Exception e) {
                            break;
                        }
                        if (line == null) break;
                        typeFile.parseLine(line);
                    }
                    reader.close();
                }
                catch (IOException e) {
                    FlansMod.log.throwing((Throwable)e);
                }
            }
        }
    }

    private void LoadTypesFromArchive(String contentPackName, File contentPack) {
        try {
            ZipFile zip = new ZipFile(contentPack);
            ZipInputStream zipStream = new ZipInputStream(new FileInputStream(contentPack));
            BufferedReader reader = new BufferedReader(new InputStreamReader(zipStream));
            ZipEntry zipEntry = zipStream.getNextEntry();
            block4: do {
                if ((zipEntry = zipStream.getNextEntry()) == null || zipEntry.isDirectory()) continue;
                TypeFile typeFile = null;
                for (EnumType type : EnumType.values()) {
                    if (!zipEntry.getName().startsWith(type.folderName + "/") || zipEntry.getName().split(type.folderName + "/").length <= 1 || zipEntry.getName().split(type.folderName + "/")[1].length() <= 0) continue;
                    String[] splitName = zipEntry.getName().split("/");
                    typeFile = new TypeFile(zip.getName(), type, splitName[splitName.length - 1].split("\\.")[0]);
                }
                if (typeFile == null) continue;
                while (true) {
                    String line = null;
                    try {
                        line = reader.readLine();
                    }
                    catch (Exception e) {
                        continue block4;
                    }
                    if (line == null) continue block4;
                    typeFile.parseLine(line);
                }
            } while (zipEntry != null);
            reader.close();
            zip.close();
            zipStream.close();
        }
        catch (IOException e) {
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public void LoadTypes() {
        for (Map.Entry<String, IFlansModContentProvider> entry : this.packs.entrySet()) {
            String contentPackName = entry.getKey();
            IFlansModContentProvider provider = entry.getValue();
            if (provider instanceof ContentPackFlanFolder) {
                ContentPackFlanFolder contentPack = (ContentPackFlanFolder)provider;
                if (contentPack.folder.isDirectory()) {
                    this.LoadTypesFromDirectory(contentPackName, contentPack.folder);
                    continue;
                }
                this.LoadTypesFromArchive(contentPackName, contentPack.folder);
                continue;
            }
            if (!(provider instanceof ContentPackMod)) continue;
            ContentPackMod mod = (ContentPackMod)provider;
            if (mod.container.getSource().getName().endsWith("bin")) {
                this.LoadTypesFromDirectory(contentPackName, new File(FlansMod.flanDir + "/" + contentPackName));
                continue;
            }
            if (!this.zipJar.matcher(mod.container.getSource().getName()).matches()) continue;
            this.LoadTypesFromArchive(contentPackName, mod.container.getSource());
        }
    }

    public void CreateItems() {
        for (EnumType type : EnumType.values()) {
            Class<? extends InfoType> typeClass = type.getTypeClass();
            for (TypeFile typeFile : TypeFile.files.get((Object)type)) {
                try {
                    InfoType infoType = typeClass.getConstructor(TypeFile.class).newInstance(typeFile);
                    infoType.read(typeFile);
                    switch (type) {
                        case bullet: {
                            new ItemBullet((BulletType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case attachment: {
                            new ItemAttachment((AttachmentType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case gun: {
                            new ItemGun((GunType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case grenade: {
                            new ItemGrenade((GrenadeType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case part: {
                            FlansMod.partItems.add((ItemPart)new ItemPart((PartType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case plane: {
                            new ItemPlane((PlaneType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case vehicle: {
                            new ItemVehicle((VehicleType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case aa: {
                            new ItemAAGun((AAGunType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case mechaItem: {
                            new ItemMechaAddon((MechaItemType)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case mecha: {
                            FlansMod.mechaItems.add((ItemMecha)new ItemMecha((MechaType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case tool: {
                            FlansMod.toolItems.add((ItemTool)new ItemTool((ToolType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case box: {
                            new BlockGunBox((GunBoxType)infoType).func_149663_c(infoType.shortName);
                            break;
                        }
                        case armour: {
                            FlansMod.armourItems.add((ItemTeamArmour)new ItemTeamArmour((ArmourType)infoType).func_77655_b(infoType.shortName));
                            break;
                        }
                        case armourBox: {
                            new BlockArmourBox((ArmourBoxType)infoType).func_149663_c(infoType.shortName);
                            break;
                        }
                        case playerClass: {
                            break;
                        }
                        case team: {
                            break;
                        }
                        case itemHolder: {
                            new BlockItemHolder((ItemHolderType)infoType);
                            break;
                        }
                        case rewardBox: {
                            new ItemRewardBox((RewardBox)infoType).func_77655_b(infoType.shortName);
                            break;
                        }
                        case loadout: {
                            break;
                        }
                        case glove: {
                            new ItemGlove((GloveType)infoType);
                            break;
                        }
                        default: {
                            FlansMod.log.warn("Unrecognised type for " + infoType.shortName);
                            break;
                        }
                    }
                }
                catch (Exception e) {
                    FlansMod.log.error("Failed to add " + type.name() + " : " + typeFile.name);
                    FlansMod.log.throwing((Throwable)e);
                }
            }
            FlansMod.log.info("Loaded " + type.name() + ".");
        }
    }

    public List<File> GetFolderContentPacks() {
        ArrayList<File> result = new ArrayList<File>();
        for (Map.Entry<String, IFlansModContentProvider> entry : this.packs.entrySet()) {
            String contentPackName = entry.getKey();
            IFlansModContentProvider provider = entry.getValue();
            if (provider instanceof ContentPackFlanFolder) {
                ContentPackFlanFolder contentPack = (ContentPackFlanFolder)provider;
                if (!contentPack.folder.isDirectory()) continue;
                result.add(contentPack.folder);
                continue;
            }
            if (!(provider instanceof ContentPackMod)) continue;
            ContentPackMod mod = (ContentPackMod)provider;
            if (!mod.container.getSource().getName().endsWith("bin")) continue;
            result.add(new File(FlansMod.flanDir + "/" + contentPackName));
        }
        return result;
    }

    public class ContentPackFlanFolder
    implements IFlansModContentProvider {
        public String name;
        public File folder;

        public ContentPackFlanFolder(String n, File f) {
            this.folder = f;
            this.name = n;
        }

        @Override
        public String GetContentFolder() {
            return this.name;
        }

        @Override
        public void RegisterModelRedirects() {
            try {
                if (this.folder.isDirectory()) {
                    File redirectInfo = new File(this.folder, "/redirect.info");
                    if (redirectInfo.exists()) {
                        BufferedReader reader = new BufferedReader(new FileReader(redirectInfo));
                        String src = reader.readLine();
                        String dst = reader.readLine();
                        if (src != null && dst != null) {
                            FlansMod.log.info("Registered Flan folder model redirect from " + src + " to " + dst);
                            FlansMod.RegisterModelRedirect(src, dst);
                        }
                        reader.close();
                    }
                } else if (ContentManager.this.zipJar.matcher(this.folder.getName()).matches()) {
                    ZipFile zip = new ZipFile(this.folder);
                    ZipEntry entry = zip.getEntry("redirect.info");
                    if (entry != null && !entry.isDirectory()) {
                        BufferedReader reader = new BufferedReader(new InputStreamReader(zip.getInputStream(entry)));
                        String src = reader.readLine();
                        String dst = reader.readLine();
                        if (src != null && dst != null) {
                            FlansMod.log.info("Registered Flan folder model redirect from " + src + " to " + dst);
                            FlansMod.RegisterModelRedirect(src, dst);
                        }
                        reader.close();
                    }
                    zip.close();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public class ContentPackMod
    implements IFlansModContentProvider {
        public IFlansModContentProvider provider;
        public ModContainer container;

        public ContentPackMod(ModContainer c, IFlansModContentProvider p) {
            this.container = c;
            this.provider = p;
        }

        @Override
        public String GetContentFolder() {
            return this.provider.GetContentFolder();
        }

        @Override
        public void RegisterModelRedirects() {
            this.provider.RegisterModelRedirects();
        }
    }
}

