/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;

public class CraftingInstance {
    public IInventory inventory;
    public List<ItemStack> requiredStacks;
    public List<ItemStack> outputStacks;
    public boolean craftingSuccessful;

    public CraftingInstance(IInventory i, List<ItemStack> in, List<ItemStack> out) {
        this.inventory = i;
        this.requiredStacks = in;
        this.outputStacks = out;
    }

    public CraftingInstance(IInventory i, ArrayList<ItemStack> in, ItemStack out) {
        this(i, in, Arrays.asList(out));
    }

    public boolean canCraft() {
        this.craftingSuccessful = true;
        for (ItemStack check : this.requiredStacks) {
            int numMatchingStuff = 0;
            for (int j = 0; j < this.inventory.func_70302_i_(); ++j) {
                ItemStack stack = this.inventory.func_70301_a(j);
                if (stack == null || stack.func_190926_b() || stack.func_77973_b() != check.func_77973_b() || stack.func_77952_i() != check.func_77952_i()) continue;
                numMatchingStuff += stack.func_190916_E();
            }
            if (numMatchingStuff >= check.func_190916_E()) continue;
            this.craftingSuccessful = false;
        }
        return this.craftingSuccessful;
    }

    public void craft(EntityPlayer player) {
        if (!this.craftingSuccessful) {
            return;
        }
        for (ItemStack remove : this.requiredStacks) {
            int amountLeft = remove.func_190916_E();
            for (int j = 0; j < this.inventory.func_70302_i_(); ++j) {
                ItemStack stack = this.inventory.func_70301_a(j);
                if (amountLeft <= 0 || stack == null || stack.func_190926_b() || stack.func_77973_b() != remove.func_77973_b() || stack.func_77952_i() != remove.func_77952_i()) continue;
                amountLeft -= this.inventory.func_70298_a(j, amountLeft).func_190916_E();
            }
        }
        for (ItemStack stack : this.outputStacks) {
            if (player.field_71071_by.func_70441_a(stack)) continue;
            player.func_71019_a(stack, false);
        }
    }
}

