/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common;

import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.guns.EntityGrenade;
import com.flansmod.common.guns.EntityMG;
import com.flansmod.common.guns.GunType;
import com.flansmod.common.guns.ItemGun;
import com.flansmod.common.guns.raytracing.PlayerSnapshot;
import com.flansmod.common.teams.IPlayerClass;
import com.flansmod.common.teams.Team;
import com.flansmod.common.vector.Vector3f;
import java.util.ArrayList;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PlayerData {
    public String username;
    public float prevRotationRoll;
    public float rotationRoll;
    public PlayerSnapshot[] snapshots;
    public EntityMG mountingGun;
    public int shootClickDelay;
    public float minigunSpeed = 0.0f;
    public ArrayList<EntityGrenade> remoteExplosives = new ArrayList();
    public int loopedSoundDelay;
    public boolean isSpinning;
    public int meleeProgress;
    public int meleeLength;
    public float shootTimeRight;
    public float shootTimeLeft;
    public boolean isShootingRight;
    public boolean isShootingLeft;
    public boolean reloadingRight;
    public boolean reloadingLeft;
    public int burstRoundsRemainingLeft = 0;
    public int burstRoundsRemainingRight = 0;
    public Vector3f[] lastMeleePositions;
    public int score;
    public int kills;
    public int deaths;
    public int zombieScore;
    public boolean out;
    public int vote;
    public Team team;
    public Team newTeam;
    public IPlayerClass playerClass;
    public IPlayerClass newPlayerClass;
    public boolean builder;
    @SideOnly(value=Side.CLIENT)
    public ResourceLocation skin;

    public float GetShootTime(EnumHand hand) {
        return hand == EnumHand.OFF_HAND ? this.shootTimeLeft : this.shootTimeRight;
    }

    public void SetShootTime(EnumHand hand, float set) {
        if (hand == EnumHand.OFF_HAND) {
            this.shootTimeLeft = set;
        } else {
            this.shootTimeRight = set;
        }
    }

    public int GetBurstRoundsRemaining(EnumHand hand) {
        return hand == EnumHand.OFF_HAND ? this.burstRoundsRemainingLeft : this.burstRoundsRemainingRight;
    }

    public void SetBurstRoundsRemaining(EnumHand hand, int set) {
        if (hand == EnumHand.OFF_HAND) {
            this.burstRoundsRemainingLeft = set;
        } else {
            this.burstRoundsRemainingRight = set;
        }
    }

    public PlayerData(String name) {
        this.username = name;
        this.snapshots = new PlayerSnapshot[20];
    }

    public void tick(EntityPlayer player) {
        if (player.field_70170_p.field_72995_K) {
            this.clientTick(player);
        }
        if (this.shootTimeRight > 0.0f) {
            this.shootTimeRight -= 1.0f;
        }
        if (this.shootTimeRight == 0.0f) {
            this.reloadingRight = false;
        }
        if (this.shootTimeLeft > 0.0f) {
            this.shootTimeLeft -= 1.0f;
        }
        if (this.shootTimeLeft == 0.0f) {
            this.reloadingLeft = false;
        }
        if (this.shootClickDelay > 0) {
            --this.shootClickDelay;
        }
        if (this.loopedSoundDelay > 0) {
            --this.loopedSoundDelay;
        }
        System.arraycopy(this.snapshots, 0, this.snapshots, 1, this.snapshots.length - 2 + 1);
        this.snapshots[0] = new PlayerSnapshot(player);
    }

    public void clientTick(EntityPlayer player) {
    }

    public IPlayerClass getPlayerClass() {
        if (this.playerClass != this.newPlayerClass) {
            this.playerClass = this.newPlayerClass;
        }
        return this.playerClass;
    }

    public void resetScore() {
        this.deaths = 0;
        this.kills = 0;
        this.zombieScore = 0;
        this.score = 0;
        this.newTeam = null;
        this.team = null;
        this.newPlayerClass = null;
        this.playerClass = null;
    }

    public void playerKilled() {
        this.mountingGun = null;
        this.isShootingLeft = false;
        this.isShootingRight = false;
        this.snapshots = new PlayerSnapshot[20];
    }

    public boolean isValidOffHandWeapon(EntityPlayer player, int slot) {
        if (slot == 0) {
            return true;
        }
        if (slot - 1 == player.field_71071_by.field_70461_c) {
            return false;
        }
        ItemStack stackInSlot = player.field_71071_by.func_70301_a(slot - 1);
        if (stackInSlot == null) {
            return false;
        }
        if (stackInSlot.func_77973_b() instanceof ItemGun) {
            ItemGun item = (ItemGun)stackInSlot.func_77973_b();
            if (item.GetType().oneHanded) {
                return true;
            }
        }
        return false;
    }

    public void doMelee(EntityPlayer player, int meleeTime, GunType type) {
        this.meleeLength = meleeTime;
        this.lastMeleePositions = new Vector3f[type.meleePath.size()];
        for (int k = 0; k < type.meleeDamagePoints.size(); ++k) {
            Vector3f meleeDamagePoint = type.meleeDamagePoints.get(k);
            Vector3f nextPos = type.meleePath.get(0);
            Vector3f nextAngles = type.meleePathAngles.get(0);
            RotatedAxes nextAxes = new RotatedAxes(-nextAngles.y, -nextAngles.z, nextAngles.x);
            Vector3f nextPosInPlayerCoords = new RotatedAxes(player.field_70177_z + 90.0f, player.field_70125_A, 0.0f).findLocalVectorGlobally(nextAxes.findLocalVectorGlobally(meleeDamagePoint));
            Vector3f.add(nextPos, nextPosInPlayerCoords, nextPosInPlayerCoords);
            if (!FlansMod.proxy.isThePlayer(player)) {
                nextPosInPlayerCoords.y += 1.6f;
            }
            this.lastMeleePositions[k] = new Vector3f(player.field_70165_t + (double)nextPosInPlayerCoords.x, player.field_70163_u + (double)nextPosInPlayerCoords.y, player.field_70161_v + (double)nextPosInPlayerCoords.z);
        }
    }

    public void WriteToFile() {
    }

    public void ReadFromFile() {
    }
}

