/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.api.IExplodeable;
import com.flansmod.client.model.AnimTankTrack;
import com.flansmod.client.model.AnimTrackLink;
import com.flansmod.common.FlansMod;
import com.flansmod.common.RotatedAxes;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntitySeat;
import com.flansmod.common.driveables.EntityWheel;
import com.flansmod.common.driveables.ShootPoint;
import com.flansmod.common.driveables.VehicleType;
import com.flansmod.common.network.PacketPlaySound;
import com.flansmod.common.network.PacketVehicleControl;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.tools.ItemTool;
import com.flansmod.common.vector.Vector3f;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumHand;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityVehicle
extends EntityDriveable
implements IExplodeable {
    public int shellDelay;
    public int gunDelay;
    public int soundPosition;
    public float wheelsYaw;
    private int ticksSinceUsed = 0;
    public boolean varDoor;
    public float wheelsAngle;
    public int toggleTimer = 0;
    public AnimTankTrack rightTrack;
    public AnimTankTrack leftTrack;
    public AnimTrackLink[] trackLinksLeft = new AnimTrackLink[0];
    public AnimTrackLink[] trackLinksRight = new AnimTrackLink[0];

    public EntityVehicle(World world) {
        super(world);
        this.field_70138_W = 1.0f;
    }

    public EntityVehicle(World world, double x, double y, double z, VehicleType type, DriveableData data) {
        super(world, type, data);
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.initType(type, true, false);
    }

    public EntityVehicle(World world, double x, double y, double z, EntityPlayer placer, VehicleType type, DriveableData data) {
        super(world, type, data);
        this.field_70138_W = 1.0f;
        this.func_70107_b(x, y, z);
        this.rotateYaw(placer.field_70177_z + 90.0f);
        this.initType(type, true, false);
    }

    public void setupTracks(DriveableType type) {
        this.rightTrack = new AnimTankTrack(type.rightTrackPoints, type.trackLinkLength);
        this.leftTrack = new AnimTankTrack(type.leftTrackPoints, type.trackLinkLength);
        int numLinks = Math.round(this.rightTrack.getTrackLength() / type.trackLinkLength);
        this.trackLinksLeft = new AnimTrackLink[numLinks];
        this.trackLinksRight = new AnimTrackLink[numLinks];
        for (int i = 0; i < numLinks; ++i) {
            float progress = 0.01f + type.trackLinkLength * (float)i;
            int trackPart = this.leftTrack.getTrackPart(progress);
            this.trackLinksLeft[i] = new AnimTrackLink(progress);
            this.trackLinksRight[i] = new AnimTrackLink(progress);
            this.trackLinksLeft[i].position = this.leftTrack.getPositionOnTrack(progress);
            this.trackLinksRight[i].position = this.rightTrack.getPositionOnTrack(progress);
            this.trackLinksLeft[i].rot = new RotatedAxes(0.0f, 0.0f, this.rotateTowards(this.leftTrack.points.get(trackPart == 0 ? this.leftTrack.points.size() - 1 : trackPart - 1), this.trackLinksLeft[i].position));
            this.trackLinksRight[i].rot = new RotatedAxes(0.0f, 0.0f, this.rotateTowards(this.rightTrack.points.get(trackPart == 0 ? this.rightTrack.points.size() - 1 : trackPart - 1), this.trackLinksRight[i].position));
            this.trackLinksLeft[i].zRot = this.rotateTowards(this.leftTrack.points.get(trackPart == 0 ? this.leftTrack.points.size() - 1 : trackPart - 1), this.trackLinksLeft[i].position);
            this.trackLinksRight[i].zRot = this.rotateTowards(this.rightTrack.points.get(trackPart == 0 ? this.rightTrack.points.size() - 1 : trackPart - 1), this.trackLinksRight[i].position);
        }
    }

    @Override
    protected void initType(DriveableType type, boolean firstSpawn, boolean clientSide) {
        this.setupTracks(type);
        super.initType(type, firstSpawn, clientSide);
    }

    @Override
    public void readSpawnData(ByteBuf data) {
        super.readSpawnData(data);
    }

    @Override
    protected void func_70014_b(NBTTagCompound tag) {
        super.func_70014_b(tag);
        tag.func_74757_a("VarDoor", this.varDoor);
    }

    @Override
    protected void func_70037_a(NBTTagCompound tag) {
        super.func_70037_a(tag);
        this.varDoor = tag.func_74767_n("VarDoor");
    }

    @Override
    public void onMouseMoved(int deltaX, int deltaY) {
    }

    @Override
    public void setPositionRotationAndMotion(double x, double y, double z, float yaw, float pitch, float roll, double motX, double motY, double motZ, float velYaw, float velPitch, float velRoll, float throttle, float steeringYaw) {
        super.setPositionRotationAndMotion(x, y, z, yaw, pitch, roll, motX, motY, motZ, velYaw, velPitch, velRoll, throttle, steeringYaw);
        this.wheelsYaw = steeringYaw;
    }

    public boolean func_184230_a(EntityPlayer entityplayer, EnumHand hand) {
        if (this.field_70128_L) {
            return false;
        }
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        ItemStack currentItem = entityplayer.func_184614_ca();
        if (currentItem.func_77973_b() instanceof ItemTool && ((ItemTool)currentItem.func_77973_b()).type.healDriveables) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        for (int i = 0; i <= type.numPassengers; ++i) {
            if (!this.getSeat(i).func_184230_a(entityplayer, hand)) continue;
            if (i == 0) {
                this.shellDelay = type.shootDelayPrimary;
                FlansMod.proxy.doTutorialStuff(entityplayer, this);
            }
            return true;
        }
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public boolean pressKey(int key, EntityPlayer player, boolean isOnEvent) {
        VehicleType type = this.getVehicleType();
        switch (key) {
            case 0: {
                this.throttle += 0.01f;
                if (this.throttle > 1.0f) {
                    this.throttle = 1.0f;
                }
                return true;
            }
            case 1: {
                this.throttle -= 0.01f;
                if (this.throttle < -1.0f) {
                    this.throttle = -1.0f;
                }
                if (this.throttle < 0.0f && type.maxNegativeThrottle == 0.0f) {
                    this.throttle = 0.0f;
                }
                return true;
            }
            case 2: {
                this.wheelsYaw -= 1.0f;
                return true;
            }
            case 3: {
                this.wheelsYaw += 1.0f;
                return true;
            }
            case 4: {
                this.throttle *= 0.8f;
                if (this.field_70122_E) {
                    this.field_70159_w *= (double)0.8f;
                    this.field_70179_y *= (double)0.8f;
                }
                return true;
            }
            case 7: {
                if (this.field_70170_p.field_72995_K) {
                    FlansMod.proxy.openDriveableMenu((EntityPlayer)this.getSeat(0).func_184179_bs(), this.field_70170_p, this);
                }
                return true;
            }
            case 14: {
                if (this.toggleTimer <= 0) {
                    boolean bl = this.varDoor = !this.varDoor;
                    if (type.hasDoor) {
                        player.func_145747_a((ITextComponent)new TextComponentString("Doors " + (this.varDoor ? "open" : "closed")));
                    }
                    this.toggleTimer = 10;
                    FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
                }
                return true;
            }
        }
        return super.pressKey(key, player, isOnEvent);
    }

    @Override
    public Vector3f getLookVector(ShootPoint shootPoint) {
        return this.rotate(this.getSeat((int)0).looking.getXAxis());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void func_70071_h_() {
        void var5_15;
        super.func_70071_h_();
        if (!this.readyForUpdates) {
            return;
        }
        VehicleType type = this.getVehicleType();
        DriveableData data = this.getDriveableData();
        if (type == null) {
            FlansMod.log.warn("Vehicle type null. Not ticking vehicle");
            return;
        }
        this.animateFancyTracks();
        boolean thePlayerIsDrivingThis = this.field_70170_p.field_72995_K && this.getSeat(0) != null && this.getSeat(0).func_184179_bs() instanceof EntityPlayer && FlansMod.proxy.isThePlayer((EntityPlayer)this.getSeat(0).func_184179_bs());
        ++this.ticksSinceUsed;
        if (!this.field_70170_p.field_72995_K && this.getSeat(0).func_184179_bs() != null) {
            this.ticksSinceUsed = 0;
        }
        if (!this.field_70170_p.field_72995_K && TeamsManager.vehicleLife > 0 && this.ticksSinceUsed > TeamsManager.vehicleLife * 20) {
            this.func_70106_y();
        }
        if (this.shellDelay > 0) {
            --this.shellDelay;
        }
        if (this.gunDelay > 0) {
            --this.gunDelay;
        }
        if (this.toggleTimer > 0) {
            --this.toggleTimer;
        }
        if (this.soundPosition > 0) {
            --this.soundPosition;
        }
        if (this.hasEnoughFuel()) {
            this.wheelsAngle += this.throttle * 0.2f;
        }
        this.wheelsYaw *= 0.9f;
        if (this.wheelsYaw > 20.0f) {
            this.wheelsYaw = 20.0f;
        }
        if (this.wheelsYaw < -20.0f) {
            this.wheelsYaw = -20.0f;
        }
        if (this.field_70170_p.field_72995_K && !thePlayerIsDrivingThis && this.serverPositionTransitionTicker > 0) {
            this.moveTowardServerPosition();
        }
        Vector3f amountToMoveCar = new Vector3f();
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null || this.field_70170_p == null) continue;
            wheel.field_70169_q = wheel.field_70165_t;
            wheel.field_70167_r = wheel.field_70163_u;
            wheel.field_70166_s = wheel.field_70161_v;
        }
        for (EntityWheel wheel : this.wheels) {
            if (wheel == null) continue;
            this.field_70122_E = true;
            wheel.field_70122_E = true;
            wheel.field_70177_z = this.axes.getYaw();
            if (!(type.tank || wheel.getExpectedWheelID() != 2 && wheel.getExpectedWheelID() != 3)) {
                wheel.field_70177_z += this.wheelsYaw;
            }
            wheel.field_70159_w *= (double)0.9f;
            wheel.field_70181_x *= (double)0.9f;
            wheel.field_70179_y *= (double)0.9f;
            wheel.field_70181_x -= 0.049000002443790436;
            EntityPlayer driver = this.getDriver();
            if (this.canThrust(data, driver)) {
                if (!this.driverIsCreative()) {
                    data.fuelInTank -= data.engine.fuelConsumption * this.throttle;
                }
                if (this.getVehicleType().tank) {
                    boolean left = wheel.getExpectedWheelID() == 0 || wheel.getExpectedWheelID() == 3;
                    float turningDrag = 0.02f;
                    wheel.field_70159_w *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    wheel.field_70179_y *= (double)(1.0f - Math.abs(this.wheelsYaw) * turningDrag);
                    float velocityScale = 0.04f * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    float steeringScale = 0.1f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier);
                    float effectiveWheelSpeed = (this.throttle + this.wheelsYaw * (float)(left ? 1 : -1) * steeringScale) * velocityScale;
                    wheel.field_70159_w += (double)effectiveWheelSpeed * Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f);
                    wheel.field_70179_y += (double)effectiveWheelSpeed * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f);
                } else {
                    float velocityScale = 0.1f * this.throttle * (this.throttle > 0.0f ? type.maxThrottle : type.maxNegativeThrottle) * data.engine.engineSpeed;
                    wheel.field_70159_w += Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    wheel.field_70179_y += Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale;
                    if (wheel.getExpectedWheelID() == 2 || wheel.getExpectedWheelID() == 3) {
                        velocityScale = 0.01f * (this.wheelsYaw > 0.0f ? type.turnLeftModifier : type.turnRightModifier) * (float)(this.throttle > 0.0f ? 1 : -1);
                        wheel.field_70159_w -= wheel.getSpeedXZ() * Math.sin(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                        wheel.field_70179_y += wheel.getSpeedXZ() * Math.cos(wheel.field_70177_z * (float)Math.PI / 180.0f) * (double)velocityScale * (double)this.wheelsYaw;
                    } else {
                        wheel.field_70159_w *= (double)0.9f;
                        wheel.field_70179_y *= (double)0.9f;
                    }
                }
            }
            if (type.floatOnWater && this.field_70170_p.func_72953_d(wheel.func_174813_aQ())) {
                wheel.field_70181_x += (double)type.buoyancy;
            }
            wheel.func_70091_d(MoverType.PLAYER, wheel.field_70159_w, wheel.field_70181_x, wheel.field_70179_y);
            Vector3f targetWheelPos = this.axes.findLocalVectorGlobally(this.getVehicleType().wheelPositions[wheel.getExpectedWheelID()].position);
            Vector3f currentWheelPos = new Vector3f(wheel.field_70165_t - this.field_70165_t, wheel.field_70163_u - this.field_70163_u, wheel.field_70161_v - this.field_70161_v);
            Vector3f dPos = (Vector3f)Vector3f.sub(targetWheelPos, currentWheelPos, null).scale(this.getVehicleType().wheelSpringStrength);
            if (!(dPos.length() > 0.001f)) continue;
            wheel.func_70091_d(MoverType.PLAYER, dPos.x, dPos.y, dPos.z);
            dPos.scale(0.5f);
            Vector3f.sub(amountToMoveCar, dPos, amountToMoveCar);
        }
        this.func_70091_d(MoverType.PLAYER, amountToMoveCar.x, amountToMoveCar.y, amountToMoveCar.z);
        if (this.wheels[0] != null && this.wheels[1] != null && this.wheels[2] != null && this.wheels[3] != null) {
            Vector3f vector3f = new Vector3f((this.wheels[2].field_70165_t + this.wheels[3].field_70165_t) / 2.0, (this.wheels[2].field_70163_u + this.wheels[3].field_70163_u) / 2.0, (this.wheels[2].field_70161_v + this.wheels[3].field_70161_v) / 2.0);
            Vector3f backAxleCentre = new Vector3f((this.wheels[0].field_70165_t + this.wheels[1].field_70165_t) / 2.0, (this.wheels[0].field_70163_u + this.wheels[1].field_70163_u) / 2.0, (this.wheels[0].field_70161_v + this.wheels[1].field_70161_v) / 2.0);
            Vector3f leftSideCentre = new Vector3f((this.wheels[0].field_70165_t + this.wheels[3].field_70165_t) / 2.0, (this.wheels[0].field_70163_u + this.wheels[3].field_70163_u) / 2.0, (this.wheels[0].field_70161_v + this.wheels[3].field_70161_v) / 2.0);
            Vector3f rightSideCentre = new Vector3f((this.wheels[1].field_70165_t + this.wheels[2].field_70165_t) / 2.0, (this.wheels[1].field_70163_u + this.wheels[2].field_70163_u) / 2.0, (this.wheels[1].field_70161_v + this.wheels[2].field_70161_v) / 2.0);
            float dx = vector3f.x - backAxleCentre.x;
            float dy = vector3f.y - backAxleCentre.y;
            float dz = vector3f.z - backAxleCentre.z;
            float drx = leftSideCentre.x - rightSideCentre.x;
            float dry = leftSideCentre.y - rightSideCentre.y;
            float drz = leftSideCentre.z - rightSideCentre.z;
            float dxz = (float)Math.sqrt(dx * dx + dz * dz);
            float drxz = (float)Math.sqrt(drx * drx + drz * drz);
            float yaw = (float)Math.atan2(dz, dx);
            float pitch = -((float)Math.atan2(dy, dxz));
            float roll = 0.0f;
            if (type.canRoll) {
                roll = -((float)Math.atan2(dry, drxz));
            }
            if (type.tank) {
                yaw = (float)Math.atan2(this.wheels[3].field_70161_v - this.wheels[2].field_70161_v, this.wheels[3].field_70165_t - this.wheels[2].field_70165_t) + 1.5707964f;
            }
            this.axes.setAngles(yaw * 180.0f / 3.14159f, pitch * 180.0f / 3.14159f, roll * 180.0f / 3.14159f);
        }
        this.checkForCollisions();
        if (this.throttle > 0.01f && this.throttle < 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.startSound, false);
            this.soundPosition = type.startSoundLength;
        }
        if (this.throttle > 0.2f && this.soundPosition == 0 && this.hasEnoughFuel()) {
            PacketPlaySound.sendSoundPacket(this.field_70165_t, this.field_70163_u, this.field_70161_v, 50.0, this.field_71093_bK, type.engineSound, false);
            this.soundPosition = type.engineSoundLength;
        }
        for (EntitySeat seat : this.getSeats()) {
            if (seat == null) continue;
            seat.updatePosition();
        }
        if ((this.field_70118_ct != this.field_70165_t || this.field_70117_cu != this.field_70163_u || this.field_70116_cv != this.field_70161_v || this.serverYaw != (double)this.axes.getYaw()) && thePlayerIsDrivingThis) {
            FlansMod.getPacketHandler().sendToServer(new PacketVehicleControl(this));
            this.field_70118_ct = this.field_70165_t;
            this.field_70117_cu = this.field_70163_u;
            this.field_70116_cv = this.field_70161_v;
            this.serverYaw = this.axes.getYaw();
        }
        int n = 4;
        if ((double)this.throttle > 0.05 && (double)this.throttle <= 0.33 || (double)this.throttle < -0.05 && (double)this.throttle >= -0.33) {
            int n2 = 3;
        } else if ((double)this.throttle > 0.33 && (double)this.throttle <= 0.66 || (double)this.throttle < -0.33 && (double)this.throttle >= -0.66) {
            int n3 = 2;
        } else if ((double)this.throttle > 0.66 && (double)this.throttle <= 0.9 || (double)this.throttle < -0.66 && (double)this.throttle >= -0.9) {
            boolean bl = true;
        } else if ((double)this.throttle > 0.9 && this.throttle <= 1.0f || (double)this.throttle < -0.9 && this.throttle >= -1.0f) {
            boolean bl = false;
        }
        if ((double)this.throttle > 0.05) {
            --this.animCount;
        } else if ((double)this.throttle < -0.05) {
            ++this.animCount;
        }
        if (this.animCount <= 0) {
            this.animCount = var5_15;
            ++this.animFrame;
        }
        if (this.throttle < 0.0f && this.animCount >= var5_15) {
            this.animCount = 0;
            --this.animFrame;
        }
        if (type.animFrames != 0) {
            if (this.animFrame > type.animFrames) {
                this.animFrame = 0;
            }
            if (this.animFrame < 0) {
                this.animFrame = type.animFrames;
            }
        }
        this.PostUpdate();
    }

    private boolean canThrust(DriveableData data, EntityPlayer driver) {
        return !TeamsManager.vehiclesNeedFuel || this.driverIsCreative() || data.engine != null && data.fuelInTank > data.engine.fuelConsumption * this.throttle;
    }

    public void animateFancyTracks() {
        int part;
        float newAngle;
        float speed;
        int i;
        float funkypart = this.getVehicleType().trackLinkFix;
        boolean funk = this.getVehicleType().flipLinkFix;
        float funk2 = 0.0f;
        for (i = 0; i < this.trackLinksLeft.length; ++i) {
            this.trackLinksLeft[i].prevPosition = this.trackLinksLeft[i].position;
            this.trackLinksLeft[i].prevZRot = this.trackLinksLeft[i].zRot;
            speed = this.throttle * 1.5f - this.wheelsYaw / 12.0f;
            this.trackLinksLeft[i].progress += speed;
            if (this.trackLinksLeft[i].progress > this.leftTrack.getTrackLength()) {
                this.trackLinksLeft[i].progress -= this.leftTrack.getTrackLength();
            }
            if (this.trackLinksLeft[i].progress < 0.0f) {
                this.trackLinksLeft[i].progress += this.leftTrack.getTrackLength();
            }
            this.trackLinksLeft[i].position = this.leftTrack.getPositionOnTrack(this.trackLinksLeft[i].progress);
            while (this.trackLinksLeft[i].zRot > 180.0f) {
                this.trackLinksLeft[i].zRot -= 360.0f;
            }
            while (this.trackLinksLeft[i].zRot <= -180.0f) {
                this.trackLinksLeft[i].zRot += 360.0f;
            }
            newAngle = this.rotateTowards(this.leftTrack.points.get(this.leftTrack.getTrackPart(this.trackLinksLeft[i].progress)), this.trackLinksLeft[i].position);
            part = this.leftTrack.getTrackPart(this.trackLinksLeft[i].progress);
            funk2 = funk ? (speed < 0.0f ? 0.0f : 1.0f) : (speed < 0.0f ? -1.0f : 0.0f);
            this.trackLinksLeft[i].zRot = this.Lerp(this.trackLinksLeft[i].zRot, newAngle, (float)part != funkypart + funk2 ? 0.5f : 1.0f);
        }
        for (i = 0; i < this.trackLinksRight.length; ++i) {
            this.trackLinksRight[i].prevPosition = this.trackLinksRight[i].position;
            this.trackLinksRight[i].prevZRot = this.trackLinksRight[i].zRot;
            speed = this.throttle * 1.5f + this.wheelsYaw / 12.0f;
            this.trackLinksRight[i].progress += speed;
            if (this.trackLinksRight[i].progress > this.rightTrack.getTrackLength()) {
                this.trackLinksRight[i].progress -= this.leftTrack.getTrackLength();
            }
            if (this.trackLinksRight[i].progress < 0.0f) {
                this.trackLinksRight[i].progress += this.rightTrack.getTrackLength();
            }
            this.trackLinksRight[i].position = this.rightTrack.getPositionOnTrack(this.trackLinksRight[i].progress);
            newAngle = this.rotateTowards(this.rightTrack.points.get(this.rightTrack.getTrackPart(this.trackLinksRight[i].progress)), this.trackLinksRight[i].position);
            part = this.rightTrack.getTrackPart(this.trackLinksRight[i].progress);
            funk2 = funk ? (speed < 0.0f ? 0.0f : 1.0f) : (speed < 0.0f ? -1.0f : 0.0f);
            this.trackLinksRight[i].zRot = this.Lerp(this.trackLinksRight[i].zRot, newAngle, (float)part != funkypart + funk2 ? 0.5f : 1.0f);
        }
    }

    public float rotateTowards(Vector3f point, Vector3f original) {
        float angle = (float)Math.atan2(point.y - original.y, point.x - original.x);
        return angle;
    }

    public float Lerp(float start, float end, float percent) {
        float result = start + percent * (end - start);
        return result;
    }

    public static float Clamp(float val, float min, float max) {
        return Math.max(min, Math.min(max, val));
    }

    private float averageAngles(float a, float b) {
        float avg;
        FlansMod.log.debug("Pre  " + a + " " + b);
        float pi = (float)Math.PI;
        while (a > b + pi) {
            a -= 2.0f * pi;
        }
        while (a < b - pi) {
            a += 2.0f * pi;
        }
        for (avg = (a + b) / 2.0f; avg > pi; avg -= 2.0f * pi) {
        }
        while (avg < -pi) {
            avg += 2.0f * pi;
        }
        FlansMod.log.debug("Post " + a + " " + b + " " + avg);
        return avg;
    }

    private Vec3d subtract(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72450_a - b.field_72450_a, a.field_72448_b - b.field_72448_b, a.field_72449_c - b.field_72449_c);
    }

    private Vec3d crossProduct(Vec3d a, Vec3d b) {
        return new Vec3d(a.field_72448_b * b.field_72449_c - a.field_72449_c * b.field_72448_b, a.field_72449_c * b.field_72450_a - a.field_72450_a * b.field_72449_c, a.field_72450_a * b.field_72448_b - a.field_72448_b * b.field_72450_a);
    }

    @Override
    public boolean landVehicle() {
        return true;
    }

    @Override
    public boolean func_70097_a(DamageSource damagesource, float i) {
        if (this.field_70170_p.field_72995_K || this.field_70128_L) {
            return true;
        }
        VehicleType type = this.getVehicleType();
        if (damagesource.field_76373_n.equals("player") && damagesource.func_76346_g().field_70122_E && (this.getSeat(0) == null || this.getSeat(0).func_184179_bs() == null)) {
            ItemStack vehicleStack = new ItemStack(type.item, 1, this.driveableData.paintjobID);
            NBTTagCompound tags = new NBTTagCompound();
            vehicleStack.func_77982_d(tags);
            this.driveableData.writeToNBT(tags);
            this.func_70099_a(vehicleStack, 0.5f);
            this.func_70106_y();
        }
        return true;
    }

    public VehicleType getVehicleType() {
        return VehicleType.getVehicle(this.driveableType);
    }

    @Override
    public float getPlayerRoll() {
        return this.axes.getRoll();
    }

    @Override
    protected void dropItemsOnPartDeath(Vector3f midpoint, DriveablePart part) {
    }

    @Override
    public String getBombInventoryName() {
        return "Mines";
    }

    @Override
    public String getMissileInventoryName() {
        return "Shells";
    }

    @Override
    public boolean hasMouseControlMode() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public EntityLivingBase getCamera() {
        return null;
    }

    @Override
    public void func_70106_y() {
        super.func_70106_y();
    }
}

