/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.driveables;

import com.flansmod.client.model.ModelPlane;
import com.flansmod.common.FlansMod;
import com.flansmod.common.driveables.DriveableData;
import com.flansmod.common.driveables.DriveablePart;
import com.flansmod.common.driveables.DriveableType;
import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EnumDriveablePart;
import com.flansmod.common.driveables.EnumPlaneMode;
import com.flansmod.common.driveables.Propeller;
import com.flansmod.common.parts.PartType;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import com.flansmod.common.vector.Vector3f;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;

public class PlaneType
extends DriveableType {
    public EnumPlaneMode mode = EnumPlaneMode.PLANE;
    public float lookDownModifier = 1.0f;
    public float lookUpModifier = 1.0f;
    public float rollLeftModifier = 1.0f;
    public float rollRightModifier = 1.0f;
    public float turnLeftModifier = 1.0f;
    public float turnRightModifier = 1.0f;
    public float lift = 1.0f;
    public Vector3f bombPosition;
    public int planeShootDelay;
    public int planeBombDelay;
    public ArrayList<Propeller> propellers = new ArrayList();
    public ArrayList<Propeller> heliPropellers = new ArrayList();
    public ArrayList<Propeller> heliTailPropellers = new ArrayList();
    public boolean hasGear = false;
    public boolean hasDoor = false;
    public boolean hasWing = false;
    public float restingPitch = 0.0f;
    public boolean invInflight = true;
    public static ArrayList<PlaneType> types = new ArrayList();
    private static HashMap<String, InfoType.ParseFunc<PlaneType>> parsers = new HashMap();

    @Override
    protected void read(String[] split, TypeFile file) {
        try {
            InfoType.ParseFunc<PlaneType> parser = parsers.get(split[0]);
            if (parser != null) {
                parser.Parse(split, this);
            } else {
                super.read(split, file);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public PlaneType(TypeFile file) {
        super(file);
        types.add(this);
    }

    @Override
    public void preRead(TypeFile file) {
        super.preRead(file);
    }

    @Override
    public int numEngines() {
        switch (this.mode) {
            case VTOL: {
                return Math.max(this.propellers.size(), this.heliPropellers.size());
            }
            case PLANE: {
                return this.propellers.size();
            }
            case HELI: {
                return this.heliPropellers.size();
            }
        }
        return 1;
    }

    @Override
    public ArrayList<ItemStack> getItemsRequired(DriveablePart part, PartType engine) {
        ArrayList<ItemStack> stacks = super.getItemsRequired(part, engine);
        for (Propeller propeller : this.propellers) {
            if (propeller.planePart != part.type) continue;
            stacks.add(new ItemStack(propeller.itemType.item));
            stacks.add(new ItemStack(engine.item));
        }
        return stacks;
    }

    public static PlaneType getPlane(String find) {
        for (PlaneType type : types) {
            if (!type.shortName.equals(find)) continue;
            return type;
        }
        return null;
    }

    @Override
    public void reloadModel() {
        this.model = FlansMod.proxy.loadModel(this.modelString, this.shortName, ModelPlane.class);
    }

    @Override
    public EntityDriveable createDriveable(World world, double x, double y, double z, DriveableData data) {
        return new EntityPlane(world, x, y, z, this, data);
    }

    static {
        parsers.put("Mode", (split, d) -> {
            d.mode = EnumPlaneMode.getMode(split[1]);
        });
        parsers.put("TurnLeftSpeed", (split, d) -> {
            d.turnLeftModifier = Float.parseFloat(split[1]);
        });
        parsers.put("TurnRightSpeed", (split, d) -> {
            d.turnRightModifier = Float.parseFloat(split[1]);
        });
        parsers.put("LookUpSpeed", (split, d) -> {
            d.lookUpModifier = Float.parseFloat(split[1]);
        });
        parsers.put("LookDownSpeed", (split, d) -> {
            d.lookDownModifier = Float.parseFloat(split[1]);
        });
        parsers.put("RollLeftSpeed", (split, d) -> {
            d.rollLeftModifier = Float.parseFloat(split[1]);
        });
        parsers.put("RollRightSpeed", (split, d) -> {
            d.rollRightModifier = Float.parseFloat(split[1]);
        });
        parsers.put("Lift", (split, d) -> {
            d.lift = Float.parseFloat(split[1]);
        });
        parsers.put("ShootDelay", (split, d) -> {
            d.planeShootDelay = Integer.parseInt(split[1]);
        });
        parsers.put("BombDelay", (split, d) -> {
            d.planeBombDelay = Integer.parseInt(split[1]);
        });
        parsers.put("Propeller", (split, d) -> {
            Propeller propeller = new Propeller(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), EnumDriveablePart.getPart(split[5]), PartType.getPart(split[6]));
            d.propellers.add(propeller);
            d.driveableRecipe.add(new ItemStack(propeller.itemType.item));
        });
        parsers.put("HeliPropeller", (split, d) -> {
            Propeller propeller = new Propeller(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), EnumDriveablePart.getPart(split[5]), PartType.getPart(split[6]));
            d.heliPropellers.add(propeller);
            d.driveableRecipe.add(new ItemStack(propeller.itemType.item));
        });
        parsers.put("HeliTailPropeller", (split, d) -> {
            Propeller propeller = new Propeller(Integer.parseInt(split[1]), Integer.parseInt(split[2]), Integer.parseInt(split[3]), Integer.parseInt(split[4]), EnumDriveablePart.getPart(split[5]), PartType.getPart(split[6]));
            d.heliTailPropellers.add(propeller);
            d.driveableRecipe.add(new ItemStack(propeller.itemType.item));
        });
        parsers.put("PropSoundLength", (split, d) -> {
            d.engineSoundLength = Integer.parseInt(split[1]);
        });
        parsers.put("PropSound", (split, d) -> {
            d.engineSound = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("ShootSound", (split, d) -> {
            d.shootSoundPrimary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("BombSound", (split, d) -> {
            d.shootSoundSecondary = split[1];
            FlansMod.proxy.loadSound(d.contentPack, "driveables", split[1]);
        });
        parsers.put("HasGear", (split, d) -> {
            d.hasGear = Boolean.parseBoolean(split[1]);
        });
        parsers.put("HasDoor", (split, d) -> {
            d.hasDoor = Boolean.parseBoolean(split[1]);
        });
        parsers.put("HasWing", (split, d) -> {
            d.hasWing = Boolean.parseBoolean(split[1]);
        });
        parsers.put("RestingPitch", (split, d) -> {
            d.restingPitch = Float.parseFloat(split[1]);
        });
        parsers.put("InflightInventory", (split, d) -> {
            d.invInflight = Boolean.parseBoolean(split[1]);
        });
    }
}

