/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.network;

import com.flansmod.common.driveables.EntityDriveable;
import com.flansmod.common.driveables.EntityPlane;
import com.flansmod.common.driveables.EntityVehicle;
import com.flansmod.common.network.PacketBase;
import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class PacketDriveableControl
extends PacketBase {
    public int entityId;
    public double posX;
    public double posY;
    public double posZ;
    public float yaw;
    public float pitch;
    public float roll;
    public double motX;
    public double motY;
    public double motZ;
    public float avelx;
    public float avely;
    public float avelz;
    public float throttle;
    public float fuelInTank;
    public float steeringYaw;

    public PacketDriveableControl() {
    }

    public PacketDriveableControl(EntityDriveable driveable) {
        this.entityId = driveable.func_145782_y();
        this.posX = driveable.field_70165_t;
        this.posY = driveable.field_70163_u;
        this.posZ = driveable.field_70161_v;
        this.yaw = driveable.axes.getYaw();
        this.pitch = driveable.axes.getPitch();
        this.roll = driveable.axes.getRoll();
        this.motX = driveable.field_70159_w;
        this.motY = driveable.field_70181_x;
        this.motZ = driveable.field_70179_y;
        this.avelx = driveable.angularVelocity.x;
        this.avely = driveable.angularVelocity.y;
        this.avelz = driveable.angularVelocity.z;
        this.throttle = driveable.throttle;
        this.fuelInTank = driveable.driveableData.fuelInTank;
        if (driveable instanceof EntityVehicle) {
            EntityVehicle veh = (EntityVehicle)driveable;
            this.steeringYaw = veh.wheelsYaw;
        } else if (driveable instanceof EntityPlane) {
            EntityPlane plane = (EntityPlane)driveable;
            this.steeringYaw = plane.flapsYaw;
        }
    }

    @Override
    public void encodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        data.writeInt(this.entityId);
        data.writeDouble(this.posX);
        data.writeDouble(this.posY);
        data.writeDouble(this.posZ);
        data.writeFloat(this.yaw);
        data.writeFloat(this.pitch);
        data.writeFloat(this.roll);
        data.writeDouble(this.motX);
        data.writeDouble(this.motY);
        data.writeDouble(this.motZ);
        data.writeFloat(this.avelx);
        data.writeFloat(this.avely);
        data.writeFloat(this.avelz);
        data.writeFloat(this.throttle);
        data.writeFloat(this.fuelInTank);
        data.writeFloat(this.steeringYaw);
    }

    @Override
    public void decodeInto(ChannelHandlerContext ctx, ByteBuf data) {
        this.entityId = data.readInt();
        this.posX = data.readDouble();
        this.posY = data.readDouble();
        this.posZ = data.readDouble();
        this.yaw = data.readFloat();
        this.pitch = data.readFloat();
        this.roll = data.readFloat();
        this.motX = data.readDouble();
        this.motY = data.readDouble();
        this.motZ = data.readDouble();
        this.avelx = data.readFloat();
        this.avely = data.readFloat();
        this.avelz = data.readFloat();
        this.throttle = data.readFloat();
        this.fuelInTank = data.readFloat();
        this.steeringYaw = data.readFloat();
    }

    @Override
    public void handleServerSide(EntityPlayerMP playerEntity) {
        if (playerEntity == null || playerEntity.field_70170_p == null || playerEntity.field_70170_p.field_72996_f == null) {
            return;
        }
        EntityDriveable driveable = null;
        for (int i = 0; i < playerEntity.field_70170_p.field_72996_f.size(); ++i) {
            Entity obj = (Entity)playerEntity.field_70170_p.field_72996_f.get(i);
            if (!(obj instanceof EntityDriveable) || obj.func_145782_y() != this.entityId) continue;
            driveable = (EntityDriveable)obj;
            break;
        }
        if (driveable != null) {
            this.updateDriveable(driveable, false);
        }
    }

    protected void updateDriveable(EntityDriveable driveable, boolean clientSide) {
        driveable.setPositionRotationAndMotion(this.posX, this.posY, this.posZ, this.yaw, this.pitch, this.roll, this.motX, this.motY, this.motZ, this.avelx, this.avely, this.avelz, this.throttle, this.steeringYaw);
        driveable.driveableData.fuelInTank = this.fuelInTank;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void handleClientSide(EntityPlayer clientPlayer) {
        if (clientPlayer == null || clientPlayer.field_70170_p == null) {
            return;
        }
        EntityDriveable driveable = null;
        for (Object obj : clientPlayer.field_70170_p.field_72996_f) {
            if (!(obj instanceof EntityDriveable) || ((Entity)obj).func_145782_y() != this.entityId) continue;
            driveable = (EntityDriveable)obj;
            driveable.driveableData.fuelInTank = this.fuelInTank;
            if (driveable.getSeat(0) == null || driveable.getSeat(0).func_184179_bs() != clientPlayer) break;
            return;
        }
        if (driveable != null) {
            this.updateDriveable(driveable, true);
        }
    }
}

