/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.paintjob;

import com.flansmod.client.handlers.FlansModResourceHandler;
import com.flansmod.common.FlansMod;
import com.flansmod.common.guns.Paintjob;
import com.flansmod.common.paintjob.IPaintableItem;
import com.flansmod.common.types.InfoType;
import com.flansmod.common.types.TypeFile;
import java.util.ArrayList;
import java.util.HashMap;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.storage.loot.LootEntry;
import net.minecraft.world.storage.loot.LootEntryItem;
import net.minecraft.world.storage.loot.LootPool;
import net.minecraft.world.storage.loot.RandomValueRange;
import net.minecraft.world.storage.loot.conditions.LootCondition;
import net.minecraft.world.storage.loot.functions.LootFunction;
import net.minecraft.world.storage.loot.functions.SetDamage;
import net.minecraftforge.event.LootTableLoadEvent;

public abstract class PaintableType
extends InfoType {
    public ArrayList<Paintjob> paintjobs = new ArrayList();
    public ArrayList<Paintjob> nonlegendarypaintjobs = new ArrayList();
    public Paintjob defaultPaintjob;
    private int nextPaintjobID = 1;
    private static HashMap<Integer, PaintableType> paintableTypes = new HashMap();

    public static PaintableType GetPaintableType(int iHash) {
        return paintableTypes.get(iHash);
    }

    public static PaintableType GetPaintableType(String name) {
        return paintableTypes.get(name.hashCode());
    }

    public PaintableType(TypeFile file) {
        super(file);
    }

    @Override
    public void postRead(TypeFile file) {
        super.postRead(file);
        this.defaultPaintjob = new Paintjob(this, 0, "", this.texture, new ItemStack[0]);
        ArrayList<Paintjob> newPaintjobList = new ArrayList<Paintjob>();
        newPaintjobList.add(this.defaultPaintjob);
        newPaintjobList.addAll(this.paintjobs);
        this.paintjobs = newPaintjobList;
        if (infoTypes.containsKey(this.shortName.hashCode())) {
            FlansMod.Assert(false, "Duplicate info type name " + this.shortName);
        }
        this.nonlegendarypaintjobs.clear();
        for (Paintjob p : this.paintjobs) {
            if (p.IsLegendary()) continue;
            this.nonlegendarypaintjobs.add(p);
        }
        totalDungeonChance += this.dungeonChance * (this.nonlegendarypaintjobs.size() - 1);
        paintableTypes.put(this.shortName.hashCode(), this);
    }

    @Override
    protected void read(String[] split, TypeFile file) {
        super.read(split, file);
        try {
            if (this.KeyMatches(split, "Paintjob")) {
                int indexOf_;
                ItemStack[] dyeStacks = new ItemStack[(split.length - 3) / 2];
                for (int i = 0; i < (split.length - 3) / 2; ++i) {
                    dyeStacks[i] = split[i * 2 + 3].equals("rainbow") ? new ItemStack(FlansMod.rainbowPaintcan, Integer.parseInt(split[i * 2 + 4])) : new ItemStack(Items.field_151100_aR, Integer.parseInt(split[i * 2 + 4]), this.getDyeDamageValue(split[i * 2 + 3]));
                }
                if (split[1].contains("_") && (indexOf_ = split[1].indexOf(95)) != -1 && split[1].toLowerCase().startsWith(this.iconPath.toLowerCase())) {
                    split[1] = split[1].substring(indexOf_ + 1);
                }
                this.paintjobs.add(new Paintjob(this, this.nextPaintjobID++, split[1], split[2], dyeStacks));
            }
        }
        catch (Exception e) {
            FlansMod.log.error("Reading file failed : " + this.shortName);
            FlansMod.log.throwing((Throwable)e);
        }
    }

    public Paintjob getPaintjob(String s) {
        for (Paintjob paintjob : this.paintjobs) {
            if (paintjob.textureName.equals(s)) {
                return paintjob;
            }
            if (!paintjob.iconName.equals(s)) continue;
            FlansMod.Assert(false, "Not sure this should be the right way to find a paintjob");
            return paintjob;
        }
        FlansMod.Assert(false, "Could not find paintjob " + s);
        return this.defaultPaintjob;
    }

    public Paintjob getPaintjob(int i) {
        if (0 <= i && i < this.paintjobs.size()) {
            return this.paintjobs.get(i);
        }
        return this.defaultPaintjob;
    }

    @Override
    public void addLoot(LootTableLoadEvent event) {
        if (this.dungeonChance > 0) {
            LootPool pool = event.getTable().getPool("FlansMod");
            if (pool == null) {
                pool = new LootPool(new LootEntry[0], new LootCondition[0], new RandomValueRange(1.0f, 1.0f), new RandomValueRange(1.0f, 1.0f), "FlansMod");
                event.getTable().addPool(pool);
            }
            if (pool != null) {
                LootEntryItem entry = new LootEntryItem(this.item, FlansMod.dungeonLootChance * this.dungeonChance, 1, new LootFunction[]{new SetDamage(new LootCondition[0], new RandomValueRange(0.0f, (float)(this.nonlegendarypaintjobs.size() - 1)))}, new LootCondition[0], this.shortName);
                pool.addEntry((LootEntry)entry);
            }
        }
    }

    public float GetRecommendedScale() {
        return 50.0f;
    }

    public static boolean HasCustomPaintjob(ItemStack stack) {
        if (stack == null || stack.func_190926_b()) {
            return false;
        }
        if (stack.func_77973_b() instanceof IPaintableItem) {
            return stack.func_77978_p().func_74764_b("CustomPaint");
        }
        return false;
    }

    public static ResourceLocation GetCustomPaintjobSkinResource(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("CustomPaint");
        int customPaintHash = tags.func_74762_e("Hash");
        if (!FlansModResourceHandler.HasResourceForHash(customPaintHash)) {
            FlansModResourceHandler.CreateSkinResourceFromByteArray(tags.func_74770_j("Skin"), tags.func_74762_e("SkinWidth"), tags.func_74762_e("SkinHeight"), customPaintHash);
            FlansModResourceHandler.CreateIconResourceFromByteArray(tags.func_74770_j("Icon"), tags.func_74762_e("IconWidth"), tags.func_74762_e("IconHeight"), customPaintHash);
        }
        return FlansModResourceHandler.GetSkinResourceFromHash(customPaintHash);
    }

    public static ResourceLocation GetCustomPaintjobIconResource(ItemStack stack) {
        NBTTagCompound tags = stack.func_77978_p().func_74775_l("CustomPaint");
        int customPaintHash = tags.func_74762_e("Hash");
        if (!FlansModResourceHandler.HasResourceForHash(customPaintHash)) {
            FlansModResourceHandler.CreateSkinResourceFromByteArray(tags.func_74770_j("Skin"), tags.func_74762_e("SkinWidth"), tags.func_74762_e("SkinHeight"), customPaintHash);
            FlansModResourceHandler.CreateIconResourceFromByteArray(tags.func_74770_j("Icon"), tags.func_74762_e("IconWidth"), tags.func_74762_e("IconHeight"), customPaintHash);
        }
        return FlansModResourceHandler.GetIconResourceFromHash(customPaintHash);
    }
}

