/*
 * Decompiled with CFR 0.152.
 */
package com.flansmod.common.teams;

import com.flansmod.common.EntityItemCustomRender;
import com.flansmod.common.PlayerHandler;
import com.flansmod.common.teams.Team;
import com.flansmod.common.teams.TeamsManager;
import com.flansmod.common.teams.TileEntitySpawner;
import io.netty.buffer.ByteBuf;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.DamageSource;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;

public class EntityTeamItem
extends EntityItemCustomRender
implements IEntityAdditionalSpawnData {
    public TileEntitySpawner spawner;
    public double angle;
    public int xCoord;
    public int yCoord;
    public int zCoord;
    private int age;

    public EntityTeamItem(TileEntitySpawner te, int i) {
        super(te.func_145831_w(), (float)te.func_174877_v().func_177958_n() + 0.5f, (float)te.func_174877_v().func_177956_o() + 0.5f, (float)te.func_174877_v().func_177952_p() + 0.5f, te.stacksToSpawn.get(i).func_77946_l());
        te.itemEntities.add(this);
        this.angle = (double)i * Math.PI * 2.0 / (double)te.stacksToSpawn.size();
        this.field_70179_y = 0.0;
        this.field_70181_x = 0.0;
        this.field_70159_w = 0.0;
        this.lifespan = 1000000000;
        this.spawner = te;
    }

    public EntityTeamItem(World world) {
        super(world);
    }

    public void func_180426_a(double x, double y, double z, float yaw, float pitch, int i, boolean b) {
    }

    public void func_70071_h_() {
        ++this.field_70173_aa;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        this.field_70126_B = this.field_70177_z;
        ++this.age;
        if (this.field_70170_p.field_72995_K) {
            this.angle += 0.05;
            this.func_70107_b((double)((float)this.xCoord + 0.5f) + Math.cos(this.angle) * (double)0.3f, (float)this.yCoord + 0.5f, (double)((float)this.zCoord + 0.5f) + Math.sin(this.angle) * (double)0.3f);
        }
        if (this.field_70170_p.field_72995_K) {
            this.func_70066_B();
        }
    }

    public boolean attackEntityFrom(DamageSource par1DamageSource, int par2) {
        return false;
    }

    public void func_70100_b_(EntityPlayer player) {
        if (!this.field_70170_p.field_72995_K) {
            EntityItemPickupEvent event = new EntityItemPickupEvent(player, (EntityItem)this);
            if (MinecraftForge.EVENT_BUS.post((Event)event)) {
                return;
            }
            int spawnerTeamID = this.spawner.getTeamID();
            Team spawnerTeam = TeamsManager.getInstance().getTeam(spawnerTeamID);
            Team playerTeam = PlayerHandler.getPlayerData((EntityPlayer)player).team;
            if (spawnerTeam != null && playerTeam != spawnerTeam) {
                return;
            }
            int var2 = this.func_92059_d().func_190916_E();
            if (event.getResult() == Event.Result.ALLOW || var2 <= 0 || player.field_71071_by.func_70441_a(this.func_92059_d())) {
                FMLCommonHandler.instance().firePlayerItemPickupEvent(player, (EntityItem)this, this.func_92059_d().func_77946_l());
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                player.func_71001_a((Entity)this, var2);
                if (this.func_92059_d().func_190916_E() <= 0) {
                    this.spawner.itemEntities.remove((Object)this);
                    this.func_70106_y();
                }
            }
        }
    }

    public void writeSpawnData(ByteBuf data) {
        if (this.spawner == null) {
            data.writeInt(0);
            data.writeInt(0);
            data.writeInt(0);
        } else {
            data.writeInt(this.spawner.func_174877_v().func_177958_n());
            data.writeInt(this.spawner.func_174877_v().func_177956_o());
            data.writeInt(this.spawner.func_174877_v().func_177952_p());
        }
        data.writeDouble(this.angle);
        NBTTagCompound tags = new NBTTagCompound();
        this.func_92059_d().func_77955_b(tags);
        ByteBufUtils.writeTag((ByteBuf)data, (NBTTagCompound)tags);
    }

    public void readSpawnData(ByteBuf data) {
        this.xCoord = data.readInt();
        this.yCoord = data.readInt();
        this.zCoord = data.readInt();
        this.angle = data.readDouble();
        this.func_92058_a(new ItemStack(ByteBufUtils.readTag((ByteBuf)data)));
    }

    public void func_70037_a(NBTTagCompound tags) {
        this.func_70106_y();
    }

    public boolean func_70027_ad() {
        return false;
    }
}

